/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.trie;

import edu.cmu.sphinx.linguist.language.ngram.trie.NgramTrieBitarr;
import edu.cmu.sphinx.linguist.language.ngram.trie.NgramTrieModel;
import edu.cmu.sphinx.linguist.language.ngram.trie.NgramTrieQuant;

public class NgramTrie {
    private MiddleNgramSet[] middles;
    private LongestNgramSet longest;
    private NgramTrieBitarr bitArr;
    private int ordersNum;
    private int quantProbBoLen;
    private int quantProbLen;

    public NgramTrie(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int[] nArray2 = new int[nArray.length - 1];
        for (int i = 1; i <= nArray.length - 1; ++i) {
            n4 = this.requiredBits(nArray[0]);
            if (i == nArray.length - 1) {
                n4 += n2;
            } else {
                n4 += this.requiredBits(nArray[i + 1]);
                n4 += n;
            }
            nArray2[i - 1] = n3 = ((1 + nArray[i]) * n4 + 7) / 8 + 8;
            n5 += n3;
        }
        this.bitArr = new NgramTrieBitarr(n5);
        this.quantProbLen = n2;
        this.quantProbBoLen = n;
        this.middles = new MiddleNgramSet[nArray.length - 2];
        int[] nArray3 = new int[nArray.length - 2];
        n4 = 0;
        for (n3 = 0; n3 < nArray.length - 2; ++n3) {
            nArray3[n3] = n4;
            n4 += nArray2[n3];
        }
        for (n3 = nArray.length - 1; n3 >= 2; --n3) {
            this.middles[n3 - 2] = new MiddleNgramSet(nArray3[n3 - 2], n, nArray[n3 - 1], nArray[0], nArray[n3]);
        }
        this.longest = new LongestNgramSet(n4, n2, nArray[0]);
        this.ordersNum = this.middles.length + 1;
    }

    public byte[] getMem() {
        return this.bitArr.getArr();
    }

    private int findNgram(NgramSet ngramSet, int n, NgramTrieModel.TrieRange trieRange) {
        --trieRange.begin;
        int n2 = this.uniformFind(ngramSet, trieRange, n);
        if (n2 < 0) {
            trieRange.setFound(false);
            return -1;
        }
        if (ngramSet instanceof MiddleNgramSet) {
            ((MiddleNgramSet)ngramSet).readNextRange(n2, trieRange);
        }
        return n2;
    }

    public float readNgramBackoff(int n, int n2, NgramTrieModel.TrieRange trieRange, NgramTrieQuant ngramTrieQuant) {
        NgramSet ngramSet = this.getNgram(n2);
        int n3 = this.findNgram(ngramSet, n, trieRange);
        if (n3 < 0) {
            return 0.0f;
        }
        return ngramTrieQuant.readBackoff(this.bitArr, ngramSet.memPtr, ngramSet.getNgramWeightsOffset(n3), n2);
    }

    public float readNgramProb(int n, int n2, NgramTrieModel.TrieRange trieRange, NgramTrieQuant ngramTrieQuant) {
        NgramSet ngramSet = this.getNgram(n2);
        int n3 = this.findNgram(ngramSet, n, trieRange);
        if (n3 < 0) {
            return 0.0f;
        }
        return ngramTrieQuant.readProb(this.bitArr, ngramSet.memPtr, ngramSet.getNgramWeightsOffset(n3), n2);
    }

    private int calculatePivot(int n, int n2, int n3) {
        return (int)((long)n * (long)n3 / (long)(n2 + 1));
    }

    private int uniformFind(NgramSet ngramSet, NgramTrieModel.TrieRange trieRange, int n) {
        NgramTrieModel.TrieRange trieRange2 = new NgramTrieModel.TrieRange(0, ngramSet.maxVocab);
        while (trieRange.getWidth() > 1) {
            int n2 = trieRange.begin + 1 + this.calculatePivot(n - trieRange2.begin, trieRange2.getWidth(), trieRange.getWidth() - 1);
            int n3 = ngramSet.readNgramWord(n2);
            if (n3 < n) {
                trieRange.begin = n2;
                trieRange2.begin = n3;
                continue;
            }
            if (n3 > n) {
                trieRange.end = n2;
                trieRange2.end = n3;
                continue;
            }
            return n2;
        }
        return -1;
    }

    private NgramSet getNgram(int n) {
        if (n == this.ordersNum - 1) {
            return this.longest;
        }
        return this.middles[n];
    }

    private int requiredBits(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = 1;
        while ((n >>= 1) != 0) {
            ++n2;
        }
        return n2;
    }

    class LongestNgramSet
    extends NgramSet {
        LongestNgramSet(int n, int n2, int n3) {
            super(n, n3, n2);
        }

        @Override
        int getQuantBits() {
            return NgramTrie.this.quantProbLen;
        }
    }

    class MiddleNgramSet
    extends NgramSet {
        int nextMask;
        int nextOrderMemPtr;

        MiddleNgramSet(int n, int n2, int n3, int n4, int n5) {
            super(n, n4, n2 + NgramTrie.this.requiredBits(n5));
            this.nextMask = (1 << NgramTrie.this.requiredBits(n5)) - 1;
            if (n3 + 1 >= 0x2000000 || n5 >= 0x2000000) {
                throw new Error("Sorry, current implementation doesn't support more than 33554432 n-grams of particular order");
            }
        }

        void readNextRange(int n, NgramTrieModel.TrieRange trieRange) {
            int n2 = n * this.totalBits;
            n2 += this.wordBits;
            trieRange.begin = NgramTrie.this.bitArr.readInt(this.memPtr, n2 += this.getQuantBits(), this.nextMask);
            trieRange.end = NgramTrie.this.bitArr.readInt(this.memPtr, n2 += this.totalBits, this.nextMask);
        }

        @Override
        int getQuantBits() {
            return NgramTrie.this.quantProbBoLen;
        }
    }

    abstract class NgramSet {
        int memPtr;
        int wordBits;
        int wordMask;
        int totalBits;
        int insertIdx;
        int maxVocab;

        NgramSet(int n, int n2, int n3) {
            this.maxVocab = n2;
            this.memPtr = n;
            this.wordBits = NgramTrie.this.requiredBits(n2);
            if (this.wordBits > 25) {
                throw new Error("Sorry, word indices more than33554432 are not implemented");
            }
            this.totalBits = this.wordBits + n3;
            this.wordMask = (1 << this.wordBits) - 1;
            this.insertIdx = 0;
        }

        int readNgramWord(int n) {
            int n2 = n * this.totalBits;
            return NgramTrie.this.bitArr.readInt(this.memPtr, n2, this.wordMask);
        }

        int getNgramWeightsOffset(int n) {
            return n * this.totalBits + this.wordBits;
        }

        abstract int getQuantBits();
    }
}

