/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.trie;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.linguist.language.ngram.trie.BinaryLoader;
import edu.cmu.sphinx.linguist.language.ngram.trie.NgramTrie;
import edu.cmu.sphinx.linguist.language.ngram.trie.NgramTrieQuant;
import edu.cmu.sphinx.linguist.util.LRUCache;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NgramTrieModel
implements LanguageModel {
    @S4String(mandatory=false)
    public static final String PROP_QUERY_LOG_FILE = "queryLogFile";
    @S4Integer(defaultValue=100000)
    public static final String PROP_NGRAM_CACHE_SIZE = "ngramCacheSize";
    @S4Boolean(defaultValue=false)
    public static final String PROP_CLEAR_CACHES_AFTER_UTTERANCE = "clearCachesAfterUtterance";
    @S4Double(defaultValue=1.0)
    public static final String PROP_LANGUAGE_WEIGHT = "languageWeight";
    @S4Boolean(defaultValue=false)
    public static final String PROP_APPLY_LANGUAGE_WEIGHT_AND_WIP = "applyLanguageWeightAndWip";
    @S4Double(defaultValue=1.0)
    public static final String PROP_WORD_INSERTION_PROBABILITY = "wordInsertionProbability";
    URL location;
    protected Logger logger;
    protected LogMath logMath;
    protected int maxDepth;
    protected int curDepth;
    protected int[] counts;
    protected int ngramCacheSize;
    protected boolean clearCacheAfterUtterance;
    protected Dictionary dictionary;
    protected String format;
    protected boolean applyLanguageWeightAndWip;
    protected float languageWeight;
    protected float unigramWeight;
    protected float logWip;
    protected String ngramLogFile;
    private int ngramMisses;
    private int ngramHits;
    private PrintWriter logFile;
    protected TrieUnigram[] unigrams;
    protected String[] words;
    protected NgramTrieQuant quant;
    protected NgramTrie trie;
    protected Map<Word, Integer> unigramIDMap;
    private LRUCache<WordSequence, Float> ngramProbCache;

    public NgramTrieModel(String string, URL uRL, String string2, int n, boolean bl, int n2, Dictionary dictionary, boolean bl2, float f, double d, float f2) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.format = string;
        this.location = uRL;
        this.ngramLogFile = string2;
        this.ngramCacheSize = n;
        this.clearCacheAfterUtterance = bl;
        this.maxDepth = n2;
        this.logMath = LogMath.getLogMath();
        this.dictionary = dictionary;
        this.applyLanguageWeightAndWip = bl2;
        this.languageWeight = f;
        this.logWip = this.logMath.linearToLog(d);
        this.unigramWeight = f2;
    }

    public NgramTrieModel() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logger = propertySheet.getLogger();
        this.logMath = LogMath.getLogMath();
        this.location = ConfigurationManagerUtils.getResource("location", propertySheet);
        this.ngramLogFile = propertySheet.getString(PROP_QUERY_LOG_FILE);
        this.maxDepth = propertySheet.getInt("maxDepth");
        this.ngramCacheSize = propertySheet.getInt(PROP_NGRAM_CACHE_SIZE);
        this.clearCacheAfterUtterance = propertySheet.getBoolean(PROP_CLEAR_CACHES_AFTER_UTTERANCE);
        this.dictionary = (Dictionary)propertySheet.getComponent("dictionary");
        this.applyLanguageWeightAndWip = propertySheet.getBoolean(PROP_APPLY_LANGUAGE_WEIGHT_AND_WIP);
        this.languageWeight = propertySheet.getFloat(PROP_LANGUAGE_WEIGHT);
        this.logWip = this.logMath.linearToLog(propertySheet.getDouble(PROP_WORD_INSERTION_PROBABILITY));
        this.unigramWeight = propertySheet.getFloat("unigramWeight");
    }

    private void buildUnigramIDMap() {
        int n = 0;
        if (this.unigramIDMap == null) {
            this.unigramIDMap = new HashMap<Word, Integer>();
        }
        for (int i = 0; i < this.words.length; ++i) {
            Word word = this.dictionary.getWord(this.words[i]);
            if (word == null) {
                this.logger.warning("The dictionary is missing a phonetic transcription for the word '" + this.words[i] + "'");
                ++n;
            }
            this.unigramIDMap.put(word, i);
            if (!this.logger.isLoggable(Level.FINE)) continue;
            this.logger.fine("Word: " + word);
        }
        if (n > 0) {
            this.logger.warning("Dictionary is missing " + n + " words that are contained in the language model.");
        }
    }

    @Override
    public void allocate() throws IOException {
        BinaryLoader binaryLoader;
        TimerPool.getTimer(this, "Load LM").start();
        this.logger.info("Loading n-gram language model from: " + this.location);
        if (this.ngramLogFile != null) {
            this.logFile = new PrintWriter(new FileOutputStream(this.ngramLogFile));
        }
        if (this.location.getProtocol() == null || this.location.getProtocol().equals("file")) {
            try {
                binaryLoader = new BinaryLoader(new File(this.location.toURI()));
            }
            catch (Exception exception) {
                binaryLoader = new BinaryLoader(new File(this.location.getPath()));
            }
        } else {
            binaryLoader = new BinaryLoader(this.location);
        }
        binaryLoader.verifyHeader();
        this.counts = binaryLoader.readCounts();
        if (this.maxDepth <= 0 || this.maxDepth > this.counts.length) {
            this.maxDepth = this.counts.length;
        }
        if (this.maxDepth > 1) {
            this.quant = binaryLoader.readQuant(this.maxDepth);
        }
        this.unigrams = binaryLoader.readUnigrams(this.counts[0]);
        if (this.maxDepth > 1) {
            this.trie = new NgramTrie(this.counts, this.quant.getProbBoSize(), this.quant.getProbSize());
            binaryLoader.readTrieByteArr(this.trie.getMem());
        }
        this.words = binaryLoader.readWords(this.counts[0]);
        this.buildUnigramIDMap();
        this.ngramProbCache = new LRUCache(this.ngramCacheSize);
        binaryLoader.close();
        TimerPool.getTimer(this, "Load LM").stop();
    }

    @Override
    public void deallocate() throws IOException {
        if (this.logFile != null) {
            this.logFile.flush();
        }
    }

    private float getAvailableProb(WordSequence wordSequence, TrieRange trieRange, float f) {
        int n;
        if (!trieRange.isSearchable()) {
            return f;
        }
        for (int i = wordSequence.size() - 2; i >= 0 && (n = wordSequence.size() - 2 - i) + 1 != this.maxDepth; --i) {
            int n2 = this.unigramIDMap.get(wordSequence.getWord(i));
            float f2 = this.trie.readNgramProb(n2, n, trieRange, this.quant);
            if (!trieRange.getFound()) break;
            f = f2;
            ++this.curDepth;
            if (!trieRange.isSearchable()) break;
        }
        return f;
    }

    private float getAvailableBackoff(WordSequence wordSequence) {
        float f = 0.0f;
        int n = wordSequence.size();
        int n2 = this.unigramIDMap.get(wordSequence.getWord(n - 2));
        TrieRange trieRange = new TrieRange(this.unigrams[n2].next, this.unigrams[n2 + 1].next);
        if (this.curDepth == 1) {
            f += this.unigrams[n2].backoff;
        }
        int n3 = n - 3;
        int n4 = 0;
        while (n3 >= 0) {
            int n5 = this.unigramIDMap.get(wordSequence.getWord(n3));
            float f2 = this.trie.readNgramBackoff(n5, n4, trieRange, this.quant);
            if (!trieRange.getFound()) break;
            f += f2;
            if (!trieRange.isSearchable()) break;
            --n3;
            ++n4;
        }
        return f;
    }

    private float getProbabilityRaw(WordSequence wordSequence) {
        int n = wordSequence.size();
        int n2 = this.unigramIDMap.get(wordSequence.getWord(n - 1));
        TrieRange trieRange = new TrieRange(this.unigrams[n2].next, this.unigrams[n2 + 1].next);
        float f = this.unigrams[n2].prob;
        this.curDepth = 1;
        if (n == 1) {
            return f;
        }
        f = this.getAvailableProb(wordSequence, trieRange, f);
        if (this.curDepth < n) {
            f += this.getAvailableBackoff(wordSequence);
        }
        return f;
    }

    private float applyWeights(float f) {
        if (this.applyLanguageWeightAndWip) {
            return f * this.languageWeight + this.logWip;
        }
        return f;
    }

    @Override
    public float getProbability(WordSequence wordSequence) {
        int n = wordSequence.size();
        if (n > this.maxDepth) {
            throw new Error("Unsupported NGram: " + wordSequence.size());
        }
        if (n == this.maxDepth) {
            Float f = (Float)this.ngramProbCache.get(wordSequence);
            if (f != null) {
                ++this.ngramHits;
                return f.floatValue();
            }
            ++this.ngramMisses;
        }
        float f = this.applyWeights(this.getProbabilityRaw(wordSequence));
        if (n == this.maxDepth) {
            this.ngramProbCache.put(wordSequence, Float.valueOf(f));
        }
        if (this.logFile != null) {
            this.logFile.println(wordSequence.toString().replace("][", " ") + " : " + Float.toString(f));
        }
        return f;
    }

    @Override
    public float getSmear(WordSequence wordSequence) {
        return 0.0f;
    }

    @Override
    public Set<String> getVocabulary() {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.words));
        return Collections.unmodifiableSet(hashSet);
    }

    public int getNGramMisses() {
        return this.ngramMisses;
    }

    public int getNGramHits() {
        return this.ngramHits;
    }

    @Override
    public int getMaxDepth() {
        return this.maxDepth;
    }

    private void clearCache() {
        this.logger.info("LM Cache Size: " + this.ngramProbCache.size() + " Hits: " + this.ngramHits + " Misses: " + this.ngramMisses);
        if (this.clearCacheAfterUtterance) {
            this.ngramProbCache = new LRUCache(this.ngramCacheSize);
        }
    }

    @Override
    public void onUtteranceEnd() {
        this.clearCache();
        if (this.logFile != null) {
            this.logFile.println("<END_UTT>");
            this.logFile.flush();
        }
    }

    public static class TrieRange {
        int begin;
        int end;
        boolean found;

        TrieRange(int n, int n2) {
            this.begin = n;
            this.end = n2;
            this.found = true;
        }

        int getWidth() {
            return this.end - this.begin;
        }

        void setFound(boolean bl) {
            this.found = bl;
        }

        boolean getFound() {
            return this.found;
        }

        boolean isSearchable() {
            return this.getWidth() > 0;
        }
    }

    public static class TrieUnigram {
        public float prob;
        public float backoff;
        public int next;
    }
}

