/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.language.ngram.trie;

import edu.cmu.sphinx.linguist.language.ngram.trie.NgramTrieBitarr;

public class NgramTrieQuant {
    private int probBits;
    private int backoffBits;
    private int probMask;
    private int backoffMask;
    private float[][] tables;
    private QuantType quantType;

    public NgramTrieQuant(int n, QuantType quantType) {
        switch (quantType) {
            case NO_QUANT: {
                return;
            }
            case QUANT_16: {
                this.probBits = 16;
                this.backoffBits = 16;
                this.probMask = (1 << this.probBits) - 1;
                this.backoffMask = (1 << this.backoffBits) - 1;
                break;
            }
            default: {
                throw new Error("Unsupported quantization type: " + (Object)((Object)quantType));
            }
        }
        this.tables = new float[(n - 1) * 2 - 1][];
        this.quantType = quantType;
    }

    public void setTable(float[] fArray, int n, boolean bl) {
        int n2 = (n - 2) * 2;
        if (!bl) {
            ++n2;
        }
        this.tables[n2] = fArray;
    }

    public int getProbTableLen() {
        return 1 << this.probBits;
    }

    public int getBackoffTableLen() {
        return 1 << this.backoffBits;
    }

    public int getProbBoSize() {
        switch (this.quantType) {
            case NO_QUANT: {
                return 63;
            }
            case QUANT_16: {
                return 32;
            }
        }
        throw new Error("Unsupported quantization type: " + (Object)((Object)this.quantType));
    }

    public int getProbSize() {
        switch (this.quantType) {
            case NO_QUANT: {
                return 31;
            }
            case QUANT_16: {
                return 16;
            }
        }
        throw new Error("Unsupported quantization type: " + (Object)((Object)this.quantType));
    }

    private float binsDecode(int n, int n2) {
        return this.tables[n][n2];
    }

    public float readProb(NgramTrieBitarr ngramTrieBitarr, int n, int n2, int n3) {
        switch (this.quantType) {
            case NO_QUANT: {
                return ngramTrieBitarr.readNegativeFloat(n, n2);
            }
            case QUANT_16: {
                int n4 = n3 * 2;
                if (n4 < this.tables.length - 1) {
                    n2 += this.backoffBits;
                }
                return this.binsDecode(n4, ngramTrieBitarr.readInt(n, n2, this.backoffMask));
            }
        }
        throw new Error("Unsupported quantization type: " + (Object)((Object)this.quantType));
    }

    public float readBackoff(NgramTrieBitarr ngramTrieBitarr, int n, int n2, int n3) {
        switch (this.quantType) {
            case NO_QUANT: {
                return ngramTrieBitarr.readFloat(n, n2 += 31);
            }
            case QUANT_16: {
                int n4 = n3 * 2 + 1;
                return this.binsDecode(n4, ngramTrieBitarr.readInt(n, n2, this.probMask));
            }
        }
        throw new Error("Unsupported quantization type: " + (Object)((Object)this.quantType));
    }

    public static enum QuantType {
        NO_QUANT,
        QUANT_16;

    }
}

