/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.lextree;

import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.lextree.UnitNode;
import java.util.HashSet;
import java.util.Set;

class HMMNode
extends UnitNode {
    private final HMM hmm;
    private Object rcSet;

    HMMNode(HMM hMM, float f) {
        super(f);
        this.hmm = hMM;
        Unit unit = this.getBaseUnit();
        int n = 1;
        if (unit.isSilence()) {
            n = 3;
        } else if (unit.isFiller()) {
            n = 4;
        } else if (hMM.getPosition().isWordBeginning()) {
            n = 2;
        }
        this.setType(n);
    }

    @Override
    Unit getBaseUnit() {
        return this.hmm.getBaseUnit();
    }

    HMM getHMM() {
        return this.hmm;
    }

    @Override
    HMMPosition getPosition() {
        return this.hmm.getPosition();
    }

    @Override
    HMM getKey() {
        return this.getHMM();
    }

    @Override
    public String toString() {
        return "HMMNode " + this.hmm + " p " + this.getUnigramProbability();
    }

    void addRC(Unit unit) {
        this.getRCSet().add(unit);
    }

    @Override
    void freeze() {
        super.freeze();
        if (this.rcSet instanceof Set) {
            Set set = (Set)this.rcSet;
            this.rcSet = set.toArray(new Unit[set.size()]);
        }
    }

    private Set<Unit> getRCSet() {
        if (this.rcSet == null) {
            this.rcSet = new HashSet();
        }
        assert (this.rcSet instanceof HashSet);
        return (Set)this.rcSet;
    }

    Unit[] getRC() {
        if (this.rcSet instanceof HashSet) {
            this.freeze();
        }
        return (Unit[])this.rcSet;
    }
}

