/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.lextree;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPool;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.linguist.lextree.EndNode;
import edu.cmu.sphinx.linguist.lextree.HMMNode;
import edu.cmu.sphinx.linguist.lextree.InitialWordNode;
import edu.cmu.sphinx.linguist.lextree.Node;
import edu.cmu.sphinx.linguist.lextree.UnitNode;
import edu.cmu.sphinx.linguist.lextree.WordNode;
import edu.cmu.sphinx.util.Utilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

class HMMTree {
    private final HMMPool hmmPool;
    private InitialWordNode initialNode;
    private Dictionary dictionary;
    private LanguageModel lm;
    private final boolean addFillerWords;
    private final boolean addSilenceWord = true;
    private final Set<Unit> entryPoints = new HashSet<Unit>();
    private Set<Unit> exitPoints = new HashSet<Unit>();
    private Set<Word> allWords;
    private EntryPointTable entryPointTable;
    private boolean debug;
    private final float languageWeight;
    private final Map<Object, HMMNode[]> endNodeMap;
    private final Map<Pronunciation, WordNode> wordNodeMap;
    private WordNode sentenceEndWordNode;
    private Logger logger;

    HMMTree(HMMPool hMMPool, Dictionary dictionary, LanguageModel languageModel, boolean bl, float f) {
        this.hmmPool = hMMPool;
        this.dictionary = dictionary;
        this.lm = languageModel;
        this.endNodeMap = new HashMap<Object, HMMNode[]>();
        this.wordNodeMap = new HashMap<Pronunciation, WordNode>();
        this.addFillerWords = bl;
        this.languageWeight = f;
        this.logger = Logger.getLogger(HMMTree.class.getSimpleName());
        this.compile();
    }

    public Node[] getEntryPoint(Unit unit, Unit unit2) {
        EntryPoint entryPoint = this.entryPointTable.getEntryPoint(unit2);
        return entryPoint.getEntryPointsFromLeftContext(unit).getSuccessors();
    }

    public HMMNode[] getHMMNodes(EndNode endNode) {
        HMMNode[] hMMNodeArray = this.endNodeMap.get(endNode.getKey());
        if (hMMNodeArray == null) {
            HashMap<HMM, HMMNode> hashMap = new HashMap<HMM, HMMNode>();
            Unit unit = endNode.getBaseUnit();
            Unit unit2 = endNode.getLeftContext();
            for (Unit unit3 : this.entryPoints) {
                HMM hMM = this.hmmPool.getHMM(unit, unit2, unit3, HMMPosition.END);
                HMMNode hMMNode = (HMMNode)hashMap.get(hMM);
                if (hMMNode == null) {
                    hMMNode = new HMMNode(hMM, 0.0f);
                    hashMap.put(hMM, hMMNode);
                }
                hMMNode.addRC(unit3);
                for (Node node : endNode.getSuccessors()) {
                    WordNode wordNode = (WordNode)node;
                    hMMNode.addSuccessor(wordNode);
                }
            }
            hMMNodeArray = hashMap.values().toArray(new HMMNode[hashMap.size()]);
            this.endNodeMap.put(endNode.getKey(), hMMNodeArray);
        }
        return hMMNodeArray;
    }

    public WordNode getSentenceEndWordNode() {
        assert (this.sentenceEndWordNode != null);
        return this.sentenceEndWordNode;
    }

    private void compile() {
        this.collectEntryAndExitUnits();
        this.entryPointTable = new EntryPointTable(this.entryPoints);
        this.addWords();
        this.entryPointTable.createEntryPointMaps();
        this.freeze();
    }

    void dumpTree() {
        System.out.println("Dumping Tree ...");
        HashMap<Node, Node> hashMap = new HashMap<Node, Node>();
        this.dumpTree(0, this.getInitialNode(), hashMap);
        System.out.println("... done Dumping Tree");
    }

    private void dumpTree(int n, Node node, Map<Node, Node> map) {
        if (map.get(node) == null) {
            map.put(node, node);
            System.out.println(Utilities.pad(n) + node);
            if (!(node instanceof WordNode)) {
                for (Node node2 : node.getSuccessors()) {
                    this.dumpTree(n + 1, node2, map);
                }
            }
        }
    }

    private void collectEntryAndExitUnits() {
        Set<Word> set = this.getAllWords();
        for (Word word : set) {
            for (int i = 0; i < word.getPronunciations().length; ++i) {
                Pronunciation pronunciation = word.getPronunciations()[i];
                Unit unit = pronunciation.getUnits()[0];
                Unit unit2 = pronunciation.getUnits()[pronunciation.getUnits().length - 1];
                this.entryPoints.add(unit);
                this.exitPoints.add(unit2);
            }
        }
        if (this.debug) {
            System.out.println("Entry Points: " + this.entryPoints.size());
            System.out.println("Exit Points: " + this.exitPoints.size());
        }
    }

    private void freeze() {
        this.entryPointTable.freeze();
        this.dictionary = null;
        this.lm = null;
        this.exitPoints = null;
        this.allWords = null;
        this.wordNodeMap.clear();
        this.endNodeMap.clear();
    }

    private void addWords() {
        Set<Word> set = this.getAllWords();
        for (Word word : set) {
            this.addWord(word);
        }
    }

    private void addWord(Word word) {
        Pronunciation[] pronunciationArray;
        float f = this.getWordUnigramProbability(word);
        for (Pronunciation pronunciation : pronunciationArray = word.getPronunciations()) {
            this.addPronunciation(pronunciation, f);
        }
    }

    private void addPronunciation(Pronunciation pronunciation, float f) {
        Unit[] unitArray = pronunciation.getUnits();
        Unit unit = unitArray[0];
        EntryPoint entryPoint = this.entryPointTable.getEntryPoint(unit);
        entryPoint.addProbability(f);
        if (unitArray.length > 1) {
            Node node = entryPoint.getNode();
            Unit unit2 = unit;
            for (int i = 1; i < unitArray.length - 1; ++i) {
                unit = unitArray[i];
                Unit unit3 = unitArray[i + 1];
                HMM hMM = this.hmmPool.getHMM(unit, unit2, unit3, HMMPosition.INTERNAL);
                if (hMM == null) {
                    this.logger.severe("Missing HMM for unit " + unit.getName() + " with lc=" + unit2.getName() + " rc=" + unit3.getName());
                } else {
                    node = node.addSuccessor(hMM, f);
                }
                unit2 = unit;
            }
            unit = unitArray[unitArray.length - 1];
            EndNode endNode = new EndNode(unit, unit2, f);
            WordNode wordNode = (node = node.addSuccessor(endNode, f)).addSuccessor(pronunciation, f, this.wordNodeMap);
            if (wordNode.getWord().isSentenceEndWord()) {
                this.sentenceEndWordNode = wordNode;
            }
        } else {
            entryPoint.addSingleUnitWord(pronunciation);
        }
    }

    private float getWordUnigramProbability(Word word) {
        float f = 0.0f;
        if (!word.isFiller()) {
            Word[] wordArray = new Word[]{word};
            f = this.lm.getProbability(new WordSequence(wordArray));
            f *= this.languageWeight;
        }
        return f;
    }

    private Set<Word> getAllWords() {
        if (this.allWords == null) {
            this.allWords = new HashSet<Word>();
            for (String string : this.lm.getVocabulary()) {
                Word word = this.dictionary.getWord(string);
                if (word == null) continue;
                this.allWords.add(word);
            }
            if (this.addFillerWords) {
                this.allWords.addAll(Arrays.asList(this.dictionary.getFillerWords()));
            } else {
                this.allWords.add(this.dictionary.getSilenceWord());
            }
        }
        return this.allWords;
    }

    InitialWordNode getInitialNode() {
        return this.initialNode;
    }

    class EntryPoint {
        final Unit baseUnit;
        final Node baseNode;
        final Map<Unit, Node> unitToEntryPointMap;
        List<Pronunciation> singleUnitWords;
        int nodeCount;
        Set<Unit> rcSet;
        float totalProbability;

        EntryPoint(Unit unit) {
            this.baseUnit = unit;
            this.baseNode = new Node(-3.4028235E38f);
            this.unitToEntryPointMap = new HashMap<Unit, Node>();
            this.singleUnitWords = new ArrayList<Pronunciation>();
            this.totalProbability = -3.4028235E38f;
        }

        Node getEntryPointsFromLeftContext(Unit unit) {
            return this.unitToEntryPointMap.get(unit);
        }

        void addProbability(float f) {
            if (f > this.totalProbability) {
                this.totalProbability = f;
            }
        }

        float getProbability() {
            return this.totalProbability;
        }

        void freeze() {
            for (Node node : this.unitToEntryPointMap.values()) {
                node.freeze();
            }
            this.singleUnitWords = null;
            this.rcSet = null;
        }

        Node getNode() {
            return this.baseNode;
        }

        void addSingleUnitWord(Pronunciation pronunciation) {
            this.singleUnitWords.add(pronunciation);
        }

        private Collection<Unit> getEntryPointRC() {
            if (this.rcSet == null) {
                this.rcSet = new HashSet<Unit>();
                for (Node node : this.baseNode.getSuccessorMap().values()) {
                    UnitNode unitNode = (UnitNode)node;
                    this.rcSet.add(unitNode.getBaseUnit());
                }
            }
            return this.rcSet;
        }

        void createEntryPointMap() {
            HashMap<HMM, Node> hashMap = new HashMap<HMM, Node>();
            HashMap<HMM, HMMNode> hashMap2 = new HashMap<HMM, HMMNode>();
            for (Unit unit : HMMTree.this.exitPoints) {
                Node node = new Node(-3.4028235E38f);
                for (Unit unit2 : this.getEntryPointRC()) {
                    HMM hMM = HMMTree.this.hmmPool.getHMM(this.baseUnit, unit, unit2, HMMPosition.BEGIN);
                    Node node2 = (Node)hashMap.get(hMM);
                    if (node2 == null) {
                        node2 = node.addSuccessor(hMM, this.getProbability());
                        hashMap.put(hMM, node2);
                    } else {
                        node.putSuccessor(hMM, node2);
                    }
                    ++this.nodeCount;
                    this.connectEntryPointNode(node2, unit2);
                }
                this.connectSingleUnitWords(unit, node, hashMap2);
                this.unitToEntryPointMap.put(unit, node);
            }
        }

        private void connectSingleUnitWords(Unit unit, Node node, HashMap<HMM, HMMNode> hashMap) {
            if (!this.singleUnitWords.isEmpty()) {
                for (Unit unit2 : HMMTree.this.entryPoints) {
                    HMM hMM = HMMTree.this.hmmPool.getHMM(this.baseUnit, unit, unit2, HMMPosition.SINGLE);
                    HMMNode hMMNode = hashMap.get(hMM);
                    if (hMMNode == null) {
                        hMMNode = (HMMNode)node.addSuccessor(hMM, this.getProbability());
                        hashMap.put(hMM, hMMNode);
                    } else {
                        node.putSuccessor(hMM, hMMNode);
                    }
                    hMMNode.addRC(unit2);
                    ++this.nodeCount;
                    for (Pronunciation pronunciation : this.singleUnitWords) {
                        if (pronunciation.getWord() == HMMTree.this.dictionary.getSentenceStartWord()) {
                            HMMTree.this.initialNode = new InitialWordNode(pronunciation, hMMNode);
                        } else {
                            float f = HMMTree.this.getWordUnigramProbability(pronunciation.getWord());
                            WordNode wordNode = hMMNode.addSuccessor(pronunciation, f, HMMTree.this.wordNodeMap);
                            if (pronunciation.getWord() == HMMTree.this.dictionary.getSentenceEndWord()) {
                                HMMTree.this.sentenceEndWordNode = wordNode;
                            }
                        }
                        ++this.nodeCount;
                    }
                }
            }
        }

        private void connectEntryPointNode(Node node, Unit unit) {
            for (Node node2 : this.baseNode.getSuccessors()) {
                UnitNode unitNode = (UnitNode)node2;
                if (unitNode.getBaseUnit() != unit) continue;
                node.addSuccessor(unitNode);
            }
        }

        void dump() {
            System.out.println("EntryPoint " + this.baseUnit + " RC Followers: " + this.getEntryPointRC().size());
            int n = 0;
            Collection<Unit> collection = this.getEntryPointRC();
            System.out.print("    ");
            for (Unit unit : collection) {
                System.out.print(Utilities.pad(unit.getName(), 4));
                if (n++ < 12) continue;
                n = 0;
                System.out.println();
                System.out.print("    ");
            }
            System.out.println();
        }
    }

    class EntryPointTable {
        private final Map<Unit, EntryPoint> entryPoints = new HashMap<Unit, EntryPoint>();

        EntryPointTable(Collection<Unit> collection) {
            for (Unit unit : collection) {
                this.entryPoints.put(unit, new EntryPoint(unit));
            }
        }

        EntryPoint getEntryPoint(Unit unit) {
            return this.entryPoints.get(unit);
        }

        void createEntryPointMaps() {
            for (EntryPoint entryPoint : this.entryPoints.values()) {
                entryPoint.createEntryPointMap();
            }
        }

        void freeze() {
            for (EntryPoint entryPoint : this.entryPoints.values()) {
                entryPoint.freeze();
            }
        }

        void dump() {
            for (EntryPoint entryPoint : this.entryPoints.values()) {
                entryPoint.dump();
            }
        }
    }
}

