/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.lextree;

import edu.cmu.sphinx.decoder.scorer.ScoreProvider;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchGraph;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPool;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.HMMStateArc;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.grammar.Grammar;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.linguist.lextree.EndNode;
import edu.cmu.sphinx.linguist.lextree.HMMNode;
import edu.cmu.sphinx.linguist.lextree.HMMTree;
import edu.cmu.sphinx.linguist.lextree.InitialWordNode;
import edu.cmu.sphinx.linguist.lextree.Node;
import edu.cmu.sphinx.linguist.lextree.UnitNode;
import edu.cmu.sphinx.linguist.lextree.WordNode;
import edu.cmu.sphinx.linguist.util.LRUCache;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class LexTreeLinguist
implements Linguist {
    @S4Component(type=Grammar.class)
    public static final String PROP_GRAMMAR = "grammar";
    @S4Component(type=AcousticModel.class)
    public static final String PROP_ACOUSTIC_MODEL = "acousticModel";
    @S4Component(type=UnitManager.class, defaultClass=UnitManager.class)
    public static final String PROP_UNIT_MANAGER = "unitManager";
    @S4Boolean(defaultValue=true)
    public static final String PROP_FULL_WORD_HISTORIES = "fullWordHistories";
    @S4Component(type=LanguageModel.class)
    public static final String PROP_LANGUAGE_MODEL = "languageModel";
    @S4Component(type=Dictionary.class)
    public static final String PROP_DICTIONARY = "dictionary";
    @S4Integer(defaultValue=0)
    public static final String PROP_CACHE_SIZE = "cacheSize";
    @S4Boolean(defaultValue=false)
    public static final String PROP_ADD_FILLER_WORDS = "addFillerWords";
    @S4Boolean(defaultValue=false)
    public static final String PROP_GENERATE_UNIT_STATES = "generateUnitStates";
    @S4Boolean(defaultValue=true)
    public static final String PROP_WANT_UNIGRAM_SMEAR = "wantUnigramSmear";
    @S4Double(defaultValue=1.0)
    public static final String PROP_UNIGRAM_SMEAR_WEIGHT = "unigramSmearWeight";
    private static final SearchStateArc[] EMPTY_ARC = new SearchStateArc[0];
    private LanguageModel languageModel;
    private AcousticModel acousticModel;
    private LogMath logMath;
    private Dictionary dictionary;
    private UnitManager unitManager;
    private Logger logger;
    protected boolean addFillerWords;
    private boolean generateUnitStates;
    private boolean wantUnigramSmear = true;
    private float unigramSmearWeight = 1.0f;
    private boolean cacheEnabled;
    private int maxArcCacheSize;
    protected float languageWeight;
    private float logWordInsertionProbability;
    private float logUnitInsertionProbability;
    private float logFillerInsertionProbability;
    private float logSilenceInsertionProbability;
    private float logOne;
    private Word sentenceEndWord;
    private Word[] sentenceStartWordArray;
    private SearchGraph searchGraph;
    private HMMPool hmmPool;
    private LRUCache<LexTreeState, SearchStateArc[]> arcCache;
    private int maxDepth;
    protected HMMTree hmmTree;
    private int cacheTrys;
    private int cacheHits;

    public LexTreeLinguist(AcousticModel acousticModel, UnitManager unitManager, LanguageModel languageModel, Dictionary dictionary, boolean bl, boolean bl2, double d, double d2, double d3, double d4, float f, boolean bl3, boolean bl4, float f2, int n) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.acousticModel = acousticModel;
        this.logMath = LogMath.getLogMath();
        this.unitManager = unitManager;
        this.languageModel = languageModel;
        this.dictionary = dictionary;
        this.wantUnigramSmear = bl2;
        this.logWordInsertionProbability = this.logMath.linearToLog(d);
        this.logSilenceInsertionProbability = this.logMath.linearToLog(d2);
        this.logFillerInsertionProbability = this.logMath.linearToLog(d3);
        this.logUnitInsertionProbability = this.logMath.linearToLog(d4);
        this.languageWeight = f;
        this.addFillerWords = bl3;
        this.generateUnitStates = bl4;
        this.unigramSmearWeight = f2;
        this.maxArcCacheSize = n;
        boolean bl5 = this.cacheEnabled = n > 0;
        if (this.cacheEnabled) {
            this.arcCache = new LRUCache(n);
        }
    }

    public LexTreeLinguist() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logger = propertySheet.getLogger();
        this.logMath = LogMath.getLogMath();
        this.acousticModel = (AcousticModel)propertySheet.getComponent(PROP_ACOUSTIC_MODEL);
        this.unitManager = (UnitManager)propertySheet.getComponent(PROP_UNIT_MANAGER);
        this.languageModel = (LanguageModel)propertySheet.getComponent(PROP_LANGUAGE_MODEL);
        this.dictionary = (Dictionary)propertySheet.getComponent(PROP_DICTIONARY);
        this.wantUnigramSmear = propertySheet.getBoolean(PROP_WANT_UNIGRAM_SMEAR);
        this.logWordInsertionProbability = this.logMath.linearToLog(propertySheet.getDouble("wordInsertionProbability"));
        this.logSilenceInsertionProbability = this.logMath.linearToLog(propertySheet.getDouble("silenceInsertionProbability"));
        this.logFillerInsertionProbability = this.logMath.linearToLog(propertySheet.getDouble("fillerInsertionProbability"));
        this.logUnitInsertionProbability = this.logMath.linearToLog(propertySheet.getDouble("unitInsertionProbability"));
        this.languageWeight = propertySheet.getFloat("languageWeight");
        this.addFillerWords = propertySheet.getBoolean(PROP_ADD_FILLER_WORDS);
        this.generateUnitStates = propertySheet.getBoolean(PROP_GENERATE_UNIT_STATES);
        this.unigramSmearWeight = propertySheet.getFloat(PROP_UNIGRAM_SMEAR_WEIGHT);
        this.maxArcCacheSize = propertySheet.getInt(PROP_CACHE_SIZE);
        boolean bl = this.cacheEnabled = this.maxArcCacheSize > 0;
        if (this.cacheEnabled) {
            this.arcCache = new LRUCache(this.maxArcCacheSize);
        }
    }

    @Override
    public void allocate() throws IOException {
        this.dictionary.allocate();
        this.acousticModel.allocate();
        this.languageModel.allocate();
        this.compileGrammar();
    }

    @Override
    public void deallocate() throws IOException {
        if (this.acousticModel != null) {
            this.acousticModel.deallocate();
        }
        if (this.dictionary != null) {
            this.dictionary.deallocate();
        }
        if (this.languageModel != null) {
            this.languageModel.deallocate();
        }
        this.hmmTree = null;
    }

    @Override
    public SearchGraph getSearchGraph() {
        return this.searchGraph;
    }

    @Override
    public void startRecognition() {
    }

    @Override
    public void stopRecognition() {
        this.languageModel.onUtteranceEnd();
    }

    public LanguageModel getLanguageModel() {
        return this.languageModel;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    private SearchState getInitialSearchState() {
        InitialWordNode initialWordNode = this.hmmTree.getInitialNode();
        if (initialWordNode == null) {
            throw new RuntimeException("Language model has no entry for initial word <s>");
        }
        return new LexTreeWordState(initialWordNode, initialWordNode.getParent(), new WordSequence(this.sentenceStartWordArray).trim(this.maxDepth - 1), 0.0f, this.logOne, this.logOne);
    }

    private void compileGrammar() {
        TimerPool.getTimer(this, "Compile").start();
        this.sentenceEndWord = this.dictionary.getSentenceEndWord();
        this.sentenceStartWordArray = new Word[1];
        this.sentenceStartWordArray[0] = this.dictionary.getSentenceStartWord();
        this.maxDepth = this.languageModel.getMaxDepth();
        this.generateHmmTree();
        TimerPool.getTimer(this, "Compile").stop();
        this.searchGraph = new LexTreeSearchGraph(this.getInitialSearchState());
    }

    protected void generateHmmTree() {
        this.hmmPool = new HMMPool(this.acousticModel, this.logger, this.unitManager);
        this.hmmTree = new HMMTree(this.hmmPool, this.dictionary, this.languageModel, this.addFillerWords, this.languageWeight);
        this.hmmPool.dumpInfo();
    }

    private float calculateInsertionProbability(UnitNode unitNode) {
        int n = unitNode.getType();
        if (n == 1) {
            return this.logUnitInsertionProbability;
        }
        if (n == 2) {
            return this.logUnitInsertionProbability + this.logWordInsertionProbability;
        }
        if (n == 3) {
            return this.logSilenceInsertionProbability;
        }
        return this.logFillerInsertionProbability;
    }

    private float getUnigramSmear(Node node) {
        float f = this.wantUnigramSmear ? node.getUnigramProbability() * this.unigramSmearWeight : this.logOne;
        return f;
    }

    private float getSmearTermFromLanguageModel(WordSequence wordSequence) {
        return this.languageModel.getSmear(wordSequence);
    }

    private HMMNode[] getHMMNodes(EndNode endNode) {
        return this.hmmTree.getHMMNodes(endNode);
    }

    public class LexTreeEndWordState
    extends LexTreeWordState
    implements WordSearchState {
        LexTreeEndWordState(WordNode wordNode, HMMNode hMMNode, WordSequence wordSequence, float f, float f2, float f3) {
            super(wordNode, hMMNode, wordSequence, f, f2, f3);
        }

        @Override
        public int getOrder() {
            return 2;
        }
    }

    public class LexTreeWordState
    extends LexTreeState
    implements WordSearchState {
        private HMMNode lastNode;
        private float logLanguageProbability;

        LexTreeWordState(WordNode wordNode, HMMNode hMMNode, WordSequence wordSequence, float f, float f2, float f3) {
            super(wordNode, wordSequence, f, f2);
            this.lastNode = hMMNode;
            this.logLanguageProbability = f3;
        }

        @Override
        public Pronunciation getPronunciation() {
            return ((WordNode)this.getNode()).getPronunciation();
        }

        @Override
        public boolean isFinal() {
            return ((WordNode)this.getNode()).isFinal();
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 41 + this.lastNode.hashCode();
        }

        @Override
        public String getSignature() {
            return super.getSignature() + "-ln-" + this.lastNode.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LexTreeWordState) {
                LexTreeWordState lexTreeWordState = (LexTreeWordState)object;
                return this.lastNode == lexTreeWordState.lastNode && super.equals(object);
            }
            return false;
        }

        @Override
        public float getLanguageProbability() {
            return this.logLanguageProbability;
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] searchStateArcArray = this.getCachedArcs();
            if (searchStateArcArray == null) {
                searchStateArcArray = EMPTY_ARC;
                WordNode wordNode = (WordNode)this.getNode();
                if (wordNode.getWord() != LexTreeLinguist.this.sentenceEndWord) {
                    int n = 0;
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    Unit[] unitArray = this.lastNode.getRC();
                    Unit unit = wordNode.getLastUnit();
                    for (Unit unit2 : unitArray) {
                        Node[] nodeArray;
                        for (Node node : nodeArray = LexTreeLinguist.this.hmmTree.getEntryPoint(unit, unit2)) {
                            arrayList.add(node);
                        }
                    }
                    searchStateArcArray = new SearchStateArc[arrayList.size() + 1];
                    for (Node node : arrayList) {
                        searchStateArcArray[n++] = this.createUnitStateArc((HMMNode)node, this);
                    }
                    searchStateArcArray[n++] = this.createWordStateArc(LexTreeLinguist.this.hmmTree.getSentenceEndWordNode(), this.lastNode, this);
                }
                this.putCachedArcs(searchStateArcArray);
            }
            return searchStateArcArray;
        }

        @Override
        public int getOrder() {
            return 1;
        }

        @Override
        public boolean isWordStart() {
            return false;
        }
    }

    public class LexTreeNonEmittingHMMState
    extends LexTreeHMMState {
        LexTreeNonEmittingHMMState(HMMNode hMMNode, WordSequence wordSequence, float f, float f2, HMMState hMMState, float f3, Node node) {
            super(hMMNode, wordSequence, f, f2, hMMState, LexTreeLinguist.this.logOne, f3, node);
        }

        @Override
        public int getOrder() {
            return 0;
        }
    }

    public class LexTreeHMMState
    extends LexTreeState
    implements HMMSearchState,
    ScoreProvider {
        private final HMMState hmmState;
        private float logLanguageProbability;
        private float logInsertionProbability;
        private final Node parentNode;
        int hashCode;

        LexTreeHMMState(HMMNode hMMNode, WordSequence wordSequence, float f, float f2, HMMState hMMState, float f3, float f4, Node node) {
            super(hMMNode, wordSequence, f, f2);
            this.hashCode = -1;
            this.hmmState = hMMState;
            this.parentNode = node;
            this.logLanguageProbability = f3;
            this.logInsertionProbability = f4;
        }

        @Override
        public String getSignature() {
            return super.getSignature() + "-HMM-" + this.hmmState.getState();
        }

        @Override
        public HMMState getHMMState() {
            return this.hmmState;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = super.hashCode() * 29 + (this.hmmState.getState() + 1);
                if (this.parentNode != null) {
                    this.hashCode *= 377;
                    this.hashCode += this.parentNode.hashCode();
                }
            }
            return this.hashCode;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LexTreeHMMState) {
                LexTreeHMMState lexTreeHMMState = (LexTreeHMMState)object;
                return this.hmmState == lexTreeHMMState.hmmState && this.parentNode == lexTreeHMMState.parentNode && super.equals(object);
            }
            return false;
        }

        @Override
        public float getLanguageProbability() {
            return this.logLanguageProbability;
        }

        @Override
        public float getInsertionProbability() {
            return this.logInsertionProbability;
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] searchStateArcArray = this.getCachedArcs();
            if (searchStateArcArray == null) {
                if (this.hmmState.isExitState()) {
                    searchStateArcArray = this.parentNode == null ? super.getSuccessors() : super.getSuccessors(this.parentNode);
                } else {
                    HMMStateArc[] hMMStateArcArray = this.hmmState.getSuccessors();
                    searchStateArcArray = new SearchStateArc[hMMStateArcArray.length];
                    for (int i = 0; i < hMMStateArcArray.length; ++i) {
                        HMMStateArc hMMStateArc = hMMStateArcArray[i];
                        if (hMMStateArc.getHMMState().isEmitting()) {
                            if (hMMStateArc.getHMMState() == this.hmmState && this.logInsertionProbability == hMMStateArc.getLogProbability()) {
                                searchStateArcArray[i] = this;
                                continue;
                            }
                            searchStateArcArray[i] = new LexTreeHMMState((HMMNode)this.getNode(), this.getWordHistory(), this.getSmearTerm(), this.getSmearProb(), hMMStateArc.getHMMState(), LexTreeLinguist.this.logOne, hMMStateArc.getLogProbability(), this.parentNode);
                            continue;
                        }
                        searchStateArcArray[i] = new LexTreeNonEmittingHMMState((HMMNode)this.getNode(), this.getWordHistory(), this.getSmearTerm(), this.getSmearProb(), hMMStateArc.getHMMState(), hMMStateArc.getLogProbability(), this.parentNode);
                    }
                }
                this.putCachedArcs(searchStateArcArray);
            }
            return searchStateArcArray;
        }

        @Override
        public boolean isEmitting() {
            return this.hmmState.isEmitting();
        }

        @Override
        public String toString() {
            return super.toString() + " hmm:" + this.hmmState;
        }

        @Override
        public int getOrder() {
            return 5;
        }

        @Override
        public float getScore(Data data) {
            return this.hmmState.getScore(data);
        }

        @Override
        public float[] getComponentScore(Data data) {
            return this.hmmState.calculateComponentScore(data);
        }
    }

    public class LexTreeUnitState
    extends LexTreeState
    implements UnitSearchState {
        private float logInsertionProbability;
        private float logLanguageProbability;
        private Node parentNode;
        private int hashCode;

        LexTreeUnitState(HMMNode hMMNode, WordSequence wordSequence, float f, float f2, float f3, float f4) {
            this(hMMNode, wordSequence, f, f2, f3, f4, null);
        }

        LexTreeUnitState(HMMNode hMMNode, WordSequence wordSequence, float f, float f2, float f3, float f4, Node node) {
            super(hMMNode, wordSequence, f, f2);
            this.hashCode = -1;
            this.logInsertionProbability = f4;
            this.logLanguageProbability = f3;
            this.parentNode = node;
        }

        @Override
        public Unit getUnit() {
            return this.getHMMNode().getBaseUnit();
        }

        @Override
        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = super.hashCode() * 17 + 421;
                if (this.parentNode != null) {
                    this.hashCode *= 432;
                    this.hashCode += this.parentNode.hashCode();
                }
            }
            return this.hashCode;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LexTreeUnitState) {
                LexTreeUnitState lexTreeUnitState = (LexTreeUnitState)object;
                return this.parentNode == lexTreeUnitState.parentNode && super.equals(object);
            }
            return false;
        }

        private HMMNode getHMMNode() {
            return (HMMNode)this.getNode();
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] searchStateArcArray = new SearchStateArc[1];
            HMM hMM = this.getHMMNode().getHMM();
            searchStateArcArray[0] = new LexTreeHMMState(this.getHMMNode(), this.getWordHistory(), this.getSmearTerm(), this.getSmearProb(), hMM.getInitialState(), LexTreeLinguist.this.logOne, LexTreeLinguist.this.logOne, this.parentNode);
            return searchStateArcArray;
        }

        @Override
        public String toString() {
            return super.toString() + " unit";
        }

        @Override
        public float getInsertionProbability() {
            return this.logInsertionProbability;
        }

        @Override
        public float getLanguageProbability() {
            return this.logLanguageProbability;
        }

        @Override
        public int getOrder() {
            return 4;
        }
    }

    public class LexTreeEndUnitState
    extends LexTreeState
    implements UnitSearchState {
        float logLanguageProbability;
        float logInsertionProbability;

        LexTreeEndUnitState(EndNode endNode, WordSequence wordSequence, float f, float f2, float f3, float f4) {
            super(endNode, wordSequence, f, f2);
            this.logLanguageProbability = f3;
            this.logInsertionProbability = f4;
        }

        @Override
        public Unit getUnit() {
            return this.getEndNode().getBaseUnit();
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 17 + 423;
        }

        @Override
        public float getInsertionProbability() {
            return this.logInsertionProbability;
        }

        @Override
        public float getLanguageProbability() {
            return this.logLanguageProbability;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof LexTreeEndUnitState && super.equals(object);
        }

        private EndNode getEndNode() {
            return (EndNode)this.getNode();
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] searchStateArcArray = this.getCachedArcs();
            if (searchStateArcArray == null) {
                HMMNode[] hMMNodeArray = LexTreeLinguist.this.getHMMNodes(this.getEndNode());
                searchStateArcArray = new SearchStateArc[hMMNodeArray.length];
                if (LexTreeLinguist.this.generateUnitStates) {
                    for (int i = 0; i < hMMNodeArray.length; ++i) {
                        searchStateArcArray[i] = new LexTreeUnitState(hMMNodeArray[i], this.getWordHistory(), this.getSmearTerm(), this.getSmearProb(), LexTreeLinguist.this.logOne, LexTreeLinguist.this.logOne, this.getNode());
                    }
                } else {
                    for (int i = 0; i < hMMNodeArray.length; ++i) {
                        HMM hMM = hMMNodeArray[i].getHMM();
                        searchStateArcArray[i] = new LexTreeHMMState(hMMNodeArray[i], this.getWordHistory(), this.getSmearTerm(), this.getSmearProb(), hMM.getInitialState(), LexTreeLinguist.this.logOne, LexTreeLinguist.this.logOne, this.getNode());
                    }
                }
                this.putCachedArcs(searchStateArcArray);
            }
            return searchStateArcArray;
        }

        @Override
        public String toString() {
            return super.toString() + " EndUnit";
        }

        @Override
        public int getOrder() {
            return 3;
        }
    }

    abstract class LexTreeState
    implements SearchState,
    SearchStateArc {
        private final Node node;
        private final WordSequence wordSequence;
        final float currentSmearTerm;
        final float currentSmearProb;

        LexTreeState(Node node, WordSequence wordSequence, float f, float f2) {
            this.node = node;
            this.wordSequence = wordSequence;
            this.currentSmearTerm = f;
            this.currentSmearProb = f2;
        }

        @Override
        public String getSignature() {
            return "lts-" + this.node.hashCode() + "-ws-" + this.wordSequence;
        }

        public float getSmearTerm() {
            return this.currentSmearTerm;
        }

        public float getSmearProb() {
            return this.currentSmearProb;
        }

        public int hashCode() {
            int n = this.wordSequence.hashCode() * 37;
            return n += this.node.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LexTreeState) {
                LexTreeState lexTreeState = (LexTreeState)object;
                if (this.node != lexTreeState.node) {
                    return false;
                }
                return this.wordSequence.equals(lexTreeState.wordSequence);
            }
            return false;
        }

        @Override
        public SearchState getState() {
            return this;
        }

        @Override
        public float getProbability() {
            return this.getLanguageProbability() + this.getInsertionProbability();
        }

        @Override
        public float getLanguageProbability() {
            return LexTreeLinguist.this.logOne;
        }

        @Override
        public float getInsertionProbability() {
            return LexTreeLinguist.this.logOne;
        }

        @Override
        public boolean isEmitting() {
            return false;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        protected Node getNode() {
            return this.node;
        }

        @Override
        public WordSequence getWordHistory() {
            return this.wordSequence;
        }

        @Override
        public Node getLexState() {
            return this.node;
        }

        @Override
        public SearchStateArc[] getSuccessors() {
            SearchStateArc[] searchStateArcArray = this.getCachedArcs();
            if (searchStateArcArray == null) {
                searchStateArcArray = this.getSuccessors(this.node);
                this.putCachedArcs(searchStateArcArray);
            }
            return searchStateArcArray;
        }

        protected SearchStateArc[] getSuccessors(Node node) {
            Node[] nodeArray = node.getSuccessors();
            SearchStateArc[] searchStateArcArray = new SearchStateArc[nodeArray.length];
            int n = 0;
            for (Node node2 : nodeArray) {
                searchStateArcArray[n] = node2 instanceof WordNode ? this.createWordStateArc((WordNode)node2, (HMMNode)this.getNode(), this) : (node2 instanceof EndNode ? this.createEndUnitArc((EndNode)node2, this) : this.createUnitStateArc((HMMNode)node2, this));
                ++n;
            }
            return searchStateArcArray;
        }

        protected SearchStateArc createWordStateArc(WordNode wordNode, HMMNode hMMNode, LexTreeState lexTreeState) {
            float f = LexTreeLinguist.this.logOne;
            Word word = wordNode.getWord();
            float f2 = lexTreeState.getSmearTerm();
            if (word.isFiller() && word != LexTreeLinguist.this.sentenceEndWord) {
                return new LexTreeWordState(wordNode, hMMNode, this.wordSequence, f2, LexTreeLinguist.this.logOne, f);
            }
            WordSequence wordSequence = this.wordSequence.addWord(word, LexTreeLinguist.this.maxDepth);
            float f3 = LexTreeLinguist.this.languageModel.getProbability(wordSequence) * LexTreeLinguist.this.languageWeight;
            f2 = LexTreeLinguist.this.getSmearTermFromLanguageModel(wordSequence);
            f = f3 - lexTreeState.getSmearProb();
            if (word == LexTreeLinguist.this.sentenceEndWord) {
                return new LexTreeEndWordState(wordNode, hMMNode, wordSequence.trim(LexTreeLinguist.this.maxDepth - 1), f2, LexTreeLinguist.this.logOne, f);
            }
            return new LexTreeWordState(wordNode, hMMNode, wordSequence.trim(LexTreeLinguist.this.maxDepth - 1), f2, LexTreeLinguist.this.logOne, f);
        }

        SearchStateArc createUnitStateArc(HMMNode hMMNode, LexTreeState lexTreeState) {
            LexTreeState lexTreeState2;
            float f = LexTreeLinguist.this.calculateInsertionProbability(hMMNode);
            float f2 = LexTreeLinguist.this.getUnigramSmear(hMMNode) + lexTreeState.getSmearTerm();
            float f3 = f2 - lexTreeState.getSmearProb();
            if (LexTreeLinguist.this.generateUnitStates) {
                lexTreeState2 = new LexTreeUnitState(hMMNode, this.getWordHistory(), lexTreeState.getSmearTerm(), f2, f3, f);
            } else {
                HMM hMM = hMMNode.getHMM();
                lexTreeState2 = new LexTreeHMMState(hMMNode, this.getWordHistory(), lexTreeState.getSmearTerm(), f2, hMM.getInitialState(), f3, f, null);
            }
            return lexTreeState2;
        }

        SearchStateArc createEndUnitArc(EndNode endNode, LexTreeState lexTreeState) {
            float f = LexTreeLinguist.this.getUnigramSmear(endNode) + lexTreeState.getSmearTerm();
            float f2 = f - lexTreeState.getSmearProb();
            float f3 = LexTreeLinguist.this.calculateInsertionProbability(endNode);
            return new LexTreeEndUnitState(endNode, this.getWordHistory(), lexTreeState.getSmearTerm(), f, f2, f3);
        }

        public String toString() {
            return "lt-" + this.node + ' ' + this.getProbability() + '{' + this.wordSequence + '}';
        }

        @Override
        public String toPrettyString() {
            return this.toString();
        }

        SearchStateArc[] getCachedArcs() {
            if (LexTreeLinguist.this.cacheEnabled) {
                SearchStateArc[] searchStateArcArray = (SearchStateArc[])LexTreeLinguist.this.arcCache.get(this);
                if (searchStateArcArray != null) {
                    LexTreeLinguist.this.cacheHits++;
                }
                if (++LexTreeLinguist.this.cacheTrys % 1000000 == 0) {
                    System.out.println("Hits: " + LexTreeLinguist.this.cacheHits + " of " + LexTreeLinguist.this.cacheTrys + ' ' + (float)LexTreeLinguist.this.cacheHits / (float)LexTreeLinguist.this.cacheTrys * 100.0f);
                }
                return searchStateArcArray;
            }
            return null;
        }

        void putCachedArcs(SearchStateArc[] searchStateArcArray) {
            if (LexTreeLinguist.this.cacheEnabled) {
                LexTreeLinguist.this.arcCache.put(this, searchStateArcArray);
            }
        }

        @Override
        public abstract int getOrder();
    }

    class LexTreeSearchGraph
    implements SearchGraph {
        private SearchState initialState;

        LexTreeSearchGraph(SearchState searchState) {
            this.initialState = searchState;
        }

        @Override
        public SearchState getInitialState() {
            return this.initialState;
        }

        @Override
        public int getNumStateOrder() {
            return 6;
        }

        @Override
        public boolean getWordTokenFirst() {
            return false;
        }
    }
}

