/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.lextree;

import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.lextree.EndNode;
import edu.cmu.sphinx.linguist.lextree.HMMNode;
import edu.cmu.sphinx.linguist.lextree.UnitNode;
import edu.cmu.sphinx.linguist.lextree.WordNode;
import java.util.HashMap;
import java.util.Map;

class Node {
    private static int nodeCount;
    private static int successorCount;
    private Object successors;
    private float logUnigramProbability;

    Node(float f) {
        this.logUnigramProbability = f;
        ++nodeCount;
    }

    public float getUnigramProbability() {
        return this.logUnigramProbability;
    }

    public void setUnigramProbability(float f) {
        this.logUnigramProbability = f;
    }

    private Node getSuccessor(Object object) {
        Map<Object, Node> map = this.getSuccessorMap();
        return map.get(object);
    }

    void putSuccessor(Object object, Node node) {
        Map<Object, Node> map = this.getSuccessorMap();
        map.put(object, node);
    }

    public Map<Object, Node> getSuccessorMap() {
        if (this.successors == null) {
            this.successors = new HashMap(4);
        }
        assert (this.successors instanceof Map);
        return (Map)this.successors;
    }

    void freeze() {
        if (this.successors instanceof Map) {
            Map<Object, Node> map = this.getSuccessorMap();
            this.successors = map.values().toArray(new Node[map.size()]);
            for (Node node : map.values()) {
                node.freeze();
            }
            successorCount += map.size();
        }
    }

    static void dumpNodeInfo() {
        System.out.println("Nodes: " + nodeCount + " successors " + successorCount + " avg " + successorCount / nodeCount);
    }

    Node addSuccessor(HMM hMM, float f) {
        Node node = null;
        Node node2 = this.getSuccessor(hMM);
        if (node2 == null) {
            node = new HMMNode(hMM, f);
            this.putSuccessor(hMM, node);
        } else {
            if (node2.getUnigramProbability() < f) {
                node2.setUnigramProbability(f);
            }
            node = node2;
        }
        return node;
    }

    WordNode addSuccessor(Pronunciation pronunciation, float f, Map<Pronunciation, WordNode> map) {
        WordNode wordNode = null;
        WordNode wordNode2 = (WordNode)this.getSuccessor(pronunciation);
        if (wordNode2 == null) {
            wordNode = map.get(pronunciation);
            if (wordNode == null) {
                wordNode = new WordNode(pronunciation, f);
                map.put(pronunciation, wordNode);
            }
            this.putSuccessor(pronunciation, wordNode);
        } else {
            if (wordNode2.getUnigramProbability() < f) {
                wordNode2.setUnigramProbability(f);
            }
            wordNode = wordNode2;
        }
        return wordNode;
    }

    void addSuccessor(WordNode wordNode) {
        this.putSuccessor(wordNode, wordNode);
    }

    EndNode addSuccessor(EndNode endNode, float f) {
        Unit unit = endNode.getBaseUnit();
        EndNode endNode2 = (EndNode)this.getSuccessor(unit);
        if (endNode2 == null) {
            this.putSuccessor(unit, endNode);
        } else {
            if (endNode2.getUnigramProbability() < f) {
                endNode2.setUnigramProbability(f);
            }
            endNode = endNode2;
        }
        return endNode;
    }

    UnitNode addSuccessor(UnitNode unitNode) {
        UnitNode unitNode2 = (UnitNode)this.getSuccessor(unitNode.getKey());
        if (unitNode2 == null) {
            this.putSuccessor(unitNode.getKey(), unitNode);
        } else {
            unitNode = unitNode2;
        }
        return unitNode;
    }

    Node[] getSuccessors() {
        if (this.successors instanceof Map) {
            this.freeze();
        }
        return (Node[])this.successors;
    }

    public String toString() {
        return "Node ";
    }
}

