/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.lextree;

import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.lextree.Node;

class WordNode
extends Node {
    private final Pronunciation pronunciation;
    private final boolean isFinal;

    WordNode(Pronunciation pronunciation, float f) {
        super(f);
        this.pronunciation = pronunciation;
        this.isFinal = pronunciation.getWord().isSentenceEndWord();
    }

    Word getWord() {
        return this.pronunciation.getWord();
    }

    Pronunciation getPronunciation() {
        return this.pronunciation;
    }

    Unit getLastUnit() {
        Unit[] unitArray = this.pronunciation.getUnits();
        return unitArray[unitArray.length - 1];
    }

    @Override
    Node[] getSuccessors() {
        throw new Error("Not supported");
    }

    @Override
    public String toString() {
        return "WordNode " + this.pronunciation + " p " + this.getUnigramProbability();
    }

    public boolean isFinal() {
        return this.isFinal;
    }
}

