/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.util;

import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.util.LinguistDumper;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class GDLDumper
extends LinguistDumper {
    @S4Boolean(defaultValue=true)
    public static final String PROP_SKIP_HMMS = "skipHMMs";
    @S4Boolean(defaultValue=false)
    public static final String PROP_VERTICAL_LAYOUT = "verticalLayout";
    @S4Boolean(defaultValue=true)
    public static final String PROP_DUMP_ARC_LABELS = "dumpArcLabels";
    private boolean skipHMMs;
    private boolean verticalLayout;
    private boolean dumpArcLabels;
    private LogMath logMath;

    public GDLDumper(String string, Linguist linguist, boolean bl, boolean bl2, boolean bl3) {
        super(string, linguist);
        this.verticalLayout = bl;
        this.skipHMMs = bl2;
        this.dumpArcLabels = bl3;
        this.setDepthFirst(false);
        this.logMath = LogMath.getLogMath();
    }

    public GDLDumper() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.verticalLayout = propertySheet.getBoolean(PROP_VERTICAL_LAYOUT);
        this.skipHMMs = propertySheet.getBoolean(PROP_SKIP_HMMS);
        this.dumpArcLabels = propertySheet.getBoolean(PROP_DUMP_ARC_LABELS);
        this.setDepthFirst(false);
    }

    protected String getDefaultName() {
        return "linguistDump.gdl";
    }

    @Override
    protected void startDump(PrintStream printStream) {
        printStream.println("graph: {");
        printStream.println("    layout_algorithm: minbackward");
        if (this.verticalLayout) {
            printStream.println("    orientation: top_to_bottom");
            printStream.println("    manhatten_edges: no");
            printStream.println("    splines: yes");
        } else {
            printStream.println("    orientation: left_to_right");
            printStream.println("    manhatten_edges: yes");
            printStream.println("    splines: no");
        }
    }

    @Override
    protected void endDump(PrintStream printStream) {
        printStream.println("}");
    }

    @Override
    protected void startDumpNode(PrintStream printStream, SearchState searchState, int n) {
        if (!this.skipHMMs || !(searchState instanceof HMMSearchState)) {
            String string = this.getColor(searchState);
            String string2 = "box";
            printStream.println("    node: {title: " + this.qs(this.getUniqueName(searchState)) + " label: " + this.qs(searchState.toPrettyString()) + " color: " + string + " shape: " + string2 + " vertical_order: " + n + '}');
        }
    }

    private String getColor(SearchState searchState) {
        String string = "lightred";
        if (searchState.isFinal()) {
            string = "magenta";
        } else if (searchState instanceof UnitSearchState) {
            string = "green";
        } else if (searchState instanceof WordSearchState) {
            string = "lightblue";
        } else if (searchState instanceof HMMSearchState) {
            string = "orange";
        }
        return string;
    }

    @Override
    protected void endDumpNode(PrintStream printStream, SearchState searchState, int n) {
    }

    @Override
    protected void dumpArc(PrintStream printStream, SearchState searchState, SearchStateArc searchStateArc, int n) {
        ArrayList<SearchStateArc> arrayList = new ArrayList<SearchStateArc>();
        if (this.skipHMMs) {
            if (searchState instanceof HMMSearchState) {
                return;
            }
            if (searchStateArc.getState() instanceof HMMSearchState) {
                this.findNextNonHMMArc(searchStateArc, arrayList);
            } else {
                arrayList.add(searchStateArc);
            }
        } else {
            arrayList.add(searchStateArc);
        }
        for (SearchStateArc searchStateArc2 : arrayList) {
            String string = "";
            String string2 = this.getArcColor(searchStateArc2);
            if (this.dumpArcLabels) {
                double d = this.logMath.logToLinear(searchStateArc2.getLanguageProbability());
                double d2 = this.logMath.logToLinear(searchStateArc2.getInsertionProbability());
                string = " label: " + this.qs('(' + this.formatEdgeLabel(d) + ',' + this.formatEdgeLabel(d2) + ')');
            }
            printStream.println("   edge: { sourcename: " + this.qs(this.getUniqueName(searchState)) + " targetname: " + this.qs(this.getUniqueName(searchStateArc2.getState())) + string + " color: " + string2 + '}');
        }
    }

    private void findNextNonHMMArc(SearchStateArc searchStateArc, List<SearchStateArc> list) {
        HashSet<SearchStateArc> hashSet = new HashSet<SearchStateArc>();
        ArrayList<SearchStateArc> arrayList = new ArrayList<SearchStateArc>();
        arrayList.add(searchStateArc);
        while (!arrayList.isEmpty()) {
            SearchStateArc searchStateArc2 = (SearchStateArc)arrayList.remove(0);
            if (hashSet.contains(searchStateArc2)) continue;
            hashSet.add(searchStateArc2);
            if (!(searchStateArc2.getState() instanceof HMMSearchState)) {
                list.add(searchStateArc2);
                continue;
            }
            arrayList.addAll(Arrays.asList(searchStateArc2.getState().getSuccessors()));
        }
    }

    private String formatEdgeLabel(double d) {
        if (d == 1.0) {
            return "1";
        }
        if (d == 0.0) {
            return "0";
        }
        int n = 5;
        String string = String.valueOf(d);
        if (string.length() > n) {
            string = Utilities.doubleToScientificString(d, 3);
        }
        return string;
    }

    private String getArcColor(SearchStateArc searchStateArc) {
        String string = null;
        if ((double)searchStateArc.getLanguageProbability() != 0.0) {
            string = "green";
        }
        if ((double)searchStateArc.getInsertionProbability() != 0.0) {
            string = string == null ? "blue" : "purple";
        }
        if (string == null) {
            string = "black";
        }
        return string;
    }

    private String qs(String string) {
        return '\"' + string + '\"';
    }

    private String getUniqueName(SearchState searchState) {
        return searchState.getSignature();
    }
}

