/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.util;

import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.LinguistProcessor;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.linguist.util.StateLevel;
import edu.cmu.sphinx.util.Cache;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4String;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class LinguistDumper
extends LinguistProcessor {
    @S4String(defaultValue="linguistDump.txt")
    public static final String PROP_FILENAME = "filename";
    private boolean depthFirst = true;
    private String filename;
    final Cache<SearchState> eqStates = new Cache();
    final Map<String, SearchState> eqSigs = new HashMap<String, SearchState>();

    public LinguistDumper(String string, Linguist linguist) {
        super(linguist);
        this.filename = string;
    }

    public LinguistDumper() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.filename = propertySheet.getString(PROP_FILENAME);
    }

    @Override
    public void run() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.filename);
            PrintStream printStream = new PrintStream(fileOutputStream);
            SearchState searchState = this.getLinguist().getSearchGraph().getInitialState();
            this.dumpSearchGraph(printStream, searchState);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Can't dump to file " + this.filename + ' ' + fileNotFoundException);
        }
    }

    protected void setDepthFirst(boolean bl) {
        this.depthFirst = bl;
    }

    protected void startDump(PrintStream printStream) {
    }

    protected void endDump(PrintStream printStream) {
    }

    protected void startDumpNode(PrintStream printStream, SearchState searchState, int n) {
    }

    protected void endDumpNode(PrintStream printStream, SearchState searchState, int n) {
    }

    protected void dumpArc(PrintStream printStream, SearchState searchState, SearchStateArc searchStateArc, int n) {
    }

    private void dumpSearchGraph(PrintStream printStream, SearchState searchState) {
        LinkedList<StateLevel> linkedList = new LinkedList<StateLevel>();
        HashSet<String> hashSet = new HashSet<String>();
        this.startDump(printStream);
        linkedList.add(new StateLevel(searchState, 0));
        while (!linkedList.isEmpty()) {
            StateLevel stateLevel = (StateLevel)linkedList.remove(0);
            int n = stateLevel.getLevel();
            SearchState searchState2 = stateLevel.getState();
            if (hashSet.contains(searchState2.getSignature())) continue;
            hashSet.add(searchState2.getSignature());
            this.startDumpNode(printStream, searchState2, n);
            SearchStateArc[] searchStateArcArray = searchState2.getSuccessors();
            for (int i = searchStateArcArray.length - 1; i >= 0; --i) {
                SearchState searchState3 = searchStateArcArray[i].getState();
                this.dumpArc(printStream, searchState2, searchStateArcArray[i], n);
                if (this.depthFirst) {
                    linkedList.add(0, new StateLevel(searchState3, n + 1));
                    continue;
                }
                linkedList.add(new StateLevel(searchState3, n + 1));
            }
            this.endDumpNode(printStream, searchState2, n);
        }
        this.endDump(printStream);
    }

    private void equalCheck(SearchState searchState) {
        SearchState searchState2;
        SearchState searchState3 = this.eqStates.cache(searchState);
        if (searchState3 == null ^ (searchState2 = this.eqSigs.get(searchState.getSignature())) == null) {
            System.out.println("Missing one: ");
            System.out.println("  state val: " + searchState);
            System.out.println("  state sig: " + searchState.getSignature());
            System.out.println("  eqState val: " + searchState3);
            System.out.println("  eqSig val: " + searchState2);
            if (searchState3 != null) {
                System.out.println("   eqState sig: " + searchState3.getSignature());
            }
            if (searchState2 != null) {
                System.out.println("   eqSig sig: " + searchState2.getSignature());
            }
        }
        if (searchState3 == null) {
            searchState3 = searchState;
        }
        if (searchState2 == null) {
            this.eqSigs.put(searchState.getSignature(), searchState);
            searchState2 = searchState;
        }
        if (!searchState3.getSignature().equals(searchState.getSignature())) {
            System.out.println("Sigs mismatch for: ");
            System.out.println("  state sig: " + searchState.getSignature());
            System.out.println("  eqSig sig: " + searchState2.getSignature());
            System.out.println("  state val: " + searchState);
            System.out.println("  eqSig val: " + searchState2);
        }
        if (!searchState3.equals(searchState)) {
            System.out.println("obj mismatch for: ");
            System.out.println("  state sig: " + searchState.getSignature());
            System.out.println("  eqSig sig: " + searchState2.getSignature());
            System.out.println("  state val: " + searchState);
            System.out.println("  eqSig val: " + searchState2);
        }
    }
}

