/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.util;

import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.LinguistProcessor;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class LinguistStats
extends LinguistProcessor {
    private final Map<Class<? extends SearchState>, Integer> stateCountByType = new HashMap<Class<? extends SearchState>, Integer>();

    public LinguistStats(Linguist linguist) {
        super(linguist);
    }

    public LinguistStats() {
    }

    @Override
    public void run() {
        Linguist linguist = this.getLinguist();
        LinkedList<SearchState> linkedList = new LinkedList<SearchState>();
        HashSet<SearchState> hashSet = new HashSet<SearchState>();
        int n = 0;
        linkedList.add(linguist.getSearchGraph().getInitialState());
        while (!linkedList.isEmpty()) {
            SearchState searchState = (SearchState)linkedList.remove(0);
            if (hashSet.contains(searchState)) continue;
            ++n;
            this.incrementStateTypeCount(searchState);
            hashSet.add(searchState);
            SearchStateArc[] searchStateArcArray = searchState.getSuccessors();
            for (int i = searchStateArcArray.length - 1; i >= 0; --i) {
                SearchState searchState2 = searchStateArcArray[i].getState();
                linkedList.add(searchState2);
            }
        }
        System.out.println("# ----------- linguist stats ------------ ");
        System.out.println("# Total states: " + n);
        this.dumpStateTypeCounts();
    }

    private void incrementStateTypeCount(SearchState searchState) {
        Integer n = this.stateCountByType.get(searchState.getClass());
        if (n == null) {
            n = 0;
        }
        n = n + 1;
        this.stateCountByType.put(searchState.getClass(), n);
    }

    private void dumpStateTypeCounts() {
        for (Map.Entry<Class<? extends SearchState>, Integer> entry : this.stateCountByType.entrySet()) {
            System.out.println("# " + entry.getKey() + ": " + entry.getValue());
        }
    }
}

