/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.util;

import edu.cmu.sphinx.linguist.Linguist;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.SearchStateArc;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class LinguistTimer {
    private final Linguist linguist;
    private final boolean details;
    int totalStates;
    int totalEmittingStates;
    int totalNonEmittingStates;
    int totalFinalStates;
    int maxSuccessors;

    public LinguistTimer(Linguist linguist, boolean bl) {
        this.linguist = linguist;
        this.details = bl;
    }

    public void timeLinguist(int n, int n2, int n3) {
        Random random = new Random(1000L);
        Timer timer = TimerPool.getTimer(this, "frameTimer");
        Timer timer2 = TimerPool.getTimer(this, "totalTimer");
        System.out.println("TestLinguist: runs " + n + " frames " + n2 + " beam " + n3);
        timer2.start();
        for (int i = 0; i < n; ++i) {
            int n4 = 0;
            List<SearchState> list = new ArrayList<SearchState>();
            list.add(this.linguist.getSearchGraph().getInitialState());
            this.linguist.startRecognition();
            for (int j = 0; j < n2; ++j) {
                ArrayList<SearchState> arrayList = list;
                list = new ArrayList(n3 * 10);
                timer.start();
                for (SearchState searchState : arrayList) {
                    this.expandState(n4, list, searchState);
                }
                timer.stop();
                Collections.shuffle(list, random);
                if (list.size() <= n3) continue;
                list = list.subList(0, n3);
            }
            this.linguist.stopRecognition();
        }
        timer2.stop();
        System.out.println(" MaxSuccessors : " + this.maxSuccessors);
        System.out.println(" TotalStates   : " + this.totalStates);
        System.out.println(" TotalEmitting : " + this.totalEmittingStates);
        System.out.println("   NonEmitting : " + this.totalNonEmittingStates);
        System.out.println("  Final States : " + this.totalFinalStates);
    }

    private void expandState(int n, List<SearchState> list, SearchState searchState) {
        SearchStateArc[] searchStateArcArray = searchState.getSuccessors();
        ++this.totalStates;
        if (searchStateArcArray.length > this.maxSuccessors) {
            this.maxSuccessors = searchStateArcArray.length;
        }
        for (SearchStateArc searchStateArc : searchStateArcArray) {
            SearchState searchState2 = searchStateArc.getState();
            if (searchState2.isEmitting()) {
                ++this.totalEmittingStates;
                list.add(searchState2);
            } else if (!searchState2.isFinal()) {
                ++this.totalNonEmittingStates;
                list.add(searchState2);
                if (this.details && searchState2.isFinal()) {
                    System.out.println("result " + searchState2.toPrettyString());
                }
                this.expandState(n + 1, list, searchState2);
            } else {
                ++this.totalFinalStates;
            }
            ++this.totalStates;
        }
    }
}

