/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.linguist.util;

import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.WordSearchState;

class StateLevel {
    private final int level;
    private final SearchState state;

    StateLevel(SearchState searchState, int n) {
        this.state = searchState;
        this.level = n;
    }

    SearchState getState() {
        return this.state;
    }

    int getLevel() {
        return this.level;
    }

    public String toString() {
        return String.valueOf(this.level) + ' ' + this.state.getSignature() + " 1 " + this.getTypeLabel(this.state);
    }

    public String getTypeLabel(SearchState searchState) {
        if (searchState instanceof UnitSearchState) {
            return "Unit";
        }
        if (searchState instanceof WordSearchState) {
            return "Word";
        }
        if (searchState instanceof HMMSearchState) {
            return "HMM";
        }
        return "other";
    }
}

