/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.recognizer;

import edu.cmu.sphinx.decoder.Decoder;
import edu.cmu.sphinx.decoder.ResultListener;
import edu.cmu.sphinx.decoder.ResultProducer;
import edu.cmu.sphinx.instrumentation.Monitor;
import edu.cmu.sphinx.instrumentation.Resetable;
import edu.cmu.sphinx.recognizer.StateListener;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4ComponentList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Recognizer
implements Configurable,
ResultProducer {
    @S4Component(type=Decoder.class)
    public static final String PROP_DECODER = "decoder";
    @S4ComponentList(type=Monitor.class)
    public static final String PROP_MONITORS = "monitors";
    private String name;
    private Decoder decoder;
    private State currentState = State.DEALLOCATED;
    private final List<StateListener> stateListeners = Collections.synchronizedList(new ArrayList());
    private List<Monitor> monitors;

    public Recognizer(Decoder decoder, List<Monitor> list) {
        this.decoder = decoder;
        this.monitors = list;
        this.name = null;
    }

    public Recognizer() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.decoder = (Decoder)propertySheet.getComponent(PROP_DECODER);
        this.monitors = propertySheet.getComponentList(PROP_MONITORS, Monitor.class);
        this.name = propertySheet.getInstanceName();
    }

    public Result recognize(String string) throws IllegalStateException {
        Result result = null;
        this.checkState(State.READY);
        try {
            this.setState(State.RECOGNIZING);
            result = this.decoder.decode(string);
        }
        finally {
            this.setState(State.READY);
        }
        return result;
    }

    public Result recognize() throws IllegalStateException {
        return this.recognize(null);
    }

    private void checkState(State state) {
        if (this.currentState != state) {
            throw new IllegalStateException("Expected state " + (Object)((Object)state) + " actual state " + (Object)((Object)this.currentState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State state) {
        this.currentState = state;
        List<StateListener> list = this.stateListeners;
        synchronized (list) {
            for (StateListener stateListener : this.stateListeners) {
                stateListener.statusChanged(this.currentState);
            }
        }
    }

    public void allocate() throws IllegalStateException {
        this.checkState(State.DEALLOCATED);
        this.setState(State.ALLOCATING);
        this.decoder.allocate();
        this.setState(State.ALLOCATED);
        this.setState(State.READY);
    }

    public void deallocate() throws IllegalStateException {
        this.checkState(State.READY);
        this.setState(State.DEALLOCATING);
        this.decoder.deallocate();
        this.setState(State.DEALLOCATED);
    }

    public State getState() {
        return this.currentState;
    }

    public void resetMonitors() {
        for (Monitor monitor : this.monitors) {
            if (!(monitor instanceof Resetable)) continue;
            ((Resetable)((Object)monitor)).reset();
        }
    }

    @Override
    public void addResultListener(ResultListener resultListener) {
        this.decoder.addResultListener(resultListener);
    }

    public void addStateListener(StateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    @Override
    public void removeResultListener(ResultListener resultListener) {
        this.decoder.removeResultListener(resultListener);
    }

    public void removeStateListener(StateListener stateListener) {
        this.stateListeners.remove(stateListener);
    }

    public String toString() {
        return "Recognizer: " + this.name + " State: " + (Object)((Object)this.currentState);
    }

    public static enum State {
        DEALLOCATED,
        ALLOCATING,
        ALLOCATED,
        READY,
        RECOGNIZING,
        DEALLOCATING,
        ERROR;

    }
}

