/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.Node;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Edge {
    protected double acousticScore;
    protected double lmScore;
    protected final Node fromNode;
    protected final Node toNode;

    protected Edge(Node node, Node node2, double d, double d2) {
        this.acousticScore = d;
        this.lmScore = d2;
        this.fromNode = node;
        this.toNode = node2;
    }

    public String toString() {
        return "Edge(" + this.fromNode + "-->" + this.toNode + '[' + this.acousticScore + ',' + this.lmScore + "])";
    }

    static void load(Lattice lattice, StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        double d2 = Double.parseDouble(stringTokenizer.nextToken());
        Node node = lattice.getNode(string);
        if (node == null) {
            throw new Error("Edge fromNode \"" + string + "\" does not exist");
        }
        Node node2 = lattice.getNode(string2);
        if (node2 == null) {
            throw new Error("Edge toNode \"" + string2 + "\" does not exist");
        }
        lattice.addEdge(node, node2, d, d2);
    }

    void dump(PrintWriter printWriter) throws IOException {
        printWriter.println("edge: " + this.fromNode.getId() + ' ' + this.toNode.getId() + ' ' + this.acousticScore + ' ' + this.lmScore);
    }

    void dumpAISee(FileWriter fileWriter) throws IOException {
        fileWriter.write("edge: { sourcename: \"" + this.fromNode.getId() + "\" targetname: \"" + this.toNode.getId() + "\" label: \"" + this.acousticScore + ',' + this.lmScore + "\" }\n");
    }

    public void dumpDot(FileWriter fileWriter) throws IOException {
        String string = "" + this.acousticScore + "," + this.lmScore;
        fileWriter.write("\tnode" + this.fromNode.getId() + " -> node" + this.toNode.getId() + " [ label=\"" + string + "\" ]\n");
    }

    public double getAcousticScore() {
        return this.acousticScore;
    }

    public double getLMScore() {
        return this.lmScore;
    }

    public Node getFromNode() {
        return this.fromNode;
    }

    public Node getToNode() {
        return this.toNode;
    }

    public void setAcousticScore(double d) {
        this.acousticScore = d;
    }

    public void setLMScore(double d) {
        this.lmScore = d;
    }

    public boolean isEquivalent(Edge edge) {
        double d = Math.abs(this.acousticScore) * 1.0E-5;
        return Math.abs(this.acousticScore - edge.getAcousticScore()) <= d && this.lmScore == edge.getLMScore() && this.fromNode.isEquivalent(edge.getFromNode()) && this.toNode.isEquivalent(edge.getToNode());
    }
}

