/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.Node;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class GDLLatticeFactory {
    private GDLLatticeFactory() {
    }

    public static Lattice getLattice(String string, Dictionary dictionary) throws IOException {
        Lattice lattice = new Lattice();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.startsWith("node")) {
                GDLLatticeFactory.createNode(string2, lattice, dictionary);
                continue;
            }
            if (!string2.startsWith("edge")) continue;
            GDLLatticeFactory.createEdge(string2, lattice);
        }
        bufferedReader.close();
        return lattice;
    }

    private static void createNode(String string, Lattice lattice, Dictionary dictionary) {
        String[] stringArray = string.split("\\s");
        String string2 = stringArray[3].substring(1, stringArray[3].length() - 1);
        String string3 = stringArray[5].substring(1);
        String string4 = stringArray[6].substring(2, stringArray[6].length() - 2);
        String string5 = string3.substring(0, string3.indexOf(91));
        string3 = string3.substring(string3.indexOf(91) + 1);
        String string6 = string3.substring(0, string3.indexOf(44));
        String string7 = string3.substring(string3.indexOf(44) + 1);
        Node node = lattice.addNode(string2, dictionary.getWord(string5), (long)Integer.parseInt(string6), (long)Integer.parseInt(string7));
        node.setPosterior(Double.parseDouble(string4));
        if (string5.equals("<s>")) {
            lattice.setInitialNode(node);
        } else if (string5.equals("</s>")) {
            lattice.setTerminalNode(node);
        }
    }

    private static void createEdge(String string, Lattice lattice) {
        String[] stringArray = string.split("\\s");
        String string2 = stringArray[3].substring(1, stringArray[3].length() - 1);
        String string3 = stringArray[5].substring(1, stringArray[5].length() - 1);
        String string4 = stringArray[7].substring(1, stringArray[7].length() - 1);
        String[] stringArray2 = string4.split(",");
        lattice.addEdge(lattice.getNode(string2), lattice.getNode(string3), Double.parseDouble(stringArray2[0]), Double.parseDouble(stringArray2[1]));
    }
}

