/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.decoder.search.AlternateHypothesisManager;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.result.Edge;
import edu.cmu.sphinx.result.Node;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.result.WordResult;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.TimeFrame;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Lattice {
    protected Node initialNode;
    protected Node terminalNode;
    protected Set<Edge> edges = new HashSet<Edge>();
    protected Map<String, Node> nodes = new HashMap<String, Node>();
    protected double logBase;
    protected LogMath logMath = LogMath.getLogMath();
    private boolean wordTokenFirst;
    private Set<Token> visitedWordTokens;
    private AlternateHypothesisManager loserManager;

    public Lattice() {
    }

    public Lattice(Result result) {
        this();
        this.visitedWordTokens = new HashSet<Token>();
        this.wordTokenFirst = result.getWordTokenFirst();
        this.loserManager = result.getAlternateHypothesisManager();
        if (this.loserManager != null) {
            this.loserManager.purge();
        }
        Token token = result.getBestFinalToken();
        assert (token != null && token.getWord().isSentenceEndWord());
        if (this.terminalNode == null) {
            this.initialNode = this.terminalNode = new Node(this.getNodeID(result.getBestToken()), token.getWord(), -1L, -1L);
            this.addNode(this.terminalNode);
        }
        this.collapseWordToken(token);
    }

    private TimeFrame getTimeFrameWordTokenFirst(Token token) {
        return new TimeFrame(0L, 0L);
    }

    private TimeFrame getTimeFrameWordTokenLast(Token token) {
        TimeFrame timeFrame = new TimeFrame(0L, 0L);
        Word word = null;
        long l = -1L;
        long l2 = -1L;
        for (Token token2 = token; token2 != null; token2 = token2.getPredecessor()) {
            if (token2.isWord()) {
                if (word != null && l >= 0L) {
                    return new TimeFrame(l, l2);
                }
                word = token2.getWord();
                l2 = token2.getCollectTime();
            }
            l = token2.getCollectTime();
        }
        if (l2 >= 0L && l >= 0L) {
            return new TimeFrame(l, l2);
        }
        return timeFrame;
    }

    private TimeFrame getTimeFrame(Token token) {
        if (this.wordTokenFirst) {
            return this.getTimeFrameWordTokenFirst(token);
        }
        return this.getTimeFrameWordTokenLast(token);
    }

    private Node getNode(Token token) {
        if (token.getWord().isSentenceEndWord()) {
            return this.terminalNode;
        }
        Node node = this.nodes.get(this.getNodeID(token));
        if (node == null) {
            TimeFrame timeFrame = this.getTimeFrame(token);
            node = new Node(this.getNodeID(token), token.getWord(), timeFrame.getStart(), timeFrame.getEnd());
            this.addNode(node);
        }
        return node;
    }

    private void collapseWordToken(Token token) {
        assert (token != null);
        if (this.visitedWordTokens.contains(token)) {
            return;
        }
        this.visitedWordTokens.add(token);
        this.collapseWordPath(this.getNode(token), token.getPredecessor(), token.getAcousticScore() + token.getInsertionScore(), token.getLanguageScore());
        if (this.loserManager != null && this.loserManager.hasAlternatePredecessors(token)) {
            for (Token token2 : this.loserManager.getAlternatePredecessors(token)) {
                this.collapseWordPath(this.getNode(token), token2, token.getAcousticScore(), token.getLanguageScore());
            }
        }
    }

    private void collapseWordPath(Node node, Token token, float f, float f2) {
        if (token == null) {
            return;
        }
        if (token.isWord()) {
            Node node2 = this.getNode(token);
            this.addEdge(node2, node, f, f2);
            if (token.getPredecessor() != null) {
                this.collapseWordToken(token);
            } else {
                assert (token.getWord().isSentenceStartWord());
                this.initialNode = node2;
            }
            return;
        }
        while (true) {
            f += token.getAcousticScore() + token.getInsertionScore();
            f2 += token.getLanguageScore();
            Token token2 = token.getPredecessor();
            if (token2 == null) {
                return;
            }
            if (token2.isWord() || this.loserManager != null && this.loserManager.hasAlternatePredecessors(token)) break;
            token = token2;
        }
        this.collapseWordPath(node, token.getPredecessor(), f, f2);
        if (this.loserManager != null && this.loserManager.hasAlternatePredecessors(token)) {
            for (Token token3 : this.loserManager.getAlternatePredecessors(token)) {
                this.collapseWordPath(node, token3, f, f2);
            }
        }
    }

    private String getNodeID(Token token) {
        return Integer.toString(token.hashCode());
    }

    public Lattice(String string) {
        this();
        try {
            String string2;
            System.err.println("Loading from " + string);
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
            while ((string2 = lineNumberReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (!stringTokenizer.hasMoreTokens()) continue;
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("edge:")) {
                    Edge.load(this, stringTokenizer);
                    continue;
                }
                if (string3.equals("node:")) {
                    Node.load(this, stringTokenizer);
                    continue;
                }
                if (string3.equals("initialNode:")) {
                    this.setInitialNode(this.getNode(stringTokenizer.nextToken()));
                    continue;
                }
                if (string3.equals("terminalNode:")) {
                    this.setTerminalNode(this.getNode(stringTokenizer.nextToken()));
                    continue;
                }
                if (string3.equals("logBase:")) {
                    this.logBase = Double.parseDouble(stringTokenizer.nextToken());
                    continue;
                }
                lineNumberReader.close();
                throw new Error("SYNTAX ERROR: " + string + '[' + lineNumberReader.getLineNumber() + "] " + string2);
            }
            lineNumberReader.close();
        }
        catch (Exception exception) {
            throw new Error(exception.toString());
        }
    }

    public static Lattice readSlf(InputStream inputStream) throws NumberFormatException, IOException {
        String string;
        Lattice lattice = new Lattice();
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 1;
        double d = 9.5;
        while ((string = lineNumberReader.readLine()) != null) {
            String[] stringArray;
            if (string.contains("Node definitions")) {
                bl2 = false;
                bl = true;
                continue;
            }
            if (string.contains("Link definitions")) {
                bl2 = true;
                bl = false;
                continue;
            }
            if (string.startsWith("#")) continue;
            if (bl) {
                stringArray = string.split("\\s+");
                if (!(stringArray.length == 3 && stringArray[0].startsWith("I=") && stringArray[1].startsWith("t=") && stringArray[2].startsWith("W="))) {
                    lineNumberReader.close();
                    throw new IOException("Unknown node definition: " + string);
                }
                int n3 = Integer.parseInt(stringArray[0].substring(2));
                long l = (long)(Double.parseDouble(stringArray[1].substring(2)) * 1000.0);
                String string2 = stringArray[2].substring(2);
                boolean bl3 = false;
                if (n3 == n || string2.equals("!ENTER")) {
                    string2 = "<s>";
                    bl3 = true;
                }
                if (n3 == n2 || string2.equals("!EXIT")) {
                    string2 = "</s>";
                    bl3 = true;
                }
                if (string2.equals("!NULL")) {
                    string2 = "<sil>";
                    bl3 = true;
                }
                if (string2.startsWith("[")) {
                    bl3 = true;
                }
                Word word = new Word(string2, new Pronunciation[0], bl3);
                Node node = lattice.addNode(Integer.toString(n3), word, l, -1L);
                if (string2.equals("<s>")) {
                    lattice.setInitialNode(node);
                }
                if (!string2.equals("</s>")) continue;
                lattice.setTerminalNode(node);
                continue;
            }
            if (bl2) {
                stringArray = string.split("\\s+");
                if (!(stringArray.length == 5 && stringArray[1].startsWith("S=") && stringArray[2].startsWith("E=") && stringArray[3].startsWith("a=") && stringArray[4].startsWith("l="))) {
                    lineNumberReader.close();
                    throw new IOException("Unknown edge definition: " + string);
                }
                String string3 = stringArray[1].substring(2);
                String string4 = stringArray[2].substring(2);
                double d2 = Double.parseDouble(stringArray[3].substring(2));
                double d3 = Double.parseDouble(stringArray[4].substring(2)) * d;
                lattice.addEdge(lattice.nodes.get(string3), lattice.nodes.get(string4), d2, d3);
                continue;
            }
            if (string.startsWith("start=")) {
                n = Integer.parseInt(string.replace("start=", ""));
            }
            if (string.startsWith("end=")) {
                n2 = Integer.parseInt(string.replace("end=", ""));
            }
            if (!string.startsWith("lmscale=")) continue;
            d = Double.parseDouble(string.replace("lmscale=", ""));
        }
        for (Node node : lattice.nodes.values()) {
            for (Edge edge : node.getLeavingEdges()) {
                if (node.getEndTime() >= 0L && node.getEndTime() <= edge.getToNode().getBeginTime()) continue;
                node.setEndTime(Math.max(edge.getToNode().getBeginTime(), node.getBeginTime()));
            }
        }
        return lattice;
    }

    public static Lattice readSlf(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        Lattice lattice = Lattice.readSlf(fileInputStream);
        fileInputStream.close();
        return lattice;
    }

    public Edge addEdge(Node node, Node node2, double d, double d2) {
        Edge edge = new Edge(node, node2, d, d2);
        node.addLeavingEdge(edge);
        node2.addEnteringEdge(edge);
        this.edges.add(edge);
        return edge;
    }

    protected Node addNode(String string, Word word, long l, long l2) {
        Node node = new Node(string, word, l, l2);
        this.addNode(node);
        return node;
    }

    public Node addNode(String string, String string2, long l, long l2) {
        Word word = new Word(string2, new Pronunciation[0], false);
        return this.addNode(string, word, l, l2);
    }

    boolean hasEdge(Edge edge) {
        return this.edges.contains(edge);
    }

    boolean hasNode(Node node) {
        return this.hasNode(node.getId());
    }

    protected boolean hasNode(String string) {
        return this.nodes.containsKey(string);
    }

    protected void addNode(Node node) {
        assert (!this.hasNode(node.getId()));
        this.nodes.put(node.getId(), node);
    }

    protected void removeNode(Node node) {
        assert (this.hasNode(node.getId()));
        this.nodes.remove(node.getId());
    }

    protected Node getNode(String string) {
        return this.nodes.get(string);
    }

    protected Collection<Node> getCopyOfNodes() {
        return new ArrayList<Node>(this.nodes.values());
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    protected void removeEdge(Edge edge) {
        this.edges.remove(edge);
    }

    public Collection<Edge> getEdges() {
        return this.edges;
    }

    public void dumpAISee(String string, String string2) {
        try {
            System.err.println("Dumping " + string2 + " to " + string);
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write("graph: {\n");
            fileWriter.write("title: \"" + string2 + "\"\n");
            fileWriter.write("display_edge_labels: yes\n");
            for (Node object : this.nodes.values()) {
                object.dumpAISee(fileWriter);
            }
            for (Edge edge : this.edges) {
                edge.dumpAISee(fileWriter);
            }
            fileWriter.write("}\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    public void dumpDot(String string, String string2) {
        try {
            System.err.println("Dumping " + string2 + " to " + string);
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write("digraph \"" + string2 + "\" {\n");
            fileWriter.write("rankdir = LR\n");
            for (Node object : this.nodes.values()) {
                object.dumpDot(fileWriter);
            }
            for (Edge edge : this.edges) {
                edge.dumpDot(fileWriter);
            }
            fileWriter.write("}\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    public void dumpSlf(Writer writer) throws IOException {
        writer.write("VERSION=1.1\n");
        writer.write("UTTERANCE=test\n");
        writer.write("base=1.0001\n");
        writer.write("lmscale=9.5\n");
        writer.write("start=0\n");
        writer.write("end=1\n");
        writer.write("#\n# Size line.\n#\n");
        writer.write("NODES=" + this.nodes.size() + "    LINKS=" + this.edges.size() + "\n");
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put(this.initialNode.getId(), 0);
        hashMap.put(this.terminalNode.getId(), 1);
        int n = 2;
        writer.write("#\n# Node definitions.\n#\n");
        for (Node object : this.nodes.values()) {
            if (hashMap.containsKey(object.getId())) {
                writer.write("I=" + hashMap.get(object.getId()));
            } else {
                hashMap.put(object.getId(), n);
                writer.write("I=" + n);
                ++n;
            }
            writer.write("    t=" + (double)object.getBeginTime() * 1.0 / 1000.0);
            String string = object.getWord().getSpelling();
            if (string.startsWith("<")) {
                string = "!NULL";
            }
            writer.write("    W=" + string);
            writer.write("\n");
        }
        writer.write("#\n# Link definitions.\n#\n");
        n = 0;
        for (Edge edge : this.edges) {
            writer.write("J=" + n);
            writer.write("    S=" + hashMap.get(edge.getFromNode().getId()));
            writer.write("    E=" + hashMap.get(edge.getToNode().getId()));
            writer.write("    a=" + edge.getAcousticScore());
            writer.write("    l=" + edge.getLMScore() / 9.5);
            writer.write("\n");
            ++n;
        }
        writer.flush();
    }

    protected void dump(PrintWriter printWriter) throws IOException {
        for (Node object : this.nodes.values()) {
            object.dump(printWriter);
        }
        for (Edge edge : this.edges) {
            edge.dump(printWriter);
        }
        printWriter.println("initialNode: " + this.initialNode.getId());
        printWriter.println("terminalNode: " + this.terminalNode.getId());
        printWriter.println("logBase: " + this.logMath.getLogBase());
        printWriter.flush();
    }

    public void dump(String string) {
        try {
            this.dump(new PrintWriter(new FileWriter(string)));
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    protected void removeNodeAndEdges(Node node) {
        for (Edge edge : node.getLeavingEdges()) {
            edge.getToNode().removeEnteringEdge(edge);
            this.edges.remove(edge);
        }
        for (Edge edge : node.getEnteringEdges()) {
            edge.getFromNode().removeLeavingEdge(edge);
            this.edges.remove(edge);
        }
        this.nodes.remove(node.getId());
        assert (this.checkConsistency());
    }

    protected void removeNodeAndCrossConnectEdges(Node node) {
        System.err.println("Removing node " + node + " and cross connecting edges");
        for (Edge edge : node.getEnteringEdges()) {
            for (Edge edge2 : node.getLeavingEdges()) {
                this.addEdge(edge.getFromNode(), edge2.getToNode(), edge.getAcousticScore(), edge.getLMScore());
            }
        }
        this.removeNodeAndEdges(node);
        assert (this.checkConsistency());
    }

    public Node getInitialNode() {
        return this.initialNode;
    }

    public void setInitialNode(Node node) {
        this.initialNode = node;
    }

    public Node getTerminalNode() {
        return this.terminalNode;
    }

    public void setTerminalNode(Node node) {
        this.terminalNode = node;
    }

    public void dumpAllPaths() {
        for (String string : this.allPaths()) {
            System.out.println(string);
        }
    }

    public List<String> allPaths() {
        return this.allPathsFrom("", this.initialNode);
    }

    protected List<String> allPathsFrom(String string, Node node) {
        String string2 = string + ' ' + node.getWord();
        LinkedList<String> linkedList = new LinkedList<String>();
        if (node == this.terminalNode) {
            linkedList.add(string2);
        } else {
            for (Edge edge : node.getLeavingEdges()) {
                linkedList.addAll(this.allPathsFrom(string2, edge.getToNode()));
            }
        }
        return linkedList;
    }

    boolean checkConsistency() {
        for (Node object : this.nodes.values()) {
            for (Edge edge : object.getEnteringEdges()) {
                if (this.hasEdge(edge)) continue;
                throw new Error("Lattice has NODE with missing FROM edge: " + object + ',' + edge);
            }
            for (Edge edge : object.getLeavingEdges()) {
                if (this.hasEdge(edge)) continue;
                throw new Error("Lattice has NODE with missing TO edge: " + object + ',' + edge);
            }
        }
        for (Edge edge : this.edges) {
            if (!this.hasNode(edge.getFromNode())) {
                throw new Error("Lattice has EDGE with missing FROM node: " + edge);
            }
            if (!this.hasNode(edge.getToNode())) {
                throw new Error("Lattice has EDGE with missing TO node: " + edge);
            }
            if (!edge.getToNode().hasEdgeFromNode(edge.getFromNode())) {
                throw new Error("Lattice has EDGE with TO node with no corresponding FROM edge: " + edge);
            }
            if (edge.getFromNode().hasEdgeToNode(edge.getToNode())) continue;
            throw new Error("Lattice has EDGE with FROM node with no corresponding TO edge: " + edge);
        }
        return true;
    }

    protected void sortHelper(Node node, List<Node> list, Set<Node> set) {
        if (set.contains(node)) {
            return;
        }
        set.add(node);
        if (node == null) {
            throw new Error("Node is null");
        }
        for (Edge edge : node.getLeavingEdges()) {
            this.sortHelper(edge.getToNode(), list, set);
        }
        list.add(node);
    }

    public List<Node> sortNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>(this.nodes.size());
        this.sortHelper(this.initialNode, arrayList, new HashSet<Node>());
        Collections.reverse(arrayList);
        return arrayList;
    }

    public void computeNodePosteriors(float f) {
        this.computeNodePosteriors(f, false);
    }

    public void computeNodePosteriors(float f, boolean bl) {
        if (this.initialNode == null) {
            return;
        }
        this.initialNode.setForwardScore(0.0);
        this.initialNode.setViterbiScore(0.0);
        List<Node> list = this.sortNodes();
        assert (list.get(0) == this.initialNode);
        for (Node node : list) {
            for (Edge iterator2 : node.getLeavingEdges()) {
                double node2 = iterator2.getFromNode().getForwardScore();
                double d = this.computeEdgeScore(iterator2, f, bl);
                iterator2.getToNode().setForwardScore(this.logMath.addAsLinear((float)(node2 += d), (float)iterator2.getToNode().getForwardScore()));
                double d2 = iterator2.getFromNode().getViterbiScore() + d;
                if (iterator2.getToNode().getBestPredecessor() != null && !(d2 > iterator2.getToNode().getViterbiScore())) continue;
                iterator2.getToNode().setBestPredecessor(node);
                iterator2.getToNode().setViterbiScore(d2);
            }
        }
        this.terminalNode.setBackwardScore(0.0);
        assert (list.get(list.size() - 1) == this.terminalNode);
        Iterator<Node> iterator = list.listIterator(list.size() - 1);
        while (iterator.hasPrevious()) {
            Node node;
            node = (Node)iterator.previous();
            Collection<Edge> collection = node.getLeavingEdges();
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                Edge edge = (Edge)iterator2.next();
                double d = edge.getToNode().getBackwardScore();
                edge.getFromNode().setBackwardScore(this.logMath.addAsLinear((float)(d += this.computeEdgeScore(edge, f, bl)), (float)edge.getFromNode().getBackwardScore()));
            }
        }
        double d = this.terminalNode.getForwardScore();
        for (Node node : this.nodes.values()) {
            node.setPosterior(node.getForwardScore() + node.getBackwardScore() - d);
        }
    }

    public List<Node> getViterbiPath() {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Node node = this.terminalNode; node != this.initialNode; node = node.getBestPredecessor()) {
            linkedList.addFirst(node);
        }
        linkedList.addFirst(this.initialNode);
        return linkedList;
    }

    public List<WordResult> getWordResultPath() {
        List<Node> list = this.getViterbiPath();
        LinkedList<WordResult> linkedList = new LinkedList<WordResult>();
        for (Node node : list) {
            if (node.getWord().isSentenceStartWord() || node.getWord().isSentenceEndWord()) continue;
            linkedList.add(new WordResult(node));
        }
        return linkedList;
    }

    private double computeEdgeScore(Edge edge, float f, boolean bl) {
        if (bl) {
            return edge.getAcousticScore();
        }
        return edge.getAcousticScore() + edge.getLMScore() * (double)f;
    }

    public boolean isEquivalent(Lattice lattice) {
        return this.checkNodesEquivalent(this.initialNode, lattice.getInitialNode());
    }

    private boolean checkNodesEquivalent(Node node, Node node2) {
        assert (node != null && node2 != null);
        boolean bl = node.isEquivalent(node2);
        if (bl) {
            Collection<Edge> collection = node.getCopyOfLeavingEdges();
            Collection<Edge> collection2 = node2.getCopyOfLeavingEdges();
            System.out.println("# edges: " + collection.size() + ' ' + collection2.size());
            for (Edge edge : collection) {
                Edge edge2 = node2.findEquivalentLeavingEdge(edge);
                if (edge2 == null) {
                    System.out.println("Equivalent edge not found, lattices not equivalent.");
                    return false;
                }
                if (!collection2.remove(edge2)) {
                    System.out.println("Equivalent edge already matched, lattices not equivalent.");
                    return false;
                }
                if (bl &= this.checkNodesEquivalent(edge.getToNode(), edge2.getToNode())) continue;
                return false;
            }
            if (!collection2.isEmpty()) {
                System.out.println("One lattice has too many edges.");
                return false;
            }
        }
        return bl;
    }

    boolean isFillerNode(Node node) {
        Word word = node.getWord();
        if (word.isSentenceStartWord() || word.isSentenceEndWord()) {
            return false;
        }
        return word.isFiller();
    }
}

