/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.result.Edge;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.Node;
import java.util.ArrayList;

public class LatticeOptimizer {
    protected final Lattice lattice;

    public LatticeOptimizer(Lattice lattice) {
        this.lattice = lattice;
    }

    public void optimize() {
        this.optimizeForward();
        this.optimizeBackward();
    }

    protected void optimizeForward() {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (Node node : this.lattice.getCopyOfNodes()) {
                if (!this.lattice.hasNode(node)) continue;
                bl |= this.optimizeNodeForward(node);
            }
        }
    }

    protected boolean optimizeNodeForward(Node node) {
        assert (this.lattice.hasNode(node));
        ArrayList<Edge> arrayList = new ArrayList<Edge>(node.getLeavingEdges());
        for (int i = 0; i < arrayList.size(); ++i) {
            Edge edge = (Edge)arrayList.get(i);
            for (int j = i + 1; j < arrayList.size(); ++j) {
                Edge edge2 = (Edge)arrayList.get(j);
                assert (edge != edge2);
                if (!this.equivalentNodesForward(edge.getToNode(), edge2.getToNode())) continue;
                this.mergeNodesAndEdgesForward(edge, edge2);
                return true;
            }
        }
        return false;
    }

    protected boolean equivalentNodesForward(Node node, Node node2) {
        assert (this.lattice.hasNode(node));
        assert (this.lattice.hasNode(node2));
        if (!this.equivalentNodeLabels(node, node2)) {
            return false;
        }
        return node.hasEquivalentEnteringEdges(node2);
    }

    protected void mergeNodesAndEdgesForward(Edge edge, Edge edge2) {
        Edge edge3;
        assert (this.lattice.hasNode(edge.getFromNode()));
        assert (this.lattice.hasEdge(edge));
        assert (this.lattice.hasEdge(edge2));
        assert (edge.getFromNode() == edge2.getFromNode());
        Node node = edge.getToNode();
        Node node2 = edge2.getToNode();
        assert (node.hasEquivalentEnteringEdges(node2));
        assert (node.getWord().equals(node2.getWord()));
        for (Edge edge4 : node2.getEnteringEdges()) {
            edge3 = node.getEdgeFromNode(edge4.getFromNode());
            assert (edge3 != null);
            edge3.setAcousticScore(this.mergeAcousticScores(edge4.getAcousticScore(), edge3.getAcousticScore()));
            edge3.setLMScore(this.mergeLanguageScores(edge4.getLMScore(), edge3.getLMScore()));
        }
        for (Edge edge4 : node2.getLeavingEdges()) {
            edge3 = node.getEdgeToNode(edge4.getToNode());
            if (edge3 == null) {
                this.lattice.addEdge(node, edge4.getToNode(), edge4.getAcousticScore(), edge4.getLMScore());
                continue;
            }
            edge3.setAcousticScore(this.mergeAcousticScores(edge4.getAcousticScore(), edge3.getAcousticScore()));
            edge3.setLMScore(this.mergeLanguageScores(edge4.getLMScore(), edge3.getLMScore()));
        }
        this.lattice.removeNodeAndEdges(node2);
    }

    protected void optimizeBackward() {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (Node node : this.lattice.getCopyOfNodes()) {
                if (!this.lattice.hasNode(node)) continue;
                bl |= this.optimizeNodeBackward(node);
            }
        }
    }

    protected boolean optimizeNodeBackward(Node node) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>(node.getEnteringEdges());
        for (int i = 0; i < arrayList.size(); ++i) {
            Edge edge = (Edge)arrayList.get(i);
            for (int j = i + 1; j < node.getEnteringEdges().size(); ++j) {
                Edge edge2 = (Edge)arrayList.get(j);
                assert (edge != edge2);
                if (!this.equivalentNodesBackward(edge.getFromNode(), edge2.getFromNode())) continue;
                this.mergeNodesAndEdgesBackward(edge, edge2);
                return true;
            }
        }
        return false;
    }

    protected boolean equivalentNodesBackward(Node node, Node node2) {
        assert (this.lattice.hasNode(node));
        assert (this.lattice.hasNode(node2));
        if (!this.equivalentNodeLabels(node, node2)) {
            return false;
        }
        return node.hasEquivalentLeavingEdges(node2);
    }

    protected boolean equivalentNodeLabels(Node node, Node node2) {
        return node.getWord().equals(node2.getWord()) && node.getBeginTime() == node2.getBeginTime() && node.getEndTime() == node2.getEndTime();
    }

    protected void mergeNodesAndEdgesBackward(Edge edge, Edge edge2) {
        Edge edge3;
        assert (this.lattice.hasNode(edge.getToNode()));
        assert (this.lattice.hasEdge(edge));
        assert (this.lattice.hasEdge(edge2));
        assert (edge.getToNode() == edge2.getToNode());
        Node node = edge.getFromNode();
        Node node2 = edge2.getFromNode();
        assert (node.hasEquivalentLeavingEdges(node2));
        assert (node.getWord().equals(node2.getWord()));
        for (Edge edge4 : node2.getLeavingEdges()) {
            edge3 = node.getEdgeToNode(edge4.getToNode());
            assert (edge3 != null);
            edge3.setAcousticScore(this.mergeAcousticScores(edge4.getAcousticScore(), edge3.getAcousticScore()));
            edge3.setLMScore(this.mergeLanguageScores(edge4.getLMScore(), edge3.getLMScore()));
        }
        for (Edge edge4 : node2.getEnteringEdges()) {
            edge3 = node.getEdgeFromNode(edge4.getFromNode());
            if (edge3 == null) {
                this.lattice.addEdge(edge4.getFromNode(), node, edge4.getAcousticScore(), edge4.getLMScore());
                continue;
            }
            edge3.setAcousticScore(this.mergeAcousticScores(edge4.getAcousticScore(), edge3.getAcousticScore()));
            edge3.setLMScore(this.mergeLanguageScores(edge4.getLMScore(), edge3.getLMScore()));
        }
        this.lattice.removeNodeAndEdges(node2);
    }

    protected void removeHangingNodes() {
        for (Node node : this.lattice.getCopyOfNodes()) {
            if (!this.lattice.hasNode(node) || node == this.lattice.getInitialNode() || node == this.lattice.getTerminalNode() || !node.getLeavingEdges().isEmpty() && !node.getEnteringEdges().isEmpty()) continue;
            this.lattice.removeNodeAndEdges(node);
            this.removeHangingNodes();
            return;
        }
    }

    private double mergeAcousticScores(double d, double d2) {
        return Math.max(d, d2);
    }

    private double mergeLanguageScores(double d, double d2) {
        return Math.max(d, d2);
    }
}

