/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.linguist.WordSequence;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.linguist.language.ngram.LanguageModel;
import edu.cmu.sphinx.result.Edge;
import edu.cmu.sphinx.result.Lattice;
import java.util.LinkedList;
import java.util.List;

public class LatticeRescorer {
    protected final Lattice lattice;
    protected final LanguageModel model;
    private int depth;
    private float languageWeigth = 8.0f;

    public LatticeRescorer(Lattice lattice, LanguageModel languageModel) {
        this.lattice = lattice;
        this.model = languageModel;
        this.depth = languageModel.getMaxDepth();
    }

    private void rescoreEdges() {
        for (Edge edge : this.lattice.edges) {
            float f = -3.4028235E38f;
            if (this.lattice.isFillerNode(edge.getToNode())) {
                edge.setLMScore(f);
                continue;
            }
            List<String> list = this.allPathsTo("", edge, this.depth);
            for (String string : list) {
                LinkedList<Word> linkedList = new LinkedList<Word>();
                for (String string2 : string.split(" ")) {
                    linkedList.add(new Word(string2, null, false));
                }
                linkedList.add(edge.getToNode().getWord());
                WordSequence object = new WordSequence(linkedList);
                float f2 = this.model.getProbability(object) * this.languageWeigth;
                if (!(f < f2)) continue;
                f = f2;
            }
            edge.setLMScore(f);
        }
    }

    protected List<String> allPathsTo(String string, Edge edge, int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = string;
        boolean bl = this.lattice.isFillerNode(edge.getFromNode());
        if (!bl) {
            string2 = edge.getFromNode().getWord().toString() + ' ' + string2;
        }
        if (n == 2 || edge.getFromNode().equals(this.lattice.getInitialNode())) {
            linkedList.add(string2);
        } else {
            int n2 = bl ? 0 : 1;
            for (Edge edge2 : edge.getFromNode().getEnteringEdges()) {
                linkedList.addAll(this.allPathsTo(string2, edge2, n - n2));
            }
        }
        return linkedList;
    }

    public void rescore() {
        this.rescoreEdges();
    }
}

