/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.result.BoundedPriorityQueue;
import edu.cmu.sphinx.result.Edge;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.result.Node;
import java.util.Collection;
import java.util.HashSet;

public class Nbest {
    protected Lattice lattice;

    public Nbest(Lattice lattice) {
        this.lattice = lattice;
    }

    public Collection<String> getNbest(int n) {
        HashSet<String> hashSet = new HashSet<String>();
        BoundedPriorityQueue<NBestPath> boundedPriorityQueue = new BoundedPriorityQueue<NBestPath>(n);
        boundedPriorityQueue.add(new NBestPath("<s>", this.lattice.getInitialNode(), 0.0, 0.0));
        while (hashSet.size() < n && boundedPriorityQueue.size() > 0) {
            NBestPath nBestPath = (NBestPath)boundedPriorityQueue.poll();
            if (nBestPath.node.equals(this.lattice.terminalNode)) {
                hashSet.add(nBestPath.path);
                continue;
            }
            for (Edge edge : nBestPath.node.getLeavingEdges()) {
                Node node = edge.getToNode();
                double d = nBestPath.forwardScore + edge.getAcousticScore() + edge.getLMScore();
                double d2 = d + node.getBackwardScore();
                String string = this.getNewPathString(nBestPath, node);
                NBestPath nBestPath2 = new NBestPath(string, node, d2, d);
                boundedPriorityQueue.add(nBestPath2);
            }
        }
        return hashSet;
    }

    private String getNewPathString(NBestPath nBestPath, Node node) {
        String string = node.getWord().isSentenceEndWord() ? nBestPath.path + " </s>" : (node.getWord().isFiller() ? nBestPath.path : nBestPath.path + " " + node.getWord());
        return string;
    }

    private void printQueue(BoundedPriorityQueue<NBestPath> boundedPriorityQueue) {
        System.out.println();
        for (NBestPath nBestPath : boundedPriorityQueue) {
            System.out.println(nBestPath);
        }
    }

    class NBestPath
    implements Comparable<NBestPath> {
        String path;
        Node node;
        double score;
        double forwardScore;

        public NBestPath(String string, Node node, double d, double d2) {
            this.path = string;
            this.node = node;
            this.score = d;
            this.forwardScore = d2;
        }

        @Override
        public int compareTo(NBestPath nBestPath) {
            return Double.compare(this.score, nBestPath.score);
        }

        public String toString() {
            return this.path + " [" + this.score + ',' + this.forwardScore + ']';
        }
    }
}

