/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.result.Edge;
import edu.cmu.sphinx.result.Lattice;
import edu.cmu.sphinx.util.TimeFrame;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class Node {
    private static int nodeCount;
    private String id;
    private Word word;
    private long beginTime = -1L;
    private long endTime = -1L;
    private List<Edge> enteringEdges = new ArrayList<Edge>();
    private List<Edge> leavingEdges = new ArrayList<Edge>();
    private double forwardScore;
    private double backwardScore;
    private double posterior;
    private Node bestPredecessor;
    private double viterbiScore;
    private Set<Node> descendants;

    protected Node(Word word, long l, long l2) {
        this(Node.getNextNodeId(), word, l, l2);
    }

    protected Node(String string, Word word, long l, long l2) {
        ++nodeCount;
        this.id = string;
        this.word = word;
        this.beginTime = l;
        this.endTime = l2;
        assert (l <= l2 || l2 < 0L);
        this.forwardScore = -3.4028234663852886E38;
        this.backwardScore = -3.4028234663852886E38;
        this.posterior = -3.4028234663852886E38;
    }

    protected static String getNextNodeId() {
        return Integer.toString(nodeCount);
    }

    protected boolean hasEdgeToNode(Node node) {
        return this.getEdgeToNode(node) != null;
    }

    public Edge getEdgeToNode(Node node) {
        for (Edge edge : this.leavingEdges) {
            if (edge.getToNode() != node) continue;
            return edge;
        }
        return null;
    }

    protected boolean hasEdgeFromNode(Node node) {
        return this.getEdgeFromNode(node) != null;
    }

    public Edge getEdgeFromNode(Node node) {
        for (Edge edge : this.enteringEdges) {
            if (edge.getFromNode() != node) continue;
            return edge;
        }
        return null;
    }

    protected boolean hasEquivalentEnteringEdges(Node node) {
        if (this.enteringEdges.size() != node.getEnteringEdges().size()) {
            return false;
        }
        for (Edge edge : this.enteringEdges) {
            Node node2 = edge.getFromNode();
            if (node.hasEdgeFromNode(node2)) continue;
            return false;
        }
        return true;
    }

    public boolean hasEquivalentLeavingEdges(Node node) {
        if (this.leavingEdges.size() != node.getLeavingEdges().size()) {
            return false;
        }
        for (Edge edge : this.leavingEdges) {
            Node node2 = edge.getToNode();
            if (node.hasEdgeToNode(node2)) continue;
            return false;
        }
        return true;
    }

    public Collection<Edge> getEnteringEdges() {
        return this.enteringEdges;
    }

    public Collection<Edge> getLeavingEdges() {
        return this.leavingEdges;
    }

    public Collection<Edge> getCopyOfEnteringEdges() {
        return new ArrayList<Edge>(this.enteringEdges);
    }

    public Collection<Edge> getCopyOfLeavingEdges() {
        return new ArrayList<Edge>(this.leavingEdges);
    }

    protected void addEnteringEdge(Edge edge) {
        this.enteringEdges.add(edge);
    }

    protected void addLeavingEdge(Edge edge) {
        this.leavingEdges.add(edge);
    }

    protected void removeEnteringEdge(Edge edge) {
        this.enteringEdges.remove(edge);
    }

    public void removeLeavingEdge(Edge edge) {
        this.leavingEdges.remove(edge);
    }

    public String getId() {
        return this.id;
    }

    public Word getWord() {
        return this.word;
    }

    public long getBeginTime() {
        if (this.beginTime == -1L) {
            this.calculateBeginTime();
        }
        return this.beginTime;
    }

    public void setBeginTime(long l) {
        assert (l <= this.endTime);
        this.beginTime = l;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long l) {
        assert (this.beginTime <= l);
        this.endTime = l;
    }

    public TimeFrame getTimeFrame() {
        return new TimeFrame(this.getBeginTime(), this.getEndTime());
    }

    public String toString() {
        return "Node(" + this.word.getSpelling() + ',' + this.getBeginTime() + '|' + this.getEndTime() + ')';
    }

    void dumpAISee(FileWriter fileWriter) throws IOException {
        String string = String.valueOf(this.getPosterior());
        if (this.getPosterior() == -3.4028234663852886E38) {
            string = "log zero";
        }
        fileWriter.write("node: { title: \"" + this.id + "\" label: \"" + this.getWord() + '[' + this.getBeginTime() + ',' + this.getEndTime() + " p:" + string + "]\" }\n");
    }

    public void dumpDot(FileWriter fileWriter) throws IOException {
        String string = String.valueOf(this.getPosterior());
        if (this.getPosterior() == -3.4028234663852886E38) {
            string = "log zero";
        }
        String string2 = this.getWord().toString() + '[' + this.getBeginTime() + ',' + this.getEndTime() + " p:" + string + ']';
        fileWriter.write("\tnode" + this.id + " [ label=\"" + string2 + "\" ]\n");
    }

    void dump(PrintWriter printWriter) throws IOException {
        printWriter.println("node: " + this.id + ' ' + this.word.getSpelling() + ' ' + this.getBeginTime() + ' ' + this.getEndTime());
    }

    static void load(Lattice lattice, StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        long l = Long.parseLong(stringTokenizer.nextToken());
        long l2 = Long.parseLong(stringTokenizer.nextToken());
        Word word = new Word(string2, new Pronunciation[]{}, string2.startsWith("<") || string2.startsWith("["));
        lattice.addNode(string, word, l, l2);
    }

    public double getBackwardScore() {
        return this.backwardScore;
    }

    public void setBackwardScore(double d) {
        this.backwardScore = d;
    }

    public double getForwardScore() {
        return this.forwardScore;
    }

    public void setForwardScore(double d) {
        this.forwardScore = d;
    }

    public double getPosterior() {
        return this.posterior;
    }

    public void setPosterior(double d) {
        this.posterior = d;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Node && this.id.equals(((Node)object).getId());
    }

    private void calculateBeginTime() {
        this.beginTime = 0L;
        for (Edge edge : this.enteringEdges) {
            if (edge.getFromNode().getEndTime() <= this.beginTime) continue;
            this.beginTime = edge.getFromNode().getEndTime();
        }
    }

    public List<Node> getChildNodes() {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Edge edge : this.leavingEdges) {
            linkedList.add(edge.getToNode());
        }
        return linkedList;
    }

    protected void cacheDescendants() {
        this.descendants = new HashSet<Node>();
        this.cacheDescendantsHelper(this);
    }

    protected void cacheDescendantsHelper(Node node) {
        for (Node node2 : node.getChildNodes()) {
            if (this.descendants.contains(node2)) continue;
            this.descendants.add(node2);
            this.cacheDescendantsHelper(node2);
        }
    }

    protected boolean isAncestorHelper(List<Node> list, Node node, Set<Node> set) {
        for (Node node2 : list) {
            if (set.contains(node2)) continue;
            set.add(node2);
            if (node2.equals(node)) {
                return true;
            }
            if (!this.isAncestorHelper(node2.getChildNodes(), node, set)) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestorOf(Node node) {
        if (this.descendants != null) {
            return this.descendants.contains(node);
        }
        if (this.equals(node)) {
            return true;
        }
        HashSet<Node> hashSet = new HashSet<Node>();
        hashSet.add(this);
        return this.isAncestorHelper(this.getChildNodes(), node, hashSet);
    }

    public boolean hasAncestralRelationship(Node node) {
        return this.isAncestorOf(node) || node.isAncestorOf(this);
    }

    public boolean isEquivalent(Node node) {
        return this.word.getSpelling().equals(node.getWord().getSpelling()) && this.getEnteringEdges().size() == node.getEnteringEdges().size() && this.getLeavingEdges().size() == node.getLeavingEdges().size() && this.getBeginTime() == node.getBeginTime() && this.endTime == node.getEndTime();
    }

    public Edge findEquivalentLeavingEdge(Edge edge) {
        for (Edge edge2 : this.leavingEdges) {
            if (!edge2.isEquivalent(edge)) continue;
            return edge2;
        }
        return null;
    }

    public Node getBestPredecessor() {
        return this.bestPredecessor;
    }

    public void setBestPredecessor(Node node) {
        this.bestPredecessor = node;
    }

    public double getViterbiScore() {
        return this.viterbiScore;
    }

    public void setViterbiScore(double d) {
        this.viterbiScore = d;
    }
}

