/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.decoder.search.ActiveList;
import edu.cmu.sphinx.decoder.search.AlternateHypothesisManager;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.result.FrameStatistics;
import edu.cmu.sphinx.result.WordResult;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.TimeFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Result {
    private final ActiveList activeList;
    private final List<Token> resultList;
    private AlternateHypothesisManager alternateHypothesisManager;
    private boolean isFinal;
    private boolean wordTokenFirst;
    private final long currentCollectTime;
    private String reference;
    private final LogMath logMath;
    private final boolean toCreateLattice;

    public Result(AlternateHypothesisManager alternateHypothesisManager, ActiveList activeList, List<Token> list, long l, boolean bl, boolean bl2, boolean bl3) {
        this(activeList, list, l, bl, bl2, bl3);
        this.alternateHypothesisManager = alternateHypothesisManager;
    }

    public Result(ActiveList activeList, List<Token> list, long l, boolean bl, boolean bl2, boolean bl3) {
        this.activeList = activeList;
        this.resultList = list;
        this.currentCollectTime = l;
        this.isFinal = bl;
        this.toCreateLattice = bl3;
        this.wordTokenFirst = bl2;
        this.logMath = LogMath.getLogMath();
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean toCreateLattice() {
        return this.toCreateLattice;
    }

    public LogMath getLogMath() {
        return this.logMath;
    }

    public ActiveList getActiveTokens() {
        return this.activeList;
    }

    public List<Token> getResultTokens() {
        return this.resultList;
    }

    public AlternateHypothesisManager getAlternateHypothesisManager() {
        return this.alternateHypothesisManager;
    }

    public long getCollectTime() {
        return this.currentCollectTime;
    }

    public Token getBestFinalToken() {
        Token token = null;
        for (Token token2 : this.resultList) {
            if (token != null && !(token2.getScore() > token.getScore())) continue;
            token = token2;
        }
        return token;
    }

    public Token getBestToken() {
        Token token = this.getBestFinalToken();
        if (token == null) {
            token = this.getBestActiveToken();
        }
        return token;
    }

    public Token getBestActiveToken() {
        Token token = null;
        if (this.activeList != null) {
            for (Token token2 : this.activeList) {
                if (token != null && !(token2.getScore() > token.getScore())) continue;
                token = token2;
            }
        }
        return token;
    }

    public Token findToken(String string) {
        string = string.trim();
        for (Token token : this.resultList) {
            if (!string.equals(token.getWordPathNoFiller())) continue;
            return token;
        }
        return null;
    }

    public List<Token> findPartialMatchingTokens(String string) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        string = string.trim();
        for (Token token : this.activeList) {
            if (!string.startsWith(token.getWordPathNoFiller())) continue;
            arrayList.add(token);
        }
        return arrayList;
    }

    public Token getBestActiveParitalMatchingToken(String string) {
        List<Token> list = this.findPartialMatchingTokens(string);
        Token token = null;
        for (Token token2 : list) {
            if (token != null && !(token2.getScore() > token.getScore())) continue;
            token = token2;
        }
        return token;
    }

    public FrameStatistics[] getFrameStatistics() {
        return null;
    }

    public int getStartFrame() {
        return 0;
    }

    public int getEndFrame() {
        return 0;
    }

    public List<Data> getDataFrames() {
        Token token = this.getBestToken();
        if (token == null) {
            return null;
        }
        LinkedList<Data> linkedList = new LinkedList<Data>();
        do {
            Data data;
            if ((data = token.getData()) == null) continue;
            linkedList.add(0, data);
        } while ((token = token.getPredecessor()) != null);
        return linkedList;
    }

    public String getBestResultNoFiller() {
        Token token = this.getBestToken();
        if (token == null) {
            return "";
        }
        return token.getWordPathNoFiller();
    }

    public String getBestFinalResultNoFiller() {
        Token token = this.getBestFinalToken();
        if (token == null) {
            return "";
        }
        return token.getWordPathNoFiller();
    }

    public String getBestPronunciationResult() {
        Token token = this.getBestFinalToken();
        if (token == null) {
            return "";
        }
        return token.getWordPath(false, true);
    }

    public List<WordResult> getTimedBestResult(boolean bl) {
        Token token = this.getBestToken();
        if (token == null) {
            return Collections.emptyList();
        }
        if (this.wordTokenFirst) {
            return this.getTimedWordPath(token, bl);
        }
        return this.getTimedWordTokenLastPath(token, bl);
    }

    private List<WordResult> getTimedWordPath(Token token, boolean bl) {
        long l = -1L;
        ArrayList<WordResult> arrayList = new ArrayList<WordResult>();
        while (token != null) {
            if (l < 0L) {
                l = token.getCollectTime();
            }
            if (token.isWord()) {
                Word word = token.getWord();
                if (bl || !word.isFiller()) {
                    TimeFrame timeFrame = new TimeFrame(token.getCollectTime(), l);
                    arrayList.add(new WordResult(word, timeFrame, token.getScore(), 1.0));
                }
                l = token.getCollectTime();
            }
            token = token.getPredecessor();
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private List<WordResult> getTimedWordTokenLastPath(Token token, boolean bl) {
        long l = -1L;
        long l2 = -1L;
        Word word = null;
        ArrayList<WordResult> arrayList = new ArrayList<WordResult>();
        while (token != null) {
            if (token.isWord()) {
                if (word != null && l >= 0L && (bl || !word.isFiller())) {
                    TimeFrame timeFrame = new TimeFrame(l2, l);
                    arrayList.add(new WordResult(word, timeFrame, token.getScore(), 1.0));
                }
                l = token.getCollectTime();
                word = token.getWord();
            }
            l2 = token.getCollectTime();
            token = token.getPredecessor();
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public String toString() {
        Token token = this.getBestToken();
        if (token == null) {
            return "";
        }
        return token.getWordPath();
    }

    void setFinal(boolean bl) {
        this.isFinal = bl;
    }

    public boolean validate() {
        boolean bl = true;
        for (Token token : this.activeList) {
            if (token.validate()) continue;
            bl = false;
            token.dumpTokenPath();
        }
        return bl;
    }

    public void setReferenceText(String string) {
        this.reference = string;
    }

    public String getReferenceText() {
        return this.reference;
    }

    public boolean getWordTokenFirst() {
        return this.wordTokenFirst;
    }
}

