/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.result;

import edu.cmu.sphinx.decoder.search.AlternateHypothesisManager;
import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.linguist.HMMSearchState;
import edu.cmu.sphinx.linguist.SearchState;
import edu.cmu.sphinx.linguist.UnitSearchState;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.result.Result;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TokenGraphDumper {
    private final AlternateHypothesisManager loserManager;
    private final Result result;
    private final Map<Token, Integer> tokenIDMap;
    private final Set<Token> dumpedTokens;
    private int ID;

    public TokenGraphDumper(Result result) {
        this.result = result;
        this.loserManager = result.getAlternateHypothesisManager();
        this.tokenIDMap = new HashMap<Token, Integer>();
        this.dumpedTokens = new HashSet<Token>();
    }

    public void dumpGDL(String string, String string2) {
        try {
            System.err.println("Dumping " + string + " to " + string2);
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(this.dumpGDL(string));
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String dumpGDL(String string) {
        StringBuilder stringBuilder = new StringBuilder("graph: {\n");
        stringBuilder.append("title: \"").append(string).append("\"\n");
        stringBuilder.append("display_edge_labels: yes\n");
        for (Token token : this.result.getResultTokens()) {
            stringBuilder.append(this.dumpTokenGDL(token));
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private String dumpTokenGDL(Token token) {
        List<Token> list;
        if (this.dumpedTokens.contains(token)) {
            return "";
        }
        String string = "[" + token.getAcousticScore() + token.getInsertionScore() + ',' + token.getLanguageScore() + ']';
        if (token.isWord()) {
            string = token.getWord().getSpelling() + string;
        }
        String string2 = null;
        if (token.getSearchState() != null) {
            string2 = this.getColor(token.getSearchState());
        }
        StringBuilder stringBuilder = new StringBuilder().append("node: { title: \"").append(this.getTokenID(token)).append("\" label: \"").append(string).append("\" color: ");
        if (string2 != null) {
            stringBuilder.append(string2).append(" }");
        } else {
            stringBuilder.append(" }");
        }
        stringBuilder.append('\n');
        this.dumpedTokens.add(token);
        if (token.getPredecessor() != null) {
            stringBuilder.append("edge: { sourcename: \"").append(this.getTokenID(token)).append("\" targetname: \"").append(this.getTokenID(token.getPredecessor())).append("\" }").append('\n').append(this.dumpTokenGDL(token.getPredecessor()));
        }
        if (this.loserManager != null && (list = this.loserManager.getAlternatePredecessors(token)) != null) {
            for (Token token2 : list) {
                stringBuilder.append("edge: { sourcename: \"").append(this.getTokenID(token)).append("\" targetname: \"").append(this.getTokenID(token2)).append("\" }").append('\n').append(this.dumpTokenGDL(token2));
            }
        }
        return stringBuilder.toString();
    }

    private String getColor(SearchState searchState) {
        String string = "lightred";
        if (searchState.isFinal()) {
            string = "magenta";
        } else if (searchState instanceof UnitSearchState) {
            string = "green";
        } else if (searchState instanceof WordSearchState) {
            string = "lightblue";
        } else if (searchState instanceof HMMSearchState) {
            string = "orange";
        }
        return string;
    }

    private Integer getTokenID(Token token) {
        Integer n = this.tokenIDMap.get(token);
        if (n == null) {
            n = this.ID++;
            this.tokenIDMap.put(token, n);
        }
        return n;
    }
}

