/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.speakerid;

import edu.cmu.sphinx.speakerid.Segment;
import edu.cmu.sphinx.speakerid.SpeakerIdentification;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;

public class SpeakerCluster {
    private TreeSet<Segment> segmentSet = new TreeSet();
    private double bicValue;
    protected Array2DRowRealMatrix featureMatrix;

    public double getBicValue() {
        return this.bicValue;
    }

    public void setBicValue(double d) {
        this.bicValue = d;
    }

    public Array2DRowRealMatrix getFeatureMatrix() {
        return this.featureMatrix;
    }

    public SpeakerCluster() {
    }

    public SpeakerCluster(Segment segment, Array2DRowRealMatrix array2DRowRealMatrix, double d) {
        this.featureMatrix = new Array2DRowRealMatrix(array2DRowRealMatrix.getData());
        this.bicValue = d;
        this.addSegment(segment);
    }

    public SpeakerCluster(SpeakerCluster speakerCluster) {
        this.featureMatrix = new Array2DRowRealMatrix(speakerCluster.getFeatureMatrix().getData());
        Iterator<Segment> iterator = speakerCluster.segmentSet.iterator();
        while (iterator.hasNext()) {
            this.addSegment(iterator.next());
        }
    }

    public TreeSet<Segment> getSegments() {
        return this.segmentSet;
    }

    public ArrayList<Segment> getArrayOfSegments() {
        Iterator<Segment> iterator = this.segmentSet.iterator();
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public Boolean addSegment(Segment segment) {
        return this.segmentSet.add(segment);
    }

    public Boolean removeSegment(Segment segment) {
        return this.segmentSet.remove(segment);
    }

    public ArrayList<Segment> getSpeakerIntervals() {
        Iterator<Segment> iterator = this.segmentSet.iterator();
        Segment segment = new Segment(0, 0);
        Segment segment2 = iterator.next();
        int n = segment2.getStartTime();
        int n2 = segment2.getLength();
        int n3 = 0;
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        arrayList.add(segment2);
        while (iterator.hasNext()) {
            segment = iterator.next();
            n = arrayList.get(n3).getStartTime();
            if (n + (n2 = arrayList.get(n3).getLength()) == segment.getStartTime()) {
                arrayList.set(n3, new Segment(n, n2 + segment.getLength()));
            } else {
                ++n3;
                arrayList.add(segment);
            }
            segment2 = segment;
        }
        return arrayList;
    }

    public void mergeWith(SpeakerCluster speakerCluster) throws NullPointerException {
        if (speakerCluster == null) {
            throw new NullPointerException();
        }
        Iterator<Segment> iterator = speakerCluster.segmentSet.iterator();
        while (iterator.hasNext()) {
            if (this.addSegment(iterator.next()).booleanValue()) continue;
            System.out.println("Something doesn't work in mergeWith method, Cluster class");
        }
        int n = this.featureMatrix.getRowDimension() + speakerCluster.getFeatureMatrix().getRowDimension();
        int n2 = this.featureMatrix.getColumnDimension();
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n, n2);
        array2DRowRealMatrix.setSubMatrix(this.featureMatrix.getData(), 0, 0);
        array2DRowRealMatrix.setSubMatrix(speakerCluster.getFeatureMatrix().getData(), this.featureMatrix.getRowDimension(), 0);
        this.bicValue = SpeakerIdentification.getBICValue(array2DRowRealMatrix);
        this.featureMatrix = new Array2DRowRealMatrix(array2DRowRealMatrix.getData());
    }
}

