/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.speakerid;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.speakerid.Segment;
import edu.cmu.sphinx.speakerid.SpeakerCluster;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.Covariance;

public class SpeakerIdentification {
    public final String FRONTEND_NAME = "plpFrontEnd";
    private FrontEnd frontEnd;
    private StreamDataSource audioSource;
    private ConfigurationManager cm;

    public SpeakerIdentification() {
        URL uRL = this.getClass().getResource("frontend.config.xml");
        this.cm = new ConfigurationManager(uRL);
        this.audioSource = (StreamDataSource)this.cm.lookup("streamDataSource");
        this.frontEnd = (FrontEnd)this.cm.lookup("plpFrontEnd");
    }

    private ArrayList<float[]> getFeatures() {
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        try {
            int n = -1;
            Data data = this.frontEnd.getData();
            while (!(data instanceof DataEndSignal)) {
                Object[] objectArray;
                if (data instanceof DoubleData) {
                    objectArray = ((DoubleData)data).getValues();
                    if (n < 0) {
                        n = objectArray.length;
                    }
                    float[] fArray = new float[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        fArray[i] = (float)objectArray[i];
                    }
                    arrayList.add(fArray);
                } else if (data instanceof FloatData) {
                    objectArray = ((FloatData)data).getValues();
                    if (n < 0) {
                        n = objectArray.length;
                    }
                    arrayList.add((float[])objectArray);
                }
                data = this.frontEnd.getData();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    double getLikelihoodRatio(double d, int n, Array2DRowRealMatrix array2DRowRealMatrix) {
        int n2 = 13;
        double d2 = 0.5 * ((double)n2 + 0.5 * (double)n2 * (double)(n2 + 1)) * Math.log(array2DRowRealMatrix.getRowDimension()) * 2.0;
        int n3 = array2DRowRealMatrix.getRowDimension();
        int n4 = array2DRowRealMatrix.getColumnDimension();
        Array2DRowRealMatrix array2DRowRealMatrix2 = (Array2DRowRealMatrix)array2DRowRealMatrix.getSubMatrix(0, n - 1, 0, n4 - 1);
        Array2DRowRealMatrix array2DRowRealMatrix3 = (Array2DRowRealMatrix)array2DRowRealMatrix.getSubMatrix(n, n3 - 1, 0, n4 - 1);
        double d3 = SpeakerIdentification.getBICValue(array2DRowRealMatrix2);
        double d4 = SpeakerIdentification.getBICValue(array2DRowRealMatrix3);
        return d - d3 - d4 - d2;
    }

    private int getPoint(int n, int n2, int n3, Array2DRowRealMatrix array2DRowRealMatrix) {
        double d = Double.NEGATIVE_INFINITY;
        int n4 = array2DRowRealMatrix.getColumnDimension();
        int n5 = 0;
        Array2DRowRealMatrix array2DRowRealMatrix2 = (Array2DRowRealMatrix)array2DRowRealMatrix.getSubMatrix(n, n + n2 - 1, 0, n4 - 1);
        double d2 = SpeakerIdentification.getBICValue(array2DRowRealMatrix2);
        for (int i = 14; i < n2 - 13; i += n3) {
            double d3 = this.getLikelihoodRatio(d2, i, array2DRowRealMatrix2);
            if (!(d3 > d)) continue;
            d = d3;
            n5 = i;
        }
        if (d < 0.0) {
            n5 = Integer.MIN_VALUE;
        }
        return n5 + n;
    }

    private LinkedList<Integer> getAllChangingPoints(Array2DRowRealMatrix array2DRowRealMatrix) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(0);
        int n = array2DRowRealMatrix.getRowDimension();
        int n2 = 500;
        int n3 = 0;
        int n4 = n2;
        while (n4 < n) {
            int n5 = this.getPoint(n3, n4 - n3 + 1, n2 / 10, array2DRowRealMatrix);
            if (n5 > 0) {
                n3 = n5;
                n4 = n3 + n2;
                linkedList.add(n5);
                continue;
            }
            n4 += n2;
        }
        linkedList.add(n);
        return linkedList;
    }

    public static double getBICValue(Array2DRowRealMatrix array2DRowRealMatrix) {
        double d = 0.0;
        EigenDecomposition eigenDecomposition = new EigenDecomposition(new Covariance((RealMatrix)array2DRowRealMatrix).getCovarianceMatrix());
        double[] dArray = eigenDecomposition.getRealEigenvalues();
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.log(dArray[i]);
        }
        return d * (double)(array2DRowRealMatrix.getRowDimension() / 2);
    }

    public ArrayList<SpeakerCluster> cluster(InputStream inputStream) {
        this.audioSource.setInputStream(inputStream);
        ArrayList<float[]> arrayList = this.getFeatures();
        return this.cluster(arrayList);
    }

    public ArrayList<SpeakerCluster> cluster(ArrayList<float[]> arrayList) {
        Array2DRowRealMatrix array2DRowRealMatrix;
        ArrayList<SpeakerCluster> arrayList2 = new ArrayList<SpeakerCluster>();
        Array2DRowRealMatrix array2DRowRealMatrix2 = this.ArrayToRealMatrix(arrayList, arrayList.size());
        LinkedList<Integer> linkedList = this.getAllChangingPoints(array2DRowRealMatrix2);
        Iterator iterator = linkedList.iterator();
        int n = (Integer)iterator.next();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            Segment segment = new Segment(n * 10, (n2 - n) * 10);
            array2DRowRealMatrix = (Array2DRowRealMatrix)array2DRowRealMatrix2.getSubMatrix(n, n2 - 1, 0, 12);
            arrayList2.add(new SpeakerCluster(segment, array2DRowRealMatrix, SpeakerIdentification.getBICValue(array2DRowRealMatrix)));
            n = n2;
        }
        int n3 = arrayList2.size();
        array2DRowRealMatrix = new Array2DRowRealMatrix(n3, n3);
        array2DRowRealMatrix = this.updateDistances(arrayList2);
        while (true) {
            int n4;
            int n5;
            double d = 0.0;
            int n6 = -1;
            int n7 = -1;
            for (n5 = 0; n5 < n3; ++n5) {
                for (n4 = 0; n4 < n3; ++n4) {
                    if (n5 == n4) continue;
                    d += array2DRowRealMatrix.getEntry(n5, n4);
                }
            }
            d /= (double)(n3 * (n3 - 1) * 4);
            for (n5 = 0; n5 < n3; ++n5) {
                for (n4 = 0; n4 < n3; ++n4) {
                    if (!(array2DRowRealMatrix.getEntry(n5, n4) < d) || n5 == n4) continue;
                    d = array2DRowRealMatrix.getEntry(n5, n4);
                    n6 = n5;
                    n7 = n4;
                }
            }
            if (n6 == -1) break;
            arrayList2.get(n6).mergeWith(arrayList2.get(n7));
            this.updateDistances(arrayList2, n6, n7, array2DRowRealMatrix);
            arrayList2.remove(n7);
            --n3;
        }
        return arrayList2;
    }

    void updateDistances(ArrayList<SpeakerCluster> arrayList, int n, int n2, Array2DRowRealMatrix array2DRowRealMatrix) {
        int n3;
        int n4;
        int n5 = arrayList.size();
        for (n4 = 0; n4 < n5; ++n4) {
            array2DRowRealMatrix.setEntry(n4, n, this.computeDistance(arrayList.get(n4), arrayList.get(n)));
            array2DRowRealMatrix.setEntry(n, n4, array2DRowRealMatrix.getEntry(n4, n));
        }
        for (n4 = n2; n4 < n5 - 1; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                array2DRowRealMatrix.setEntry(n4, n3, array2DRowRealMatrix.getEntry(n4 + 1, n3));
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = n2; n3 < n5 - 1; ++n3) {
                array2DRowRealMatrix.setEntry(n4, n3, array2DRowRealMatrix.getEntry(n4, n3 + 1));
            }
        }
    }

    Array2DRowRealMatrix updateDistances(ArrayList<SpeakerCluster> arrayList) {
        int n = arrayList.size();
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                array2DRowRealMatrix.setEntry(i, j, this.computeDistance(arrayList.get(i), arrayList.get(j)));
                array2DRowRealMatrix.setEntry(j, i, array2DRowRealMatrix.getEntry(i, j));
            }
        }
        return array2DRowRealMatrix;
    }

    double computeDistance(SpeakerCluster speakerCluster, SpeakerCluster speakerCluster2) {
        int n = speakerCluster.getFeatureMatrix().getRowDimension() + speakerCluster2.getFeatureMatrix().getRowDimension();
        int n2 = speakerCluster.getFeatureMatrix().getColumnDimension();
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n, n2);
        array2DRowRealMatrix.setSubMatrix(speakerCluster.getFeatureMatrix().getData(), 0, 0);
        array2DRowRealMatrix.setSubMatrix(speakerCluster2.getFeatureMatrix().getData(), speakerCluster.getFeatureMatrix().getRowDimension(), 0);
        double d = SpeakerIdentification.getBICValue(array2DRowRealMatrix);
        double d2 = 13.0;
        double d3 = 0.5 * (d2 + 0.5 * d2 * (d2 + 1.0)) * Math.log(array2DRowRealMatrix.getRowDimension()) * 2.0;
        return d - speakerCluster.getBicValue() - speakerCluster2.getBicValue() - d3;
    }

    Array2DRowRealMatrix ArrayToRealMatrix(ArrayList<float[]> arrayList, int n) {
        int n2 = arrayList.get(1).length;
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n, n2);
        int n3 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            double[] dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = arrayList.get(n3)[i];
            }
            array2DRowRealMatrix.setRow(n3, dArray);
        }
        return array2DRowRealMatrix;
    }

    void printMatrix(Array2DRowRealMatrix array2DRowRealMatrix) {
        for (int i = 0; i < array2DRowRealMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < array2DRowRealMatrix.getColumnDimension(); ++j) {
                System.out.print(array2DRowRealMatrix.getEntry(i, j) + " ");
            }
            System.out.println();
        }
    }
}

