/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.speakerid;

import edu.cmu.sphinx.speakerid.Segment;
import edu.cmu.sphinx.speakerid.SpeakerCluster;
import edu.cmu.sphinx.speakerid.SpeakerIdentification;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

public class Tester {
    public static ArrayList<float[]> generateDistinctSpeakers(int n, int n2, int n3) {
        Random random = new Random();
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        float[] fArray = new float[n];
        for (int i = 0; i < n3; ++i) {
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                fArray[n4] = (float)(i + 1) / 10.0f + (float)random.nextInt(5000) / 50000.0f;
            }
            fArray[0] = 3.0f + (float)(i + 1) / 10.0f;
            for (n4 = 0; n4 < n2; ++n4) {
                float[] fArray2 = new float[n];
                for (int j = 0; j < n; ++j) {
                    fArray2[j] = fArray[j] + (float)random.nextInt(5000) / 50000.0f;
                }
                arrayList.add(fArray2);
            }
        }
        return arrayList;
    }

    public static String time(int n) {
        return n / 60000 + ":" + Math.round((double)(n % 60000) / 1000.0);
    }

    public static void printIntervals(ArrayList<SpeakerCluster> arrayList) {
        System.out.println("Detected " + arrayList.size() + " Speakers :");
        int n = 0;
        for (SpeakerCluster speakerCluster : arrayList) {
            System.out.print("Speaker " + ++n + ": ");
            ArrayList<Segment> arrayList2 = speakerCluster.getSpeakerIntervals();
            for (Segment segment : arrayList2) {
                System.out.print("[" + Tester.time(segment.getStartTime()) + " " + Tester.time(segment.getLength()) + "]");
            }
            System.out.println();
        }
    }

    public static void printSpeakerIntervals(ArrayList<SpeakerCluster> arrayList, String string) throws IOException {
        String string2 = string.substring(0, string.indexOf(46)) + ".seg";
        FileWriter fileWriter = new FileWriter(string2);
        int n = 0;
        for (SpeakerCluster speakerCluster : arrayList) {
            ++n;
            ArrayList<Segment> arrayList2 = speakerCluster.getSpeakerIntervals();
            for (Segment segment : arrayList2) {
                fileWriter.write(string + " " + 1 + " " + segment.getStartTime() / 10 + " " + segment.getLength() / 10 + "U U U Speaker" + n + "\n");
            }
        }
        fileWriter.close();
    }

    public static void testDistinctSpeakerIdentification(int n, int n2, int n3) {
        ArrayList<float[]> arrayList = Tester.generateDistinctSpeakers(n, n2, n3);
        Tester.printIntervals(new SpeakerIdentification().cluster(arrayList));
    }

    public static void testRepeatedSpeakerIdentification(int n, int n2, int n3, int n4) {
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        ArrayList<float[]> arrayList2 = Tester.generateDistinctSpeakers(n, n2, n3);
        for (int i = 0; i < n4; ++i) {
            arrayList.addAll(arrayList2);
        }
        Tester.printIntervals(new SpeakerIdentification().cluster(arrayList));
    }

    public static void testSpeakerIdentification(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        ArrayList<SpeakerCluster> arrayList = new SpeakerIdentification().cluster(fileInputStream);
        Tester.printIntervals(arrayList);
        Tester.printSpeakerIntervals(arrayList, string);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-i")) continue;
            string = stringArray[++i];
        }
        Tester.testSpeakerIdentification(string);
    }
}

