/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.aligner;

import edu.cmu.sphinx.api.SpeechAligner;
import edu.cmu.sphinx.result.WordResult;
import edu.cmu.sphinx.util.TimeFrame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Aligner {
    private static int MIN_FILLER_LENGTH = 200;

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[2]);
        SpeechAligner speechAligner = new SpeechAligner(stringArray[0], stringArray[1], null);
        Aligner.splitStream(file, speechAligner.align(file.toURI().toURL(), stringArray[3]));
    }

    private static void splitStream(File file, List<WordResult> list) throws UnsupportedAudioFileException, IOException {
        System.err.println(list.size());
        ArrayList arrayList = new ArrayList();
        ArrayList<WordResult> arrayList2 = null;
        int n = 0;
        for (WordResult object : list) {
            if (object.isFiller()) {
                if ((n = (int)((long)n + object.getTimeFrame().length())) <= MIN_FILLER_LENGTH) continue;
                if (arrayList2 != null) {
                    arrayList.add(arrayList2);
                }
                arrayList2 = null;
                continue;
            }
            n = 0;
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<WordResult>();
            }
            arrayList2.add(object);
        }
        if (null != arrayList2) {
            arrayList.add(arrayList2);
        }
        int n2 = 0;
        for (List list2 : arrayList) {
            Object object;
            Object object22;
            long l = Long.MAX_VALUE;
            long l2 = Long.MIN_VALUE;
            for (Object object22 : list2) {
                object = ((WordResult)object22).getTimeFrame();
                l = Math.min(l, ((TimeFrame)object).getStart());
                l2 = Math.max(l2, ((TimeFrame)object).getEnd());
                System.out.print(((WordResult)object22).getPronunciation().getWord());
                System.out.print(' ');
            }
            String[] stringArray = file.getName().split("\\.wav$");
            object22 = String.format("%03d0", n2);
            object = String.format("%s-%s.wav", stringArray[0], object22);
            System.out.println("(" + (String)object22 + ")");
            ++n2;
            Aligner.dumpStreamChunk(file, (String)object, l - (long)MIN_FILLER_LENGTH, l2 - l + (long)MIN_FILLER_LENGTH);
        }
    }

    private static void dumpStreamChunk(File file, String string, long l, long l2) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(file);
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
        AudioFormat audioFormat = audioFileFormat.getFormat();
        int n = Math.round((float)audioFormat.getFrameSize() * audioFormat.getFrameRate() / 1000.0f);
        audioInputStream.skip(l * (long)n);
        AudioInputStream audioInputStream2 = new AudioInputStream(audioInputStream, audioFormat, l2 * (long)n);
        AudioSystem.write(audioInputStream2, audioFileFormat.getType(), new File(string));
        audioInputStream.close();
        audioInputStream2.close();
    }
}

