/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.tools.audio.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AudioData {
    protected AudioFormat format;
    protected short[] shorts;
    protected final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    protected int selectionStart = -1;
    protected int selectionEnd = -1;

    public AudioData() {
        this.format = new AudioFormat(8000.0f, 16, 1, true, false);
        this.shorts = new short[0];
    }

    public AudioData(short[] sArray, float f) {
        this.shorts = sArray;
        this.format = new AudioFormat(f, 16, 1, true, false);
    }

    public AudioData(AudioInputStream audioInputStream) throws IOException {
        this.shorts = Utils.toSignedPCM(audioInputStream);
        this.format = new AudioFormat(audioInputStream.getFormat().getSampleRate(), 16, 1, true, false);
    }

    public short[] getAudioData() {
        return this.shorts;
    }

    public void setAudioData(short[] sArray) {
        this.shorts = sArray;
        this.fireStateChanged();
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    protected void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

