/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.tools.audio.AudioData;
import edu.cmu.sphinx.tools.audio.Utils;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;

public class AudioDataInputStream
extends InputStream {
    AudioFormat format;
    int currentIndex;
    int markIndex;
    final short[] shorts;
    final byte[] bytes;

    public AudioDataInputStream(AudioData audioData) {
        this.shorts = audioData.getAudioData();
        this.bytes = new byte[2 * this.shorts.length];
        byte[] byArray = new byte[2];
        for (int i = 0; i < this.shorts.length; ++i) {
            Utils.toBytes(this.shorts[i], byArray, true);
            this.bytes[i * 2 + 1] = byArray[0];
            this.bytes[i * 2] = byArray[1];
        }
    }

    @Override
    public int read() throws IOException {
        if (this.currentIndex >= this.bytes.length) {
            return -1;
        }
        return this.bytes[this.currentIndex++];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = 0;
        for (int i = 0; i < byArray.length && this.currentIndex < this.bytes.length; ++i) {
            byArray[i] = this.bytes[this.currentIndex++];
            ++n;
        }
        return n == 0 ? -1 : n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        for (int i = 0; i < n2 && i + n < byArray.length && this.currentIndex < this.bytes.length; ++i) {
            byArray[i + n] = this.bytes[this.currentIndex++];
            ++n3;
        }
        return n3 == 0 ? -1 : n3;
    }

    public long skip(int n) throws IOException {
        int n2 = n;
        if (this.currentIndex + n > this.bytes.length) {
            n2 = this.bytes.length - this.currentIndex;
        }
        this.currentIndex += n2;
        return n2;
    }

    @Override
    public int available() throws IOException {
        return this.bytes.length - this.currentIndex;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public void mark(int n) {
        this.markIndex = this.currentIndex;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void reset() throws IOException {
        this.currentIndex = this.markIndex;
    }
}

