/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.tools.audio.AudioData;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AudioPanel
extends JPanel
implements MouseMotionListener,
MouseListener {
    private final AudioData audio;
    private float[] labelTimes;
    private String[] labels;
    private float xScale;
    private final float yScale;
    private final float originalXScale;
    private int xDragStart;
    private int xDragEnd;
    protected int selectionStart = -1;
    protected int selectionEnd = -1;

    public AudioPanel(AudioData audioData, float f, float f2) {
        this.audio = audioData;
        this.labelTimes = new float[0];
        this.labels = new String[0];
        this.xScale = f;
        this.yScale = f2;
        this.originalXScale = this.xScale;
        int n = (int)((float)this.audio.getAudioData().length * this.xScale);
        int n2 = (int)(65536.0f * this.yScale);
        this.setPreferredSize(new Dimension(n, n2));
        this.setBackground(Color.white);
        this.audio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = (int)((float)AudioPanel.this.audio.getAudioData().length * AudioPanel.this.xScale);
                int n2 = (int)(65536.0f * AudioPanel.this.yScale);
                AudioPanel.access$302(AudioPanel.this, new float[0]);
                AudioPanel.access$402(AudioPanel.this, new String[0]);
                AudioPanel.this.setSelectionStart(-1);
                AudioPanel.this.setSelectionEnd(-1);
                AudioPanel.this.setPreferredSize(new Dimension(n, n2));
                Dimension dimension = AudioPanel.this.getSize();
                AudioPanel.this.revalidate();
                AudioPanel.this.repaint(0L, 0, 0, dimension.width, dimension.height);
            }
        });
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.setFocusable(true);
        this.requestFocus();
    }

    public void setLabels(float[] fArray, String[] stringArray) {
        this.labelTimes = fArray;
        this.labels = stringArray;
        this.repaint();
    }

    protected void zoomSet(float f) {
        this.xScale = this.originalXScale * f;
        int n = (int)((float)this.audio.getAudioData().length * this.xScale);
        int n2 = (int)(65536.0f * this.yScale);
        this.setPreferredSize(new Dimension(n, n2));
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        int n4 = dimension.height / 2;
        short[] sArray = this.audio.getAudioData();
        JViewport jViewport = this.getViewport();
        if (jViewport != null) {
            Rectangle rectangle = jViewport.getViewRect();
            n3 = (int)rectangle.getX();
            n2 = (int)rectangle.getWidth();
        } else {
            n3 = 0;
            n2 = (int)((float)sArray.length * this.xScale);
        }
        graphics.setColor(Color.WHITE);
        graphics.fillRect(n3, 0, n2, dimension.height - 1);
        int n5 = Math.max(0, this.getSelectionStart());
        int n6 = (int)((float)n5 * this.xScale);
        n5 = this.getSelectionEnd();
        if (n5 == -1) {
            n5 = sArray.length - 1;
        }
        int n7 = (int)((float)n5 * this.xScale);
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.fillRect(n6, 0, n7 - n6, dimension.height - 1);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = n3;
            n5 = (int)((float)n3 / this.xScale);
            if (n5 >= sArray.length) break;
            nArray2[n] = n4 - (int)((float)sArray[n5] * this.yScale);
            ++n3;
        }
        graphics.setColor(Color.RED);
        graphics.drawPolyline(nArray, nArray2, n2);
        for (n = 0; n < this.labelTimes.length; ++n) {
            n3 = (int)(this.xScale * this.labelTimes[n] * this.audio.getAudioFormat().getSampleRate());
            graphics.drawLine(n3, 0, n3, dimension.height - 1);
            graphics.drawString(this.labels[n], n3 + 5, dimension.height - 5);
        }
    }

    private JViewport getViewport() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return null;
            }
            return jViewport;
        }
        return null;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public void setSelectionStart(int n) {
        this.selectionStart = n;
        if (this.selectionEnd != -1 && this.selectionEnd < this.selectionStart) {
            this.selectionEnd = this.selectionStart;
        }
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public void setSelectionEnd(int n) {
        this.selectionEnd = n;
        if (this.selectionEnd != -1 && this.selectionStart > this.selectionEnd) {
            this.selectionStart = this.selectionEnd;
        }
    }

    public void crop() {
        short[] sArray = this.audio.getAudioData();
        int n = Math.max(0, this.getSelectionStart());
        int n2 = this.getSelectionEnd();
        if (n2 == -1) {
            n2 = sArray.length;
        }
        this.audio.setAudioData(Arrays.copyOfRange(sArray, n, n2));
        this.setSelectionStart(-1);
        this.setSelectionEnd(-1);
    }

    public void selectAll() {
        this.setSelectionStart(-1);
        this.setSelectionEnd(-1);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.xDragStart = Math.max(0, mouseEvent.getX());
        this.setSelectionStart((int)((float)this.xDragStart / this.xScale));
        this.setSelectionEnd((int)((float)this.xDragStart / this.xScale));
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.xDragEnd = mouseEvent.getX();
        if (this.xDragEnd < (int)((float)this.getSelectionStart() * this.xScale)) {
            this.setSelectionStart((int)((float)this.xDragEnd / this.xScale));
        } else {
            this.setSelectionEnd((int)((float)this.xDragEnd / this.xScale));
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    static /* synthetic */ float[] access$302(AudioPanel audioPanel, float[] fArray) {
        audioPanel.labelTimes = fArray;
        return fArray;
    }

    static /* synthetic */ String[] access$402(AudioPanel audioPanel, String[] stringArray) {
        audioPanel.labels = stringArray;
        return stringArray;
    }
}

