/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.tools.audio.AudioData;
import edu.cmu.sphinx.tools.audio.Utils;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class AudioPlayer
extends Thread {
    private final AudioData audio;
    private SourceDataLine line;
    private int selectionStart;
    private int selectionEnd;

    public AudioPlayer(AudioData audioData) {
        this.audio = audioData;
        this.selectionStart = 0;
        this.selectionEnd = audioData.getAudioData().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(int n, int n2) {
        AudioData audioData = this.audio;
        synchronized (audioData) {
            this.selectionStart = n;
            this.selectionEnd = n2;
            this.audio.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                AudioData audioData = this.audio;
                synchronized (audioData) {
                    this.audio.wait();
                    AudioFormat audioFormat = this.audio.getAudioFormat();
                    short[] sArray = this.audio.getAudioData();
                    int n = Math.max(0, this.selectionStart);
                    int n2 = this.selectionEnd;
                    if (n2 == -1) {
                        n2 = sArray.length;
                    }
                    DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                    this.line = (SourceDataLine)AudioSystem.getLine(info);
                    this.line.open(audioFormat);
                    this.line.start();
                    byte[] byArray = new byte[2];
                    for (int i = n; i < n2 && i < sArray.length; ++i) {
                        Utils.toBytes(sArray[i], byArray, false);
                        this.line.write(byArray, 0, byArray.length);
                    }
                    this.line.drain();
                    this.line.close();
                    this.line = null;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

