/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.util.Microphone;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.tools.audio.AudioData;
import edu.cmu.sphinx.tools.audio.AudioPanel;
import edu.cmu.sphinx.tools.audio.AudioPlayer;
import edu.cmu.sphinx.tools.audio.CepstrumPanel;
import edu.cmu.sphinx.tools.audio.Downsampler;
import edu.cmu.sphinx.tools.audio.SpectrogramPanel;
import edu.cmu.sphinx.tools.audio.Utils;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class AudioTool {
    static final String CONTEXT = "AudioTool";
    static final String PREFS_CONTEXT = "/edu/cmu/sphinx/tools/audio/AudioTool";
    static final String FILENAME_PREFERENCE = "filename";
    static final String MICROPHONE = "microphone";
    static final String FRONT_END = "frontEnd";
    static final String CESPTRUM_FRONT_END = "cepstrumFrontEnd";
    static final String DATA_SOURCE = "streamDataSource";
    static final String CEPSTRUM_DATA_SOURCE = "cstreamDataSource";
    static final String WINDOWER = "windower";
    static AudioData audio;
    static JFrame jframe;
    static AudioPanel audioPanel;
    static SpectrogramPanel spectrogramPanel;
    static CepstrumPanel cepstrumPanel;
    static JFileChooser fileChooser;
    static String filename;
    static File file;
    static AudioPlayer player;
    static Microphone recorder;
    static boolean recording;
    static Preferences prefs;
    static float zoom;
    private static JMenuItem saveMenuItem;
    private static JButton playButton;
    private static JButton recordButton;
    private static JButton zoomInButton;
    private static JButton zoomOutButton;
    private static JButton zoomResetButton;
    private static ActionListener recordListener;

    private static void dumpLineInfo(String string, Line.Info[] infoArray) {
        int n = 0;
        if (infoArray != null) {
            for (Line.Info info : infoArray) {
                if (info instanceof DataLine.Info) {
                    AudioFormat[] audioFormatArray;
                    for (AudioFormat audioFormat : audioFormatArray = ((DataLine.Info)info).getFormats()) {
                        System.out.println(string + audioFormat);
                    }
                    ++n;
                    continue;
                }
                if (!(info instanceof Port.Info)) continue;
                System.out.println(string + info);
                ++n;
            }
        }
        if (n == 0) {
            System.out.println(string + "none");
        }
    }

    private static void dumpMixers() {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            System.out.println("Mixer[" + i + "]: \"" + infoArray[i].getName() + '\"');
            System.out.println("    Description: " + infoArray[i].getDescription());
            System.out.println("    SourceLineInfo (e.g., speakers):");
            AudioTool.dumpLineInfo("        ", mixer.getSourceLineInfo());
            System.out.println("    TargetLineInfo (e.g., microphones):");
            AudioTool.dumpLineInfo("        ", mixer.getTargetLineInfo());
        }
    }

    public static void getFilename(String string, int n) {
        fileChooser.setDialogTitle(string);
        fileChooser.setCurrentDirectory(file);
        fileChooser.setDialogType(n);
        int n2 = n == 0 ? fileChooser.showOpenDialog(jframe) : fileChooser.showSaveDialog(jframe);
        if (n2 == 0) {
            file = fileChooser.getSelectedFile();
            filename = file.getAbsolutePath();
            prefs.put(FILENAME_PREFERENCE, filename);
        }
    }

    public static void populateAudio(String string) {
        try {
            AudioData audioData = Utils.readAudioFile(string);
            if (audioData == null) {
                audioData = Utils.readRawFile(string);
            }
            AudioTool.zoomReset();
            audio.setAudioData(audioData.getAudioData());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void getAudioFromFile(String string) throws IOException {
        if (string.endsWith(".align")) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            AudioTool.populateAudio(bufferedReader.readLine());
            int n = Integer.parseInt(bufferedReader.readLine());
            float[] fArray = new float[n];
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                while (stringTokenizer.hasMoreTokens()) {
                    fArray[i] = Float.parseFloat(stringTokenizer.nextToken());
                    stringArray[i] = stringTokenizer.nextToken();
                }
            }
            audioPanel.setLabels(fArray, stringArray);
            bufferedReader.close();
        } else {
            AudioTool.populateAudio(string);
        }
    }

    private static short[] getRecordedAudio(Microphone microphone) {
        short[] sArray = new short[]{};
        int n = 8000;
        while (microphone.hasMoreData()) {
            try {
                Data data = microphone.getData();
                if (!(data instanceof DoubleData)) continue;
                n = ((DoubleData)data).getSampleRate();
                double[] dArray = ((DoubleData)data).getValues();
                short[] sArray2 = Arrays.copyOf(sArray, sArray.length + dArray.length);
                for (int i = 0; i < dArray.length; ++i) {
                    sArray2[sArray.length + i] = (short)dArray[i];
                }
                sArray = sArray2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (n > 8000) {
            System.out.println("Downsampling from " + n + " to 8000.");
            sArray = Downsampler.downsample(sArray, n / 1000, 16);
        }
        return sArray;
    }

    private static void zoomPanels() {
        if (audioPanel != null) {
            audioPanel.zoomSet(zoom);
        }
        if (spectrogramPanel != null) {
            spectrogramPanel.zoomSet(zoom);
        }
        if (cepstrumPanel != null) {
            cepstrumPanel.zoomSet(zoom);
        }
    }

    private static void zoomIn() {
        zoom *= 2.0f;
        AudioTool.zoomPanels();
    }

    private static void zoomOut() {
        zoom /= 2.0f;
        AudioTool.zoomPanels();
    }

    private static void zoomReset() {
        zoom = 1.0f;
        AudioTool.zoomPanels();
    }

    private static void createMenuBar(JFrame jFrame) {
        JMenuBar jMenuBar = new JMenuBar();
        jFrame.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Open...");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control O"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AudioTool.getFilename("Open...", 0);
                if (filename == null || filename.isEmpty()) {
                    return;
                }
                try {
                    AudioTool.getAudioFromFile(filename);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jMenu.add(jMenuItem);
        saveMenuItem = new JMenuItem("Save");
        saveMenuItem.setAccelerator(KeyStroke.getKeyStroke("control S"));
        saveMenuItem.setEnabled(false);
        saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (filename != null && !filename.isEmpty()) {
                    try {
                        Utils.writeRawFile(audio, filename);
                        saveMenuItem.setEnabled(false);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        jMenu.add(saveMenuItem);
        jMenuItem = new JMenuItem("Save As...");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control V"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AudioTool.getFilename("Save As...", 1);
                if (filename == null || filename.isEmpty()) {
                    return;
                }
                try {
                    Utils.writeRawFile(audio, filename);
                    saveMenuItem.setEnabled(false);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Quit");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control Q"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Edit");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Select All");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control A"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                audioPanel.selectAll();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Crop");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control X"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                audioPanel.crop();
            }
        });
        jMenu.add(jMenuItem);
        jMenu = new JMenu("View");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Zoom In");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke('>'));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AudioTool.zoomIn();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Zoom Out");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke('<'));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AudioTool.zoomOut();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Original Size");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke('!'));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AudioTool.zoomReset();
            }
        });
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Audio");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Play");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control P"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                player.play(audioPanel.getSelectionStart(), audioPanel.getSelectionEnd());
            }
        });
        jMenu.add(jMenuItem);
        recordListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!recording) {
                    recording = true;
                    recorder.startRecording();
                    recordButton.setText("Stop");
                    saveMenuItem.setEnabled(true);
                } else {
                    recording = false;
                    recorder.stopRecording();
                    audio.setAudioData(AudioTool.getRecordedAudio(recorder));
                    recordButton.setText("Record");
                    player.play(audioPanel.getSelectionStart(), audioPanel.getSelectionEnd());
                }
            }
        };
        jMenuItem = new JMenuItem("Record Start/Stop");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control R"));
        jMenuItem.addActionListener(recordListener);
        jMenu.add(jMenuItem);
    }

    private static JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        jPanel.setLayout(flowLayout);
        playButton = new JButton("Play");
        playButton.setEnabled(true);
        playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                player.play(audioPanel.getSelectionStart(), audioPanel.getSelectionEnd());
            }
        });
        recordButton = new JButton("Record");
        recordButton.setEnabled(true);
        recordButton.addActionListener(recordListener);
        zoomInButton = new JButton("Zoom In");
        zoomInButton.setEnabled(true);
        zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AudioTool.zoomIn();
            }
        });
        zoomOutButton = new JButton("Zoom Out");
        zoomOutButton.setEnabled(true);
        zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AudioTool.zoomOut();
            }
        });
        zoomResetButton = new JButton("Reset Size");
        zoomResetButton.setEnabled(true);
        zoomResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AudioTool.zoomReset();
            }
        });
        JButton jButton = new JButton("Exit");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jPanel.add(recordButton);
        jPanel.add(playButton);
        jPanel.add(zoomInButton);
        jPanel.add(zoomOutButton);
        jPanel.add(zoomResetButton);
        jPanel.add(jButton);
        return jPanel;
    }

    public static void main(String[] stringArray) {
        prefs = Preferences.userRoot().node(PREFS_CONTEXT);
        filename = prefs.get(FILENAME_PREFERENCE, "untitled.raw");
        file = new File(filename);
        if (stringArray.length == 1 && stringArray[0].equals("-dumpMixers")) {
            AudioTool.dumpMixers();
            System.exit(0);
        }
        try {
            if (stringArray.length > 0) {
                filename = stringArray[0];
            }
            URL uRL = stringArray.length == 2 ? new File(stringArray[1]).toURI().toURL() : AudioTool.class.getResource("spectrogram.config.xml");
            ConfigurationManager configurationManager = new ConfigurationManager(uRL);
            recorder = (Microphone)configurationManager.lookup(MICROPHONE);
            recorder.initialize();
            audio = new AudioData();
            FrontEnd frontEnd = (FrontEnd)configurationManager.lookup(FRONT_END);
            StreamDataSource streamDataSource = (StreamDataSource)configurationManager.lookup(DATA_SOURCE);
            FrontEnd frontEnd2 = (FrontEnd)configurationManager.lookup(CESPTRUM_FRONT_END);
            StreamDataSource streamDataSource2 = (StreamDataSource)configurationManager.lookup(CEPSTRUM_DATA_SOURCE);
            PropertySheet propertySheet = configurationManager.getPropertySheet(WINDOWER);
            float f = propertySheet.getFloat("windowShiftInMs");
            JFrame jFrame = new JFrame(CONTEXT);
            fileChooser = new JFileChooser();
            AudioTool.createMenuBar(jFrame);
            float f2 = f * audio.getAudioFormat().getSampleRate() / 1000.0f;
            audioPanel = new AudioPanel(audio, 1.0f / f2, 0.004f);
            spectrogramPanel = new SpectrogramPanel(frontEnd, streamDataSource, audio);
            cepstrumPanel = new CepstrumPanel(frontEnd2, streamDataSource2, audio);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            jPanel.add(audioPanel);
            audioPanel.setAlignmentX(0.0f);
            jPanel.add(spectrogramPanel);
            spectrogramPanel.setAlignmentX(0.0f);
            jPanel.add(cepstrumPanel);
            cepstrumPanel.setAlignmentX(0.0f);
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)AudioTool.createButtonPanel(), "North");
            jPanel2.add(jScrollPane);
            player = new AudioPlayer(audio);
            player.start();
            AudioTool.getAudioFromFile(filename);
            jFrame.setDefaultCloseOperation(3);
            jFrame.setContentPane(jPanel2);
            jFrame.pack();
            jFrame.setSize(640, 400);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        zoom = 1.0f;
    }
}

