/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.tools.audio.AudioData;
import edu.cmu.sphinx.tools.audio.AudioDataInputStream;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ReplicateScaleFilter;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpectrogramPanel
extends JPanel {
    protected BufferedImage spectrogram;
    protected Image scaledSpectrogram;
    protected float zoom = 1.0f;
    protected double offsetFactor;
    protected AudioData audio;
    protected FrontEnd frontEnd;
    protected StreamDataSource dataSource;

    public SpectrogramPanel() {
    }

    public SpectrogramPanel(FrontEnd frontEnd, StreamDataSource streamDataSource, AudioData audioData) {
        this.audio = audioData;
        this.frontEnd = frontEnd;
        this.dataSource = streamDataSource;
        this.audio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SpectrogramPanel.this.computeSpectrogram();
            }
        });
    }

    protected void computeSpectrogram() {
        try {
            Object object;
            int n;
            AudioDataInputStream audioDataInputStream = new AudioDataInputStream(this.audio);
            this.dataSource.setInputStream(audioDataInputStream);
            ArrayList<double[]> arrayList = new ArrayList<double[]>();
            double d = Double.MIN_VALUE;
            Data data = this.frontEnd.getData();
            while (!(data instanceof DataEndSignal)) {
                if (data instanceof DoubleData) {
                    double[] dArray = ((DoubleData)data).getValues();
                    double[] dArray2 = new double[dArray.length];
                    for (n = 0; n < dArray2.length; ++n) {
                        dArray2[n] = Math.max(Math.log(dArray[n]), 0.0);
                        if (!(dArray2[n] > d)) continue;
                        d = dArray2[n];
                    }
                    arrayList.add(dArray2);
                }
                data = this.frontEnd.getData();
            }
            audioDataInputStream.close();
            int n2 = arrayList.size();
            int n3 = ((double[])arrayList.get(0)).length;
            n = n3 - 1;
            Dimension dimension = new Dimension(n2, n3);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
            this.setPreferredSize(dimension);
            this.spectrogram = new BufferedImage(n2, n3, 1);
            double d2 = (255.0 + this.offsetFactor) / d;
            for (int i = 0; i < n2; ++i) {
                object = (double[])arrayList.get(i);
                for (int j = n; j >= 0; --j) {
                    int n4 = (int)(object[j] * d2 - this.offsetFactor);
                    n4 = Math.max(n4, 0);
                    n4 = 255 - n4;
                    int n5 = n4 << 16 & 0xFF0000 | n4 << 8 & 0xFF00 | n4 & 0xFF;
                    this.spectrogram.setRGB(i, n - j, n5);
                }
            }
            ReplicateScaleFilter replicateScaleFilter = new ReplicateScaleFilter((int)(this.zoom * (float)n2), n3);
            this.scaledSpectrogram = this.createImage(new FilteredImageSource(this.spectrogram.getSource(), replicateScaleFilter));
            object = this.getSize();
            this.repaint(0L, 0, 0, object.width - 1, object.height - 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setOffsetFactor(double d) {
        this.offsetFactor = d;
        this.computeSpectrogram();
    }

    protected void zoomSet(float f) {
        this.zoom = f;
        if (this.spectrogram != null) {
            int n = this.spectrogram.getWidth();
            int n2 = this.spectrogram.getHeight();
            ReplicateScaleFilter replicateScaleFilter = new ReplicateScaleFilter((int)(f * (float)n), n2);
            this.scaledSpectrogram = this.createImage(new FilteredImageSource(this.spectrogram.getSource(), replicateScaleFilter));
            Dimension dimension = new Dimension((int)((float)n * f), n2);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
            this.setPreferredSize(dimension);
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
        if (this.spectrogram != null) {
            graphics.drawImage(this.scaledSpectrogram, 0, 0, null);
        }
    }
}

