/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.tools.audio.AudioData;
import edu.cmu.sphinx.tools.audio.RawReader;
import edu.cmu.sphinx.tools.audio.RawWriter;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Utils {
    private static final short[] ulawTable = new short[]{32760, 31608, 30584, 29560, 28536, 27512, 26488, 25464, 24440, 23416, 22392, 21368, 20344, 19320, 18296, 17272, 16248, 15736, 15224, 14712, 14200, 13688, 13176, 12664, 12152, 11640, 11128, 10616, 10104, 9592, 9080, 8568, 8056, 7800, 7544, 7288, 7032, 6776, 6520, 6264, 6008, 5752, 5496, 5240, 4984, 4728, 4472, 4216, 3960, 3832, 3704, 3576, 3448, 3320, 3192, 3064, 2936, 2808, 2680, 2552, 2424, 2296, 2168, 2040, 1912, 1848, 1784, 1720, 1656, 1592, 1528, 1464, 1400, 1336, 1272, 1208, 1144, 1080, 1016, 952, 888, 856, 824, 792, 760, 728, 696, 664, 632, 600, 568, 536, 504, 472, 440, 408, 376, 360, 344, 328, 312, 296, 280, 264, 248, 232, 216, 200, 184, 168, 152, 136, 120, 112, 104, 96, 88, 80, 72, 64, 56, 48, 40, 32, 24, 16, 8, 0, -32760, -31608, -30584, -29560, -28536, -27512, -26488, -25464, -24440, -23416, -22392, -21368, -20344, -19320, -18296, -17272, -16248, -15736, -15224, -14712, -14200, -13688, -13176, -12664, -12152, -11640, -11128, -10616, -10104, -9592, -9080, -8568, -8056, -7800, -7544, -7288, -7032, -6776, -6520, -6264, -6008, -5752, -5496, -5240, -4984, -4728, -4472, -4216, -3960, -3832, -3704, -3576, -3448, -3320, -3192, -3064, -2936, -2808, -2680, -2552, -2424, -2296, -2168, -2040, -1912, -1848, -1784, -1720, -1656, -1592, -1528, -1464, -1400, -1336, -1272, -1208, -1144, -1080, -1016, -952, -888, -856, -824, -792, -760, -728, -696, -664, -632, -600, -568, -536, -504, -472, -440, -408, -376, -360, -344, -328, -312, -296, -280, -264, -248, -232, -216, -200, -184, -168, -152, -136, -120, -112, -104, -96, -88, -80, -72, -64, -56, -48, -40, -32, -24, -16, -8, 0};

    private Utils() {
    }

    public static short toShort(byte[] byArray, boolean bl) {
        if (byArray.length == 1) {
            return byArray[0];
        }
        if (bl) {
            return (short)(byArray[0] << 8 | 0xFF & byArray[1]);
        }
        return (short)(byArray[1] << 8 | 0xFF & byArray[0]);
    }

    public static int toUnsignedShort(byte[] byArray, boolean bl) {
        if (byArray.length == 1) {
            return 0xFF & byArray[0];
        }
        if (bl) {
            return (byArray[0] & 0xFF) << 8 | 0xFF & byArray[1];
        }
        return (byArray[1] & 0xFF) << 8 | 0xFF & byArray[0];
    }

    public static void toBytes(short s, byte[] byArray, boolean bl) {
        if (bl) {
            byArray[0] = (byte)(s >> 8);
            byArray[1] = (byte)(s & 0xFF);
        } else {
            byArray[0] = (byte)(s & 0xFF);
            byArray[1] = (byte)(s >> 8);
        }
    }

    public static short bytesToShort(AudioFormat audioFormat, byte[] byArray) {
        short s = 0;
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        int n = audioFormat.getFrameSize();
        if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
            s = Utils.toShort(byArray, audioFormat.isBigEndian());
            if (n == 1) {
                s = (short)(s << 8);
            }
        } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            int n2 = Utils.toUnsignedShort(byArray, audioFormat.isBigEndian());
            if (n == 1) {
                n2 <<= 8;
            }
            s = (short)(n2 - 32768);
        } else if (encoding == AudioFormat.Encoding.ULAW) {
            s = ulawTable[byArray[0] + 128];
        } else {
            System.out.println("Unknown encoding: " + encoding);
        }
        return s;
    }

    public static short[] toSignedPCM(AudioInputStream audioInputStream) throws IOException {
        AudioFormat audioFormat = audioInputStream.getFormat();
        short[] sArray = new short[audioInputStream.available() / audioFormat.getFrameSize()];
        byte[] byArray = new byte[audioFormat.getFrameSize()];
        int n = 0;
        while (audioInputStream.read(byArray) != -1) {
            sArray[n++] = Utils.bytesToShort(audioFormat, byArray);
        }
        return sArray;
    }

    public static AudioData readAudioFile(String string) throws IOException {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(bufferedInputStream);
            AudioData audioData = new AudioData(audioInputStream);
            bufferedInputStream.close();
            return audioData;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            return null;
        }
    }

    public static AudioData readRawFile(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        AudioFormat audioFormat = new AudioFormat(8000.0f, 16, 1, true, false);
        short[] sArray = RawReader.readAudioData(fileInputStream, audioFormat);
        fileInputStream.close();
        return new AudioData(sArray, 8000.0f);
    }

    public static void writeRawFile(AudioData audioData, String string) throws IOException {
        short[] sArray;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        AudioFormat audioFormat = new AudioFormat(8000.0f, 16, 1, true, false);
        RawWriter rawWriter = new RawWriter(fileOutputStream, audioFormat);
        for (short s : sArray = audioData.getAudioData()) {
            rawWriter.writeSample(s);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
    }
}

