/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.bandwidth;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.frequencywarp.MelFrequencyFilterBank;
import edu.cmu.sphinx.frontend.transform.DiscreteFourierTransform;
import edu.cmu.sphinx.frontend.util.AudioFileDataSource;
import edu.cmu.sphinx.frontend.window.RaisedCosineWindower;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Scanner;

public class BandDetector {
    static final int bands = 40;
    static final int highRangeStart = 35;
    static final int highRangeEnd = 39;
    static final int lowRangeStart = 23;
    static final int lowRangeEnd = 29;
    static final double noSignalLevel = 0.02;
    static final double signalLevel = 0.5;
    static final double lowIntensity = 100000.0;
    private FrontEnd frontend;
    private AudioFileDataSource source = new AudioFileDataSource(320, null);

    public BandDetector() {
        RaisedCosineWindower raisedCosineWindower = new RaisedCosineWindower(0.97f, 25.625f, 10.0f);
        DiscreteFourierTransform discreteFourierTransform = new DiscreteFourierTransform(512, false);
        MelFrequencyFilterBank melFrequencyFilterBank = new MelFrequencyFilterBank(130.0, 6800.0, 40);
        ArrayList<DataProcessor> arrayList = new ArrayList<DataProcessor>();
        arrayList.add(this.source);
        arrayList.add(raisedCosineWindower);
        arrayList.add(discreteFourierTransform);
        arrayList.add(melFrequencyFilterBank);
        this.frontend = new FrontEnd(arrayList);
    }

    public static void main(String[] stringArray) throws FileNotFoundException {
        if (stringArray.length < 1) {
            System.out.println("Usage: Detector <filename.wav> or Detector <filelist>");
            return;
        }
        if (stringArray[0].endsWith(".wav")) {
            BandDetector bandDetector = new BandDetector();
            System.out.println("Bandwidth for " + stringArray[0] + " is " + bandDetector.bandwidth(stringArray[0]));
        } else {
            BandDetector bandDetector = new BandDetector();
            Scanner scanner = new Scanner(new File(stringArray[0]));
            while (scanner.hasNextLine()) {
                String string = scanner.nextLine().trim();
                if (!bandDetector.bandwidth(string)) continue;
                System.out.println("Bandwidth for " + string + " is low");
            }
            scanner.close();
        }
    }

    public boolean bandwidth(String string) {
        double d;
        Data data;
        this.source.setAudioFile(new File(string), "");
        double[] dArray = new double[40];
        while ((data = this.frontend.getData()) != null) {
            int n;
            if (!(data instanceof DoubleData)) continue;
            d = 100000.0;
            double[] dArray2 = ((DoubleData)data).getValues();
            for (n = 0; n < 40; ++n) {
                d = Math.max(d, dArray2[n]);
            }
            if (d <= 100000.0) continue;
            for (n = 0; n < 40; ++n) {
                dArray[n] = Math.max(dArray2[n] / d, dArray[n]);
            }
        }
        d = this.max(dArray, 23, 29);
        double d2 = this.max(dArray, 35, 39);
        return d2 < 0.02 && d > 0.5;
    }

    private double max(double[] dArray, int n, int n2) {
        double d = 0.0;
        for (int i = n; i <= n2; ++i) {
            d = Math.max(d, dArray[i]);
        }
        return d;
    }
}

