/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.batch;

import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;

public class BatchDecoderRecognizer {
    int ctlOffset = -1;
    int ctlCount = 1000000;
    String config;
    String hmm;
    String ctl;
    String hyp;
    String featDir;
    ConfigurationManager manager;
    StreamDataSource source;
    Recognizer recognizer;
    PrintWriter writer;

    void parseArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-ctl")) {
                this.ctl = stringArray[++i];
            }
            if (stringArray[i].equals("-config")) {
                this.config = stringArray[++i];
            }
            if (stringArray[i].equals("-hmm")) {
                this.hmm = stringArray[++i];
            }
            if (stringArray[i].equals("-ctloffset")) {
                this.ctlOffset = Integer.parseInt(stringArray[++i]);
            }
            if (stringArray[i].equals("-ctlcount")) {
                this.ctlCount = Integer.parseInt(stringArray[++i]);
            }
            if (stringArray[i].equals("-hyp")) {
                this.hyp = stringArray[++i];
            }
            if (!stringArray[i].equals("-feat")) continue;
            this.featDir = stringArray[++i];
        }
    }

    void recognize() throws IOException {
        int n;
        this.init();
        this.writer = new PrintWriter(new File(this.hyp), "UTF-8");
        Scanner scanner = new Scanner(new File(this.ctl));
        for (n = 0; n < this.ctlOffset; ++n) {
            if (!scanner.hasNext()) continue;
            scanner.next();
        }
        for (n = 0; n < this.ctlCount; ++n) {
            if (!scanner.hasNext()) continue;
            String string = scanner.next();
            String string2 = this.featDir + "/" + string + ".wav";
            this.processFile(string, string2);
        }
        this.writer.close();
        scanner.close();
        this.recognizer.deallocate();
    }

    private void processFile(String string, String string2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string2);
        this.source.setInputStream(fileInputStream);
        Result result = this.recognizer.recognize();
        this.writer.println(result.getBestFinalResultNoFiller() + " (" + string + ")");
    }

    public static void main(String[] stringArray) throws IOException {
        BatchDecoderRecognizer batchDecoderRecognizer = new BatchDecoderRecognizer();
        batchDecoderRecognizer.parseArgs(stringArray);
        batchDecoderRecognizer.recognize();
    }

    private void init() throws IOException {
        this.manager = new ConfigurationManager(this.config);
        this.recognizer = (Recognizer)this.manager.lookup("recognizer");
        this.source = (StreamDataSource)this.manager.lookup("streamDataSource");
        this.recognizer.allocate();
    }
}

