/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.batch;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.linguist.language.grammar.BatchForcedAlignerGrammar;
import edu.cmu.sphinx.linguist.language.grammar.ForcedAlignerGrammar;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.tools.batch.BatchNISTRecognizer;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public class BatchForcedAlignerRecognizer
extends BatchNISTRecognizer {
    String segFile;
    ForcedAlignerGrammar forcedAlignerGrammar;
    public BatchForcedAlignerGrammar bfaGrammar;

    @Override
    protected void setInputStream(BatchNISTRecognizer.CTLUtterance cTLUtterance) throws IOException {
        super.setInputStream(cTLUtterance);
        this.bfaGrammar.setUtterance(cTLUtterance.getName());
    }

    @Override
    protected void handleResult(DataOutputStream dataOutputStream, BatchNISTRecognizer.CTLUtterance cTLUtterance, Result result) throws IOException {
        System.out.println(cTLUtterance + " --> " + result);
        Token token = result.getBestToken();
        this.dumpTokenTimes(token);
    }

    void dumpTokenTimes(Token token) {
        if (token != null) {
            this.dumpTokenTimes(token.getPredecessor());
            System.out.println(token.getWord() + " " + token.getCollectTime());
        }
    }

    public BatchForcedAlignerRecognizer(BatchForcedAlignerGrammar batchForcedAlignerGrammar, Recognizer recognizer, List<DataProcessor> list, String string, String string2, String string3, String string4, int n, int n2, int n3, int n4) {
        super(recognizer, list, string, string2, string3, string4, n, n2, n3, n4);
        this.bfaGrammar = batchForcedAlignerGrammar;
    }

    public BatchForcedAlignerRecognizer() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        super.newProperties(propertySheet);
        this.bfaGrammar = (BatchForcedAlignerGrammar)propertySheet.getComponent("forcedAlignerGrammar");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: BatchForcedAlignerRecognizer propertiesFile");
            System.exit(1);
        }
        BatchNISTRecognizer.main(stringArray);
    }
}

