/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.batch;

import edu.cmu.sphinx.frontend.BaseDataProcessor;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.frontend.util.StreamCepstrumSource;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.frontend.util.StreamHTKCepstrum;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.BatchItem;
import edu.cmu.sphinx.util.BatchManager;
import edu.cmu.sphinx.util.CommandInterface;
import edu.cmu.sphinx.util.CommandInterpreter;
import edu.cmu.sphinx.util.PooledBatchManager;
import edu.cmu.sphinx.util.SimpleBatchManager;
import edu.cmu.sphinx.util.StatisticsVariable;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4ComponentList;
import edu.cmu.sphinx.util.props.S4Integer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class BatchModeRecognizer
implements Configurable {
    @S4Integer(defaultValue=0)
    public static final String PROP_SKIP = "skip";
    @S4Integer(defaultValue=1000000)
    public static final String PROP_COUNT = "count";
    @S4Integer(defaultValue=0)
    public static final String PROP_WHICH_BATCH = "whichBatch";
    @S4Integer(defaultValue=1)
    public static final String PROP_TOTAL_BATCHES = "totalBatches";
    @S4Boolean(defaultValue=false)
    public static final String PROP_USE_POOLED_BATCH_MANAGER = "usePooledBatchManager";
    @S4Component(type=Recognizer.class)
    public static final String PROP_RECOGNIZER = "recognizer";
    @S4ComponentList(type=BaseDataProcessor.class)
    public static final String PROP_INPUT_DATA_PROCESSORS = "inputDataProcessors";
    protected String name;
    protected List<DataProcessor> inputDataProcessors;
    protected int skip;
    protected int utteranceId;
    protected int whichBatch;
    protected int totalBatches;
    protected boolean usePooledBatchManager;
    protected BatchManager batchManager;
    protected Recognizer recognizer;
    protected Logger logger;
    protected BatchItem curBatchItem;
    protected ConfigurationManager cm;
    int count;

    public BatchModeRecognizer(Recognizer recognizer, List<DataProcessor> list, int n, int n2, int n3, int n4, boolean bl) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.cm = null;
        this.skip = n;
        this.utteranceId = n2;
        this.whichBatch = n3;
        this.totalBatches = n4;
        this.usePooledBatchManager = bl;
        this.recognizer = recognizer;
        this.inputDataProcessors = list;
    }

    public BatchModeRecognizer() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logger = propertySheet.getLogger();
        this.cm = ConfigurationManagerUtils.getPropertyManager(propertySheet);
        this.skip = propertySheet.getInt(PROP_SKIP);
        this.utteranceId = propertySheet.getInt(PROP_COUNT);
        if (this.utteranceId <= 0) {
            this.utteranceId = Integer.MAX_VALUE;
        }
        this.whichBatch = propertySheet.getInt(PROP_WHICH_BATCH);
        this.totalBatches = propertySheet.getInt(PROP_TOTAL_BATCHES);
        this.usePooledBatchManager = propertySheet.getBoolean(PROP_USE_POOLED_BATCH_MANAGER);
        this.recognizer = (Recognizer)propertySheet.getComponent(PROP_RECOGNIZER);
        this.inputDataProcessors = propertySheet.getComponentList(PROP_INPUT_DATA_PROCESSORS, DataProcessor.class);
    }

    public void setBatchFile(String string) throws IOException {
        this.batchManager = this.usePooledBatchManager ? new PooledBatchManager(string, this.skip) : new SimpleBatchManager(string, this.skip, this.whichBatch, this.totalBatches);
    }

    public void decode(String string) throws IOException {
        int n;
        try {
            BatchItem batchItem;
            this.recognizer.allocate();
            this.setBatchFile(string);
            this.batchManager.start();
            this.logger.info("BatchDecoder: decoding files in " + this.batchManager.getFilename());
            for (n = 0; n < this.utteranceId && (batchItem = this.batchManager.getNextItem()) != null; ++n) {
                this.setInputStream(batchItem.getFilename());
                Result result = this.recognizer.recognize(batchItem.getTranscript());
                this.logger.info("File  : " + batchItem.getFilename());
                this.logger.info("Result: " + result);
            }
            this.batchManager.stop();
            this.recognizer.deallocate();
        }
        catch (IOException iOException) {
            this.logger.severe("I/O error during decoding: " + iOException.getMessage());
            throw iOException;
        }
        this.logger.info("BatchDecoder: " + n + " files decoded");
    }

    void setInputStream(String string) throws IOException {
        for (DataProcessor dataProcessor : this.inputDataProcessors) {
            InputStream inputStream;
            Object object;
            block5: {
                try {
                    object = new File(string);
                    this.logger.info(AudioSystem.getAudioFileFormat((File)object).toString());
                    inputStream = AudioSystem.getAudioInputStream((File)object);
                }
                catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                    this.logger.info("Reading " + string + " as raw audio file.");
                    inputStream = new FileInputStream(string);
                    if (!string.toLowerCase().endsWith(".sph")) break block5;
                    this.logger.info("Skipping 1024-byte Sphere header.");
                    inputStream.skip(1024L);
                }
            }
            if (dataProcessor instanceof StreamDataSource) {
                ((StreamDataSource)dataProcessor).setInputStream(inputStream);
                continue;
            }
            if (dataProcessor instanceof StreamCepstrumSource) {
                boolean bl = Utilities.isCepstraFileBigEndian(string);
                StreamCepstrumSource streamCepstrumSource = (StreamCepstrumSource)dataProcessor;
                streamCepstrumSource.setInputStream(inputStream, bl);
                continue;
            }
            if (!(dataProcessor instanceof StreamHTKCepstrum)) continue;
            object = (StreamHTKCepstrum)dataProcessor;
            ((StreamHTKCepstrum)object).setInputStream(inputStream);
        }
    }

    void addCommands(CommandInterpreter commandInterpreter) {
        commandInterpreter.add("ls", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                if (stringArray.length != 1) {
                    commandInterpreter.putResponse("Usage: ls");
                } else {
                    for (String string : BatchModeRecognizer.this.cm.getInstanceNames(Configurable.class)) {
                        commandInterpreter.putResponse(string);
                    }
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "list active components";
            }
        });
        commandInterpreter.add("show", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                if (stringArray.length < 2) {
                    ConfigurationManagerUtils.showConfig(BatchModeRecognizer.this.cm);
                } else {
                    for (int i = 1; i < stringArray.length; ++i) {
                        String string = stringArray[i];
                        ConfigurationManagerUtils.showConfig(BatchModeRecognizer.this.cm, string);
                    }
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "show component configuration";
            }
        });
        commandInterpreter.add("edit", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                if (stringArray.length != 2) {
                    commandInterpreter.putResponse("Usage: edit component");
                } else {
                    try {
                        ConfigurationManagerUtils.editConfig(BatchModeRecognizer.this.cm, stringArray[1]);
                    }
                    catch (Exception exception) {
                        commandInterpreter.putResponse("Failed to save " + exception);
                    }
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "edit a  component's configuration";
            }
        });
        commandInterpreter.add("save", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                if (stringArray.length != 2) {
                    commandInterpreter.putResponse("Usage: save filename.xml");
                } else {
                    ConfigurationManagerUtils.save(BatchModeRecognizer.this.cm, new File(stringArray[1]));
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "save configuration to a file";
            }
        });
        commandInterpreter.add("set", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                if (stringArray.length != 4) {
                    commandInterpreter.putResponse("Usage: set component property value");
                } else {
                    ConfigurationManagerUtils.setProperty(BatchModeRecognizer.this.cm, stringArray[1], stringArray[3], stringArray[2]);
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "set component property to a given value";
            }
        });
        commandInterpreter.add("recognize", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                Result result = null;
                if (stringArray.length < 2) {
                    commandInterpreter.putResponse("Usage: recognize audio [transcript]");
                } else {
                    String string = stringArray[1];
                    String string2 = null;
                    if (stringArray.length > 2) {
                        string2 = stringArray[2];
                    }
                    try {
                        BatchModeRecognizer.this.setInputStream(string);
                        result = BatchModeRecognizer.this.recognizer.recognize(string2);
                    }
                    catch (IOException iOException) {
                        commandInterpreter.putResponse("I/O error during decoding: " + iOException.getMessage());
                    }
                }
                return result != null ? result.getBestResultNoFiller() : "";
            }

            @Override
            public String getHelp() {
                return "perform recognition on the given audio";
            }
        });
        commandInterpreter.addAlias("recognize", "rec");
        commandInterpreter.add("statsReset", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                if (stringArray.length != 1) {
                    commandInterpreter.putResponse("Usage: statsReset");
                } else {
                    BatchModeRecognizer.this.recognizer.resetMonitors();
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "resets gathered statistics";
            }
        });
        commandInterpreter.add("batchRecognize", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                Result result = null;
                if (stringArray.length != 1) {
                    commandInterpreter.putResponse("Usage: batchRecognize");
                } else {
                    try {
                        if (BatchModeRecognizer.this.curBatchItem == null) {
                            BatchModeRecognizer.this.batchManager.start();
                            BatchModeRecognizer.this.curBatchItem = BatchModeRecognizer.this.batchManager.getNextItem();
                        }
                        String string = BatchModeRecognizer.this.curBatchItem.getFilename();
                        String string2 = BatchModeRecognizer.this.curBatchItem.getTranscript();
                        BatchModeRecognizer.this.setInputStream(string);
                        result = BatchModeRecognizer.this.recognizer.recognize(string2);
                    }
                    catch (IOException iOException) {
                        commandInterpreter.putResponse("I/O error during decoding: " + iOException.getMessage());
                    }
                }
                return result != null ? result.getBestResultNoFiller() : "";
            }

            @Override
            public String getHelp() {
                return "perform recognition on the current batch item";
            }
        });
        commandInterpreter.addAlias("batchRecognize", "br");
        commandInterpreter.add("batchNext", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                Result result = null;
                if (stringArray.length != 1 && stringArray.length != 2) {
                    commandInterpreter.putResponse("Usage: batchNext [norec]");
                } else {
                    try {
                        if (BatchModeRecognizer.this.curBatchItem == null) {
                            BatchModeRecognizer.this.batchManager.start();
                        }
                        BatchModeRecognizer.this.curBatchItem = BatchModeRecognizer.this.batchManager.getNextItem();
                        if (BatchModeRecognizer.this.curBatchItem == null) {
                            BatchModeRecognizer.this.batchManager.start();
                            BatchModeRecognizer.this.curBatchItem = BatchModeRecognizer.this.batchManager.getNextItem();
                        }
                        String string = BatchModeRecognizer.this.curBatchItem.getFilename();
                        String string2 = BatchModeRecognizer.this.curBatchItem.getTranscript();
                        if (stringArray.length == 2) {
                            commandInterpreter.putResponse("Skipping: " + string2);
                        } else {
                            BatchModeRecognizer.this.setInputStream(string);
                            result = BatchModeRecognizer.this.recognizer.recognize(string2);
                        }
                    }
                    catch (IOException iOException) {
                        commandInterpreter.putResponse("I/O error during decoding: " + iOException.getMessage());
                    }
                }
                return result != null ? result.getBestResultNoFiller() : "";
            }

            @Override
            public String getHelp() {
                return "advance the batch and perform recognition";
            }
        });
        commandInterpreter.addAlias("batchNext", "bn");
        commandInterpreter.add("batchAll", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                Result result = null;
                if (stringArray.length != 1) {
                    commandInterpreter.putResponse("Usage: batchAll");
                } else {
                    try {
                        if (BatchModeRecognizer.this.curBatchItem == null) {
                            BatchModeRecognizer.this.batchManager.start();
                        }
                        while (true) {
                            BatchModeRecognizer.this.curBatchItem = BatchModeRecognizer.this.batchManager.getNextItem();
                            if (BatchModeRecognizer.this.curBatchItem == null) {
                                return "";
                            }
                            String string = BatchModeRecognizer.this.curBatchItem.getFilename();
                            String string2 = BatchModeRecognizer.this.curBatchItem.getTranscript();
                            BatchModeRecognizer.this.setInputStream(string);
                            result = BatchModeRecognizer.this.recognizer.recognize(string2);
                        }
                    }
                    catch (IOException iOException) {
                        commandInterpreter.putResponse("I/O error during decoding: " + iOException.getMessage());
                    }
                }
                return result != null ? result.getBestResultNoFiller() : "";
            }

            @Override
            public String getHelp() {
                return "recognize all of the remaining batch items";
            }
        });
        commandInterpreter.add("batchReset", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                if (stringArray.length != 1) {
                    commandInterpreter.putResponse("Usage: batchReset");
                } else {
                    try {
                        BatchModeRecognizer.this.batchManager.start();
                    }
                    catch (IOException iOException) {
                        commandInterpreter.putResponse("trouble reseting batch");
                    }
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "reset the batch to the beginning";
            }
        });
        commandInterpreter.add("batchLoad", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                if (stringArray.length != 2) {
                    commandInterpreter.putResponse("Usage: batchReset batchfile");
                } else {
                    try {
                        BatchModeRecognizer.this.setBatchFile(stringArray[1]);
                    }
                    catch (IOException iOException) {
                        commandInterpreter.putResponse("Can't load " + stringArray[1] + ' ' + iOException);
                    }
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "reset the batch to the beginning";
            }
        });
    }

    public void shell(String string) throws IOException {
        try {
            CommandInterpreter commandInterpreter = new CommandInterpreter();
            commandInterpreter.setPrompt("s4> ");
            this.addCommands(commandInterpreter);
            this.setBatchFile(string);
            this.recognizer.allocate();
            commandInterpreter.run();
            this.batchManager.stop();
            if (this.recognizer.getState() == Recognizer.State.READY) {
                this.recognizer.deallocate();
            }
        }
        catch (IOException iOException) {
            this.logger.severe("I/O error during decoding: " + iOException.getMessage());
            throw iOException;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: BatchDecoder propertiesFile batchFile [-shell]");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        try {
            URL uRL = new File(string).toURI().toURL();
            ConfigurationManager configurationManager = new ConfigurationManager(uRL);
            BatchModeRecognizer batchModeRecognizer = (BatchModeRecognizer)configurationManager.lookup("batch");
            if (batchModeRecognizer == null) {
                System.err.println("Can't find batchModeRecognizer in " + string);
                return;
            }
            if (stringArray.length >= 3 && stringArray[2].equals("-shell")) {
                batchModeRecognizer.shell(string2);
            } else {
                batchModeRecognizer.decode(string2);
            }
            System.out.println("Tokens created: " + StatisticsVariable.getStatisticsVariable((String)"totalTokensScored").value);
        }
        catch (Exception exception) {
            System.err.println("Error during decoding: \n  ");
            exception.printStackTrace();
        }
    }

    public void start(String string) throws IOException {
        this.recognizer.allocate();
        this.setBatchFile(string);
        this.batchManager.start();
        this.logger.info("BatchDecoder: decoding files in " + this.batchManager.getFilename());
        this.count = 0;
    }

    public void stop() throws IOException {
        this.batchManager.stop();
        this.recognizer.deallocate();
    }

    public Result recognize() throws IOException {
        BatchItem batchItem;
        Result result = null;
        if (this.count < this.utteranceId && (batchItem = this.batchManager.getNextItem()) != null) {
            this.setInputStream(batchItem.getFilename());
            result = this.recognizer.recognize(batchItem.getTranscript());
            this.logger.info("File  : " + batchItem.getFilename());
            this.logger.info("Result: " + result);
            ++this.count;
        }
        this.logger.info("BatchDecoder: " + this.count + " files decoded");
        return result;
    }
}

