/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.batch;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.frontend.util.StreamCepstrumSource;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.tools.batch.BatchModeRecognizer;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class BatchNISTRecognizer
extends BatchModeRecognizer {
    protected String ctlFile;
    protected String dataDir;
    protected String refFile;
    protected String ctmFile;
    protected int bitsPerSample;
    protected int samplesPerSecond;
    protected int framesPerSecond;
    protected int channelCount;
    protected int bytesPerFrame;
    @S4String(defaultValue="<raw data directory not set>")
    public static final String PROP_DATA_DIR = "dataDirectory";
    @S4String(defaultValue="<ctl file not set>")
    public static final String PROP_CTL_FILE = "ctlFile";
    @S4String(defaultValue="<ref file not set>")
    public static final String PROP_REF_FILE = "refFile";
    @S4String(defaultValue="<ctm file not set>")
    public static final String PROP_CTM_FILE = "ctmFile";
    @S4Integer(defaultValue=16)
    public static final String PROP_BITS_PER_SAMPLE = "bitsPerSample";
    @S4Integer(defaultValue=1)
    public static final String PROP_CHANNEL_COUNT = "channelCount";
    @S4Integer(defaultValue=16000)
    public static final String PROP_SAMPLES_PER_SECOND = "samplesPerSecond";
    @S4Integer(defaultValue=100)
    public static final String PROP_FRAMES_PER_SECOND = "framesPerSecond";

    public BatchNISTRecognizer(Recognizer recognizer, List<DataProcessor> list, String string, String string2, String string3, String string4, int n, int n2, int n3, int n4) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.recognizer = recognizer;
        this.inputDataProcessors = list;
        this.dataDir = string2;
        this.ctlFile = string;
        this.refFile = string3;
        this.ctmFile = string4;
        this.bitsPerSample = n;
        this.channelCount = n4;
        this.samplesPerSecond = n2;
        this.framesPerSecond = n3;
        this.bytesPerFrame = n / 8 * n4 * n2 / n3;
        this.logger.info("BatchNISTRecognizer:\n  dataDirectory=" + string2 + '\n' + "  ctlFile=" + string + '\n' + "  bitsPerSample=" + n + '\n' + "  channelCount=" + n4 + '\n' + "  samplesPerSecond=" + n2 + '\n' + "  framesPerSecond=" + n3 + '\n');
    }

    public BatchNISTRecognizer() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logger = propertySheet.getLogger();
        this.recognizer = (Recognizer)propertySheet.getComponent("recognizer");
        this.inputDataProcessors = propertySheet.getComponentList("inputDataProcessors", DataProcessor.class);
        this.dataDir = propertySheet.getString(PROP_DATA_DIR);
        this.ctlFile = propertySheet.getString(PROP_CTL_FILE);
        this.refFile = propertySheet.getString(PROP_REF_FILE);
        this.ctmFile = propertySheet.getString(PROP_CTM_FILE);
        this.bitsPerSample = propertySheet.getInt(PROP_BITS_PER_SAMPLE);
        this.channelCount = propertySheet.getInt(PROP_CHANNEL_COUNT);
        this.samplesPerSecond = propertySheet.getInt(PROP_SAMPLES_PER_SECOND);
        this.framesPerSecond = propertySheet.getInt(PROP_FRAMES_PER_SECOND);
        this.bytesPerFrame = this.bitsPerSample / 8 * this.channelCount * this.samplesPerSecond / this.framesPerSecond;
        this.logger.info("BatchNISTRecognizer:\n  dataDirectory=" + this.dataDir + '\n' + "  ctlFile=" + this.ctlFile + '\n' + "  bitsPerSample=" + this.bitsPerSample + '\n' + "  channelCount=" + this.channelCount + '\n' + "  samplesPerSecond=" + this.samplesPerSecond + '\n' + "  framesPerSecond=" + this.framesPerSecond + '\n');
    }

    protected void setInputStream(CTLUtterance cTLUtterance) throws IOException {
        for (DataProcessor dataProcessor : this.inputDataProcessors) {
            if (dataProcessor instanceof StreamDataSource) {
                ((StreamDataSource)dataProcessor).setInputStream(cTLUtterance.getInputStream());
                continue;
            }
            if (!(dataProcessor instanceof StreamCepstrumSource)) continue;
            boolean bl = Utilities.isCepstraFileBigEndian(cTLUtterance.getName());
            StreamCepstrumSource streamCepstrumSource = (StreamCepstrumSource)dataProcessor;
            streamCepstrumSource.setInputStream(cTLUtterance.getInputStream(), bl);
        }
    }

    public void decode() {
        try {
            this.utteranceId = 0;
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(this.ctmFile));
            this.recognizer.allocate();
            CTLIterator cTLIterator = new CTLIterator();
            while (cTLIterator.hasNext()) {
                CTLUtterance cTLUtterance = (CTLUtterance)cTLIterator.next();
                this.setInputStream(cTLUtterance);
                Result result = this.recognizer.recognize();
                System.out.println("Utterance " + this.utteranceId + ": " + cTLUtterance.getName());
                System.out.println("Reference: " + cTLUtterance.getRef());
                System.out.println("Result   : " + result);
                this.logger.info("Utterance " + this.utteranceId + ": " + cTLUtterance.getName());
                this.logger.info("Result   : " + result);
                this.handleResult(dataOutputStream, cTLUtterance, result);
                ++this.utteranceId;
            }
            this.recognizer.deallocate();
        }
        catch (IOException iOException) {
            this.logger.severe("I/O error during decoding: " + iOException.getMessage());
        }
        this.logger.info("BatchCTLDecoder: " + this.utteranceId + " utterances decoded");
    }

    protected void handleResult(DataOutputStream dataOutputStream, CTLUtterance cTLUtterance, Result result) throws IOException {
        this.dumpBestPath(dataOutputStream, cTLUtterance, result.getBestFinalToken());
    }

    private long dumpBestPath(DataOutputStream dataOutputStream, CTLUtterance cTLUtterance, Token token) throws IOException {
        if (token == null) {
            return 0L;
        }
        Token token2 = token.getPredecessor();
        long l = this.dumpBestPath(dataOutputStream, cTLUtterance, token2);
        if (token.isWord()) {
            long l2 = token.getCollectTime();
            WordSearchState wordSearchState = (WordSearchState)token.getSearchState();
            Word word = wordSearchState.getPronunciation().getWord();
            String string = word.getSpelling();
            if (!string.startsWith("<")) {
                String[] stringArray = cTLUtterance.name.split("_");
                dataOutputStream.write((stringArray[0] + '_' + stringArray[1] + '_' + stringArray[2] + " 1 " + (double)((long)cTLUtterance.startOffset + l) / 100.0 + ' ' + (double)(l2 - l) / 100.0 + ' ').getBytes());
                dataOutputStream.write(BatchNISTRecognizer.hex2Binary(string));
                dataOutputStream.write(" 0.700000\n".getBytes());
            }
            return l2;
        }
        return l;
    }

    public static byte[] hex2Binary(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            int n = BatchNISTRecognizer.hexToByte(string.charAt(i));
            int n2 = BatchNISTRecognizer.hexToByte(string.charAt(i + 1));
            byArray[i / 2] = (byte)(n2 + 16 * n);
        }
        return byArray;
    }

    private static int hexToByte(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        throw new Error("Bad hex char " + c);
    }

    public static void main(String[] stringArray) {
        BatchNISTRecognizer batchNISTRecognizer;
        if (stringArray.length != 1) {
            System.out.println("Usage: BatchNISTRecognizer propertiesFile");
            System.exit(1);
        }
        String string = stringArray[0];
        try {
            URL uRL = new File(string).toURI().toURL();
            ConfigurationManager configurationManager = new ConfigurationManager(uRL);
            batchNISTRecognizer = (BatchNISTRecognizer)configurationManager.lookup("batchNIST");
        }
        catch (IOException iOException) {
            System.err.println("I/O error during initialization: \n   " + iOException);
            return;
        }
        catch (PropertyException propertyException) {
            System.err.println("Error during initialization: \n  " + propertyException);
            return;
        }
        if (batchNISTRecognizer == null) {
            System.err.println("Can't find batchNIST in " + string);
            return;
        }
        batchNISTRecognizer.decode();
    }

    protected class CTLIterator
    implements Iterator<CTLUtterance> {
        CTLUtterance utterance;
        LineNumberReader ctlReader;
        LineNumberReader refReader;

        public CTLIterator() throws IOException {
            this.ctlReader = new LineNumberReader(new FileReader(BatchNISTRecognizer.this.ctlFile));
            this.refReader = new LineNumberReader(new FileReader(BatchNISTRecognizer.this.refFile));
            this.utterance = this.nextUtterance();
        }

        private CTLUtterance nextUtterance() {
            try {
                String string = this.ctlReader.readLine();
                String string2 = this.refReader.readLine();
                if (string == null || string2 == null) {
                    return null;
                }
                return new CTLUtterance(string, string2);
            }
            catch (Exception exception) {
                throw new Error(exception.getMessage());
            }
        }

        @Override
        public boolean hasNext() {
            return this.utterance != null;
        }

        @Override
        public CTLUtterance next() {
            CTLUtterance cTLUtterance = this.utterance;
            this.utterance = this.nextUtterance();
            return cTLUtterance;
        }

        @Override
        public void remove() {
            throw new Error("Not implemented");
        }
    }

    public class CTLUtterance {
        int startOffset;
        int endOffset;
        String name;
        byte[] data;
        final String ref;
        String file;

        public String getFile() {
            return this.file;
        }

        CTLUtterance(String string, String string2) throws CTLException {
            this.ref = string2;
            String[] stringArray = string.split(" ");
            if (stringArray.length != 4) {
                throw new CTLException("CTL Syntax Error: " + string);
            }
            this.startOffset = Integer.parseInt(stringArray[1]);
            this.endOffset = Integer.parseInt(stringArray[2]);
            this.name = stringArray[3];
            this.data = new byte[(this.endOffset - this.startOffset) * BatchNISTRecognizer.this.bytesPerFrame];
            int n = stringArray[0].indexOf(46);
            this.file = stringArray[0];
            if (n >= 0) {
                this.file = this.file.substring(0, n);
            }
            this.file = BatchNISTRecognizer.this.dataDir + '/' + this.file + ".raw";
            try {
                FileInputStream fileInputStream = new FileInputStream(this.file);
                ((InputStream)fileInputStream).skip(this.startOffset * BatchNISTRecognizer.this.bytesPerFrame);
                if (((InputStream)fileInputStream).read(this.data) != this.data.length) {
                    ((InputStream)fileInputStream).close();
                    throw new CTLException("Unable to read " + this.data.length + " bytes of utterance " + this.name);
                }
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                throw new CTLException("Unable to read utterance " + this.name + ": " + iOException.getMessage());
            }
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.data);
        }

        public String getName() {
            return this.name;
        }

        public String getRef() {
            return this.ref;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }

    protected class CTLException
    extends Exception {
        CTLException(String string) {
            super(string);
        }
    }
}

