/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.batch;

import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SphinxShell {
    public static void main(String[] stringArray) throws IOException {
        File file;
        if (stringArray.length == 0 || stringArray.length == 1 && (stringArray[0].startsWith("-h") || stringArray[0].startsWith("--h"))) {
            System.out.println("Usage: SphinxShell <config-xml-file> *([[<component>->]<parameter>=<value>] )");
            System.out.println("Example: SphinxShell foobar.xml beamWidth=123 phoneDecoder->autoAllocate=true");
            System.out.println("\nOther options are: ");
            System.out.println(" -h : Prints this help message");
            System.out.println(" -l <config-xml-file> : Prints a list of all component properties");
            System.exit(-1);
        }
        if (stringArray.length == 2 && stringArray[0].equals("-l")) {
            ConfigurationManagerUtils.dumpPropStructure(new ConfigurationManager(new File(stringArray[1]).toURI().toURL()));
            System.exit(0);
        }
        if (!(file = new File(stringArray[0])).isFile()) {
            throw new FileNotFoundException("Can not open '" + file + '\'');
        }
        ConfigurationManager configurationManager = new ConfigurationManager(file.toURI().toURL());
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            assert (stringArray2.length == 2);
            String string = stringArray2[0];
            String string2 = stringArray2[1];
            ConfigurationManagerUtils.setProperty(configurationManager, string, string2);
        }
    }
}

