/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.feature;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FloatData;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.PropertyException;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Logger;

public class FeatureFileDumper {
    private FrontEnd frontEnd;
    private StreamDataSource audioSource;
    private List<float[]> allFeatures;
    private int featureLength = -1;
    private static final Logger logger = Logger.getLogger("edu.cmu.sphinx.tools.feature.FeatureFileDumper");

    public FeatureFileDumper(ConfigurationManager configurationManager, String string) throws IOException {
        try {
            this.frontEnd = (FrontEnd)configurationManager.lookup(string);
            this.audioSource = (StreamDataSource)configurationManager.lookup("streamDataSource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void processFile(String string) throws FileNotFoundException {
        this.audioSource.setInputStream(new FileInputStream(string));
        this.allFeatures = new LinkedList<float[]>();
        this.getAllFeatures();
        logger.info("Frames: " + this.allFeatures.size());
    }

    private void getAllFeatures() {
        try {
            assert (this.allFeatures != null);
            Data data = this.frontEnd.getData();
            while (!(data instanceof DataEndSignal)) {
                Object[] objectArray;
                if (data instanceof DoubleData) {
                    objectArray = ((DoubleData)data).getValues();
                    if (this.featureLength < 0) {
                        this.featureLength = objectArray.length;
                        logger.info("Feature length: " + this.featureLength);
                    }
                    float[] fArray = new float[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        fArray[i] = (float)objectArray[i];
                    }
                    this.allFeatures.add(fArray);
                } else if (data instanceof FloatData) {
                    objectArray = ((FloatData)data).getValues();
                    if (this.featureLength < 0) {
                        this.featureLength = objectArray.length;
                        logger.info("Feature length: " + this.featureLength);
                    }
                    this.allFeatures.add((float[])objectArray);
                }
                data = this.frontEnd.getData();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int getNumberDataPoints() {
        return this.allFeatures.size() * this.featureLength;
    }

    public void dumpBinary(String string) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
        dataOutputStream.writeInt(this.getNumberDataPoints());
        for (float[] fArray : this.allFeatures) {
            for (float f : fArray) {
                dataOutputStream.writeFloat(f);
            }
        }
        dataOutputStream.close();
    }

    public void dumpAscii(String string) throws IOException {
        PrintStream printStream = new PrintStream(new FileOutputStream(string), true);
        printStream.print(this.getNumberDataPoints());
        printStream.print(' ');
        for (float[] fArray : this.allFeatures) {
            for (float f : fArray) {
                printStream.print(f);
                printStream.print(' ');
            }
        }
        printStream.close();
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = "binary";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-c")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-name")) {
                string2 = stringArray[++i];
            }
            if (stringArray[i].equals("-i")) {
                string3 = stringArray[++i];
            }
            if (stringArray[i].equals("-ctl")) {
                string4 = stringArray[++i];
            }
            if (stringArray[i].equals("-o")) {
                string5 = stringArray[++i];
            }
            if (!stringArray[i].equals("-format")) continue;
            string6 = stringArray[++i];
        }
        if (string2 == null || string3 == null && string4 == null || string5 == null || string6 == null) {
            System.out.println("Usage: FeatureFileDumper [ -config configFile ] -name frontendName < -i input File -o outputFile | -ctl inputFile -i inputFolder -o outputFolder >\nPossible frontends are: cepstraFrontEnd, spectraFrontEnd, plpFrontEnd");
            System.exit(1);
        }
        logger.info("Input file: " + string3);
        logger.info("Output file: " + string5);
        logger.info("Format: " + string6);
        try {
            URL uRL = string != null ? new File(string).toURI().toURL() : FeatureFileDumper.class.getResource("frontend.config.xml");
            ConfigurationManager configurationManager = new ConfigurationManager(uRL);
            if (configurationManager.lookup(string2) == null) {
                throw new RuntimeException("No such frontend: " + string2);
            }
            FeatureFileDumper featureFileDumper = new FeatureFileDumper(configurationManager, string2);
            if (string4 == null) {
                featureFileDumper.processFile(string3, string5, string6);
            } else {
                featureFileDumper.processCtl(string4, string3, string5, string6);
            }
        }
        catch (IOException iOException) {
            System.err.println("I/O Error " + iOException);
        }
        catch (PropertyException propertyException) {
            System.err.println("Bad configuration " + propertyException);
        }
    }

    private void processFile(String string, String string2, String string3) throws MalformedURLException, IOException {
        this.processFile(string);
        if (string3.equals("binary")) {
            this.dumpBinary(string2);
        } else if (string3.equals("ascii")) {
            this.dumpAscii(string2);
        } else {
            System.out.println("ERROR: unknown output format: " + string3);
        }
    }

    private void processCtl(String string, String string2, String string3, String string4) throws MalformedURLException, IOException {
        Scanner scanner = new Scanner(new File(string));
        while (scanner.hasNext()) {
            String string5 = scanner.next();
            String string6 = string2 + "/" + string5 + ".wav";
            String string7 = string3 + "/" + string5 + ".mfc";
            this.processFile(string6);
            if (string4.equals("binary")) {
                this.dumpBinary(string7);
                continue;
            }
            if (string4.equals("ascii")) {
                this.dumpAscii(string7);
                continue;
            }
            System.out.println("ERROR: unknown output format: " + string4);
        }
        scanner.close();
    }
}

