/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.live;

import edu.cmu.sphinx.frontend.util.ConcatFileDataSource;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.result.WordResult;
import edu.cmu.sphinx.util.GapInsertionDetector;
import edu.cmu.sphinx.util.NISTAlign;
import edu.cmu.sphinx.util.ReferenceSource;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

public class LiveModeRecognizer
implements Configurable {
    @S4Component(type=Recognizer.class)
    public static final String PROP_RECOGNIZER = "recognizer";
    @S4Component(type=ConcatFileDataSource.class)
    public static final String PROP_INPUT_SOURCE = "inputSource";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_GAP_INSERTIONS = "showGapInsertions";
    @S4String(defaultValue="hypothesis.txt")
    public static final String PROP_HYPOTHESIS_TRANSCRIPT = "hypothesisTranscript";
    @S4Integer(defaultValue=-1)
    public static final String PROP_ALIGN_INTERVAL = "alignInterval";
    private Recognizer recognizer;
    private ConcatFileDataSource dataSource;
    private String hypothesisFile;
    private boolean showGapInsertions;
    private int alignInterval;
    private int numUtterances;
    private FileWriter hypothesisTranscript;
    private ReferenceSource referenceSource;
    private final NISTAlign aligner = new NISTAlign(true, true);

    public LiveModeRecognizer(Recognizer recognizer, ConcatFileDataSource concatFileDataSource, int n, boolean bl, String string, int n2) {
        this.recognizer = recognizer;
        this.dataSource = concatFileDataSource;
        this.showGapInsertions = bl;
        this.hypothesisFile = string;
        this.alignInterval = n2;
        this.referenceSource = concatFileDataSource;
    }

    public LiveModeRecognizer() {
    }

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.recognizer = (Recognizer)propertySheet.getComponent(PROP_RECOGNIZER);
        this.dataSource = (ConcatFileDataSource)propertySheet.getComponent(PROP_INPUT_SOURCE);
        this.showGapInsertions = propertySheet.getBoolean(PROP_SHOW_GAP_INSERTIONS);
        this.hypothesisFile = propertySheet.getString(PROP_HYPOTHESIS_TRANSCRIPT);
        this.alignInterval = propertySheet.getInt(PROP_ALIGN_INTERVAL);
        this.referenceSource = this.dataSource;
    }

    public void decode() throws IOException {
        List<String> list;
        Object object;
        Result result;
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = 0;
        this.hypothesisTranscript = new FileWriter(this.hypothesisFile);
        this.recognizer.allocate();
        while ((result = this.recognizer.recognize()) != null) {
            ++this.numUtterances;
            object = result.getBestResultNoFiller();
            System.out.println("\nHYP: " + (String)object);
            System.out.println("   Sentences: " + this.numUtterances);
            linkedList.add((String)object);
            for (WordResult wordResult : result.getTimedBestResult(false)) {
                this.hypothesisTranscript.write(wordResult.toString());
                this.hypothesisTranscript.write(32);
            }
            this.hypothesisTranscript.write(10);
            this.hypothesisTranscript.flush();
            if (this.alignInterval <= 0 || this.numUtterances % this.alignInterval != 0) continue;
            list = this.referenceSource.getReferences();
            List<String> list2 = list.subList(n, list.size());
            this.alignResults(linkedList, list2);
            linkedList = new LinkedList();
            n = list.size();
        }
        this.hypothesisTranscript.close();
        object = this.referenceSource.getReferences();
        list = object.subList(n, object.size());
        if (!linkedList.isEmpty() || !list.isEmpty()) {
            this.alignResults(linkedList, list);
        }
        System.out.println("# ------------- Summary Statistics -------------");
        this.aligner.printTotalSummary();
        this.recognizer.deallocate();
        this.showLiveSummary();
        System.out.println();
    }

    private void showLiveSummary() throws IOException {
        int n = this.referenceSource.getReferences().size();
        int n2 = this.detectGapInsertionErrors();
        System.out.println("   Utterances:  Actual: " + n + "  Found: " + this.numUtterances);
        System.out.println("   Gap Insertions: " + n2);
    }

    private int detectGapInsertionErrors() throws IOException {
        Timer timer = TimerPool.getTimer(this, "GapInsertionDetector");
        timer.start();
        GapInsertionDetector gapInsertionDetector = new GapInsertionDetector(this.dataSource.getTranscriptFile(), this.hypothesisFile, this.showGapInsertions);
        int n = gapInsertionDetector.detect();
        timer.stop();
        return n;
    }

    private void alignResults(List<String> list, List<String> list2) {
        System.out.println();
        System.out.println("Aligning results...");
        System.out.println("   Utterances: Found: " + list.size() + "   Actual: " + list2.size());
        String string = this.listToString(list);
        String string2 = this.listToString(list2);
        this.saveAlignedText(string, string2);
        this.getAlignTimer().start();
        this.aligner.align(string2, string);
        this.getAlignTimer().stop();
        System.out.println(" ...done aligning");
        System.out.println();
    }

    private void saveAlignedText(String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter("align.txt");
            fileWriter.write(string);
            fileWriter.write("\n");
            fileWriter.write(string2);
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String listToString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string).append(' ');
        }
        return stringBuilder.toString();
    }

    private Timer getAlignTimer() {
        return TimerPool.getTimer(this, "Align");
    }

    public void close() throws IOException {
        this.hypothesisTranscript.close();
    }

    public static void main(String[] stringArray) {
        LiveModeRecognizer liveModeRecognizer;
        if (stringArray.length != 1) {
            System.out.println("Usage: LiveModeRecognizer config-file.xml ");
            System.exit(1);
        }
        String string = stringArray[0];
        try {
            URL uRL = new File(string).toURI().toURL();
            ConfigurationManager configurationManager = new ConfigurationManager(uRL);
            liveModeRecognizer = (LiveModeRecognizer)configurationManager.lookup("live");
        }
        catch (IOException iOException) {
            System.err.println("I/O error during initialization: \n   " + iOException);
            return;
        }
        catch (PropertyException propertyException) {
            System.err.println("Error during initialization: \n  " + propertyException);
            propertyException.printStackTrace();
            return;
        }
        if (liveModeRecognizer == null) {
            System.err.println("Can't find liveModeRecognizer in " + string);
            return;
        }
        try {
            liveModeRecognizer.decode();
        }
        catch (IOException iOException) {
            System.err.println("I/O error during decoding: " + iOException.getMessage());
        }
    }
}

