/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.trainer.Graph;
import edu.cmu.sphinx.trainer.Node;
import edu.cmu.sphinx.trainer.NodeType;
import edu.cmu.sphinx.trainer.TrainerDictionary;
import edu.cmu.sphinx.trainer.Transcript;

public class BuildTranscriptHMM {
    private Graph wordGraph;
    private Graph phonemeGraph;
    private Graph contextDependentPhoneGraph;
    private Graph hmmGraph;
    private TrainerDictionary dictionary;
    private AcousticModel acousticModel;
    private UnitManager unitManager;

    public BuildTranscriptHMM(String string, Transcript transcript, AcousticModel acousticModel, UnitManager unitManager) {
        this.acousticModel = acousticModel;
        this.unitManager = unitManager;
        this.wordGraph = this.buildWordGraph(transcript);
        assert (this.wordGraph.validate()) : "Word graph not validated";
        this.phonemeGraph = this.buildPhonemeGraph(this.wordGraph);
        assert (this.phonemeGraph.validate()) : "Phone graph not validated";
        this.contextDependentPhoneGraph = this.buildContextDependentPhonemeGraph(this.phonemeGraph);
        assert (this.contextDependentPhoneGraph.validate()) : "Context dependent graph not validated";
        this.hmmGraph = this.buildHMMGraph(this.contextDependentPhoneGraph);
        assert (this.hmmGraph.validate()) : "HMM graph not validated";
    }

    public Graph getGraph() {
        return this.hmmGraph;
    }

    private Graph buildWordGraph(Transcript transcript) {
        Dictionary dictionary = transcript.getDictionary();
        assert (dictionary.getClass().getName().endsWith("TrainerDictionary"));
        this.dictionary = (TrainerDictionary)dictionary;
        transcript.startWordIterator();
        Graph graph = new Graph();
        Node node = new Node(NodeType.UTTERANCE_BEGIN);
        graph.addNode(node);
        graph.setInitialNode(node);
        if (transcript.isExact()) {
            Node node2;
            Node node3 = node;
            transcript.startWordIterator();
            while (transcript.hasMoreWords()) {
                node2 = new Node(NodeType.WORD, transcript.nextWord());
                graph.linkNodes(node3, node2);
                node3 = node2;
            }
            node2 = new Node(NodeType.UTTERANCE_END);
            graph.linkNodes(node3, node2);
            graph.setFinalNode(node2);
        } else {
            Object object;
            Node node4 = new Node(NodeType.SILENCE_WITH_LOOPBACK);
            graph.linkNodes(node, node4);
            transcript.startWordIterator();
            while (transcript.hasMoreWords()) {
                object = transcript.nextWord();
                Pronunciation[] pronunciationArray = this.dictionary.getWord((String)object).getPronunciations();
                int n = pronunciationArray.length;
                Node[] nodeArray = new Node[n];
                Node node5 = new Node(NodeType.DUMMY);
                graph.linkNodes(node4, node5);
                Node node6 = new Node(NodeType.DUMMY);
                for (int i = 0; i < n; ++i) {
                    String string = pronunciationArray[i].getWord().getSpelling();
                    if (i > 0) {
                        string = string + "(" + i + ')';
                    }
                    nodeArray[i] = new Node(NodeType.WORD, string);
                    graph.linkNodes(node5, nodeArray[i]);
                    graph.linkNodes(nodeArray[i], node6);
                }
                node4 = new Node(NodeType.SILENCE_WITH_LOOPBACK);
                graph.linkNodes(node6, node4);
            }
            object = new Node(NodeType.UTTERANCE_END);
            graph.linkNodes(node4, (Node)object);
            graph.setFinalNode((Node)object);
        }
        return graph;
    }

    private Graph buildPhonemeGraph(Graph graph) {
        Graph graph2 = new Graph();
        graph2.copyGraph(graph);
        for (Node node : graph2.nodeToArray()) {
            if (!node.getType().equals(NodeType.WORD)) continue;
            String string = node.getID();
            Graph graph3 = this.dictionary.getWordGraph(string, false);
            graph2.insertGraph(graph3, node);
        }
        return graph2;
    }

    public Graph buildContextDependentPhonemeGraph(Graph graph) {
        Graph graph2 = new Graph();
        graph2.copyGraph(graph);
        return graph2;
    }

    public Graph buildHMMGraph(Graph graph) {
        Graph graph2 = new Graph();
        graph2.copyGraph(graph);
        for (Node node : graph2.nodeToArray()) {
            Unit unit = null;
            if (node.getType().equals(NodeType.PHONE)) {
                unit = this.unitManager.getUnit(node.getID());
            } else {
                if (!node.getType().equals(NodeType.SILENCE_WITH_LOOPBACK)) continue;
                unit = this.unitManager.getUnit("SIL");
            }
            HMM hMM = this.acousticModel.lookupNearestHMM(unit, HMMPosition.UNDEFINED, false);
            Graph graph3 = this.buildModelGraph((SenoneHMM)hMM);
            graph3.validate();
            graph2.insertGraph(graph3, node);
        }
        return graph2;
    }

    private Graph buildModelGraph(SenoneHMM senoneHMM) {
        Graph graph = new Graph();
        Node node = null;
        float[][] fArray = senoneHMM.getTransitionMatrix();
        Node node2 = new Node(NodeType.DUMMY);
        graph.addNode(node2);
        graph.setInitialNode(node2);
        for (int i = 0; i < senoneHMM.getOrder() + 1; ++i) {
            node = new Node(NodeType.STATE, senoneHMM.getUnit().getName());
            node.setObject(senoneHMM.getState(i));
            graph.addNode(node);
            if (i == 0) {
                graph.linkNodes(node2, node);
            }
            for (int j = 0; j <= i; ++j) {
                if (fArray[j][i] == -3.4028235E38f) continue;
                graph.linkNodes(graph.getNode(j + 1), node);
            }
            node2 = node;
        }
        graph.setFinalNode(node);
        return graph;
    }
}

