/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.frontend.util.StreamCepstrumSource;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer.TrainerScore;
import edu.cmu.sphinx.trainer.Learner;
import edu.cmu.sphinx.trainer.Utterance;
import edu.cmu.sphinx.trainer.UtteranceGraph;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.FileInputStream;
import java.io.IOException;

public class FlatInitializerLearner
implements Learner {
    @S4Component(type=FrontEnd.class)
    public static final String FRONT_END = "frontend";
    private FrontEnd frontEnd;
    @S4Component(type=StreamCepstrumSource.class)
    public static final String DATA_SOURCE = "source";
    private StreamCepstrumSource dataSource;
    private Data curFeature;

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.dataSource = (StreamCepstrumSource)propertySheet.getComponent(DATA_SOURCE);
        this.frontEnd = (FrontEnd)propertySheet.getComponent(FRONT_END);
        this.frontEnd.setDataSource(this.dataSource);
    }

    @Override
    public void setUtterance(Utterance utterance) throws IOException {
        String string = utterance.toString();
        FileInputStream fileInputStream = new FileInputStream(string);
        this.dataSource.setInputStream(fileInputStream, false);
    }

    private boolean getFeature() {
        try {
            this.curFeature = this.frontEnd.getData();
            if (this.curFeature == null) {
                return false;
            }
            if (this.curFeature instanceof DataStartSignal) {
                this.curFeature = this.frontEnd.getData();
                if (this.curFeature == null) {
                    return false;
                }
            }
            if (this.curFeature instanceof DataEndSignal) {
                return false;
            }
            if (this.curFeature instanceof Signal) {
                throw new Error("Can't score non-content feature");
            }
        }
        catch (DataProcessingException dataProcessingException) {
            System.out.println("DataProcessingException " + dataProcessingException);
            dataProcessingException.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void initializeComputation(Utterance utterance, UtteranceGraph utteranceGraph) throws IOException {
        this.setUtterance(utterance);
        this.setGraph(utteranceGraph);
    }

    @Override
    public void setGraph(UtteranceGraph utteranceGraph) {
        throw new Error("Flat initializer does not use a graph!");
    }

    @Override
    public TrainerScore[] getScore() {
        if (this.getFeature()) {
            TrainerScore[] trainerScoreArray = new TrainerScore[]{new TrainerScore(this.curFeature, 0.0f, -1)};
            return trainerScoreArray;
        }
        return null;
    }
}

