/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.trainer.Edge;
import edu.cmu.sphinx.trainer.Node;
import java.util.ArrayList;
import java.util.Iterator;

public class Graph {
    private ArrayList<Edge> edges = new ArrayList();
    private ArrayList<Node> nodes = new ArrayList();
    private Iterator<Edge> edgeIterator;
    private Iterator<Node> nodeIterator;
    private Node initialNode;
    private Node finalNode;

    public void setInitialNode(Node node) throws IllegalArgumentException {
        if (!this.isNodeInGraph(node)) {
            throw new IllegalArgumentException("Initial node not in graph");
        }
        this.initialNode = node;
    }

    public void setFinalNode(Node node) throws IllegalArgumentException {
        if (!this.isNodeInGraph(node)) {
            throw new IllegalArgumentException("Final node not in graph");
        }
        this.finalNode = node;
    }

    public Node getInitialNode() {
        return this.initialNode;
    }

    public Node getFinalNode() {
        return this.finalNode;
    }

    public int size() {
        return this.nodes.size();
    }

    public Node getNode(int n) {
        return this.nodes.get(n);
    }

    public Node[] nodeToArray() {
        return this.nodes.toArray(new Node[this.nodes.size()]);
    }

    public int indexOf(Node node) {
        return this.nodes.indexOf(node);
    }

    public boolean isInitialNode(Node node) {
        return node == this.initialNode;
    }

    public boolean isFinalNode(Node node) {
        return node == this.finalNode;
    }

    public Edge linkNodes(Node node, Node node2) {
        Edge edge = new Edge(node, node2);
        node.addOutgoingEdge(edge);
        node2.addIncomingEdge(edge);
        if (!this.isNodeInGraph(node)) {
            this.addNode(node);
        }
        if (!this.isNodeInGraph(node2)) {
            this.addNode(node2);
        }
        this.addEdge(edge);
        return edge;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
    }

    public boolean isNodeInGraph(Node node) {
        return this.nodes.contains(node);
    }

    public boolean isEdgeInGraph(Edge edge) {
        return this.edges.contains(edge);
    }

    public void startNodeIterator() {
        this.nodeIterator = this.nodes.iterator();
    }

    public boolean hasMoreNodes() {
        return this.nodeIterator.hasNext();
    }

    public Node nextNode() {
        return this.nodeIterator.next();
    }

    public void startEdgeIterator() {
        this.edgeIterator = this.edges.iterator();
    }

    public boolean hasMoreEdges() {
        return this.edgeIterator.hasNext();
    }

    public Edge nextEdge() {
        return this.edgeIterator.next();
    }

    public void copyGraph(Graph graph) {
        assert (this.nodes.isEmpty() && this.edges.isEmpty());
        graph.startNodeIterator();
        while (graph.hasMoreNodes()) {
            this.addNode(graph.nextNode());
        }
        graph.startEdgeIterator();
        while (graph.hasMoreEdges()) {
            this.addEdge(graph.nextEdge());
        }
        this.setInitialNode(graph.getInitialNode());
        this.setFinalNode(graph.getFinalNode());
    }

    public void insertGraph(Graph graph, Node node) {
        Object object;
        assert (this.isNodeInGraph(node)) : "Node not in graph";
        assert (graph != null) : "Graph not defined";
        assert (!this.isFinalNode(node) && !this.isInitialNode(node));
        int n = this.nodes.indexOf(node);
        this.nodes.remove(n);
        graph.startNodeIterator();
        int n2 = n;
        while (graph.hasMoreNodes()) {
            this.nodes.add(n2, graph.nextNode());
            ++n2;
        }
        graph.startEdgeIterator();
        while (graph.hasMoreEdges()) {
            this.addEdge(graph.nextEdge());
        }
        Node node2 = graph.getInitialNode();
        node.startIncomingEdgeIterator();
        while (node.hasMoreIncomingEdges()) {
            object = node.nextIncomingEdge();
            ((Edge)object).setDestination(node2);
            node2.addIncomingEdge((Edge)object);
        }
        object = graph.getFinalNode();
        node.startOutgoingEdgeIterator();
        while (node.hasMoreOutgoingEdges()) {
            Edge edge = node.nextOutgoingEdge();
            edge.setSource((Node)object);
            ((Node)object).addOutgoingEdge(edge);
        }
    }

    public boolean validate() {
        Object object;
        boolean bl = true;
        this.startNodeIterator();
        while (this.hasMoreNodes()) {
            object = this.nextNode();
            bl &= ((Node)object).validate();
            int n = ((Node)object).incomingEdgesSize();
            int n2 = ((Node)object).outgoingEdgesSize();
            if (n < 1 && !this.isInitialNode((Node)object)) {
                System.out.println("No incoming edge: " + object);
                bl = false;
            }
            ((Node)object).startIncomingEdgeIterator();
            while (((Node)object).hasMoreIncomingEdges()) {
                bl &= this.edges.contains(((Node)object).nextIncomingEdge());
            }
            if (n2 < 1 && !this.isFinalNode((Node)object)) {
                System.out.println("No outgoing edge: " + object);
                bl = false;
            }
            ((Node)object).startOutgoingEdgeIterator();
            while (((Node)object).hasMoreOutgoingEdges()) {
                bl &= this.edges.contains(((Node)object).nextOutgoingEdge());
            }
        }
        this.startEdgeIterator();
        while (this.hasMoreEdges()) {
            object = this.nextEdge();
            bl &= ((Edge)object).validate();
            bl &= this.nodes.contains(((Edge)object).getSource());
            bl &= this.nodes.contains(((Edge)object).getDestination());
        }
        return bl;
    }

    public void printGraph() {
        Object object;
        this.startNodeIterator();
        while (this.hasMoreNodes()) {
            object = this.nextNode();
            if (this.isInitialNode((Node)object)) {
                System.out.println("Initial Node");
            }
            if (this.isFinalNode((Node)object)) {
                System.out.println("Final Node");
            }
            System.out.println(object);
            ((Node)object).print();
        }
        this.startEdgeIterator();
        while (this.hasMoreEdges()) {
            object = this.nextEdge();
            System.out.println(object);
            ((Edge)object).print();
        }
    }
}

