/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.trainer.ControlFile;
import edu.cmu.sphinx.trainer.SimpleUtterance;
import edu.cmu.sphinx.trainer.TrainerDictionary;
import edu.cmu.sphinx.trainer.Utterance;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class SimpleControlFile
implements ControlFile {
    @S4Component(type=TrainerDictionary.class)
    public static final String DICTIONARY = "dictionary";
    private TrainerDictionary dictionary;
    private String audioFile;
    private String transcriptFile;
    private String wordSeparator;
    private int currentPartition;
    private int numberOfPartitions;
    private Iterator<String> audioFileIterator;
    private Iterator<String> transcriptFileIterator;
    private List<String> audioFileList;
    private List<String> transcriptFileList;
    private Logger logger;

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.logger = propertySheet.getLogger();
        this.dictionary = (TrainerDictionary)propertySheet.getComponent(DICTIONARY);
        try {
            this.dictionary.allocate();
        }
        catch (IOException iOException) {
            throw new PropertyException(iOException);
        }
        this.audioFile = propertySheet.getString("audioFile");
        this.transcriptFile = propertySheet.getString("transcriptFile");
        this.currentPartition = propertySheet.getInt("whichBatch");
        this.numberOfPartitions = propertySheet.getInt("totalBatches");
        this.logger.info("Audio control file: " + this.audioFile);
        this.logger.info("Transcript file: " + this.transcriptFile);
        this.wordSeparator = " \t\n\r\f";
        this.logger.info("Processing part " + this.currentPartition + " of " + this.numberOfPartitions);
        try {
            this.audioFileList = this.getLines(this.audioFile);
        }
        catch (IOException iOException) {
            throw new Error("IOE: Can't open file " + this.audioFile, iOException);
        }
        try {
            this.transcriptFileList = this.getLines(this.transcriptFile);
        }
        catch (IOException iOException) {
            throw new Error("IOE: Can't open file " + this.transcriptFile, iOException);
        }
    }

    @Override
    public void startUtteranceIterator() {
        this.audioFileIterator = this.audioFileList.iterator();
        this.transcriptFileIterator = this.transcriptFileList.iterator();
    }

    @Override
    public boolean hasMoreUtterances() {
        return this.audioFileIterator.hasNext() && this.transcriptFileIterator.hasNext();
    }

    @Override
    public Utterance nextUtterance() {
        this.logger.fine("processing ext utterance");
        String string = this.audioFileIterator.next() + ".mfc";
        SimpleUtterance simpleUtterance = new SimpleUtterance(string);
        String string2 = string.replaceFirst("^.*/", "").replaceFirst("\\..*$", "");
        String string3 = this.transcriptFileIterator.next();
        assert (string3.matches(".*[ \t]\\(" + string2 + "\\)$")) : "File name in transcript \"" + string3 + "\" and control file \"" + string2 + "\" have to match.";
        String string4 = string3.replaceFirst("[ \t]\\(.*\\)$", "");
        simpleUtterance.add(string4, this.dictionary, false, this.wordSeparator);
        return simpleUtterance;
    }

    private List<String> getLines(String string) throws IOException {
        List<String> list = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            list.add(string2);
        }
        bufferedReader.close();
        if (this.numberOfPartitions > 1) {
            int n = list.size() / this.numberOfPartitions;
            if (n < 1) {
                n = 1;
            }
            if (this.currentPartition >= this.numberOfPartitions) {
                this.currentPartition = this.numberOfPartitions - 1;
            }
            int n2 = this.currentPartition * n;
            list = this.currentPartition == this.numberOfPartitions - 1 ? list.subList(n2, list.size()) : list.subList(n2, n2 + n);
        }
        return list;
    }
}

