/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer.TrainerAcousticModel;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer.TrainerScore;
import edu.cmu.sphinx.trainer.ControlFile;
import edu.cmu.sphinx.trainer.Learner;
import edu.cmu.sphinx.trainer.TrainManager;
import edu.cmu.sphinx.trainer.Utterance;
import edu.cmu.sphinx.trainer.UtteranceHMMGraph;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4ComponentList;
import java.io.IOException;
import java.util.List;

public class SimpleTrainManager
implements TrainManager {
    @S4Component(type=ControlFile.class)
    public static final String CONTROL_FILE = "control";
    private ControlFile controlFile;
    private boolean dumpMemoryInfo;
    @S4Component(type=Learner.class)
    public static final String LEARNER = "learner";
    private Learner learner;
    @S4Component(type=Learner.class)
    public static final String INIT_LEARNER = "initLearner";
    private Learner initLearner;
    @S4Component(type=UnitManager.class)
    public static final String UNIT_MANAGER = "unitManager";
    private UnitManager unitManager;
    @S4ComponentList(type=TrainerAcousticModel.class)
    public static final String AM_COLLECTION = "models";
    private List<? extends TrainerAcousticModel> acousticModels;
    @S4Boolean(defaultValue=false)
    public static final String DUMP_MEMORY_INFO = "dumpMemoryInfo";
    private int maxIteration;
    private float minimumImprovement;

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.dumpMemoryInfo = propertySheet.getBoolean(DUMP_MEMORY_INFO);
        this.learner = (Learner)propertySheet.getComponent(LEARNER);
        this.controlFile = (ControlFile)propertySheet.getComponent(CONTROL_FILE);
        this.initLearner = (Learner)propertySheet.getComponent(INIT_LEARNER);
        this.minimumImprovement = propertySheet.getFloat("minimumImprovement");
        this.maxIteration = propertySheet.getInt("maximumIteration");
        this.acousticModels = propertySheet.getComponentList(AM_COLLECTION, TrainerAcousticModel.class);
        this.unitManager = (UnitManager)propertySheet.getComponent(UNIT_MANAGER);
    }

    @Override
    public void train() {
        assert (this.controlFile != null);
        this.controlFile.startUtteranceIterator();
        while (this.controlFile.hasMoreUtterances()) {
            Utterance utterance = this.controlFile.nextUtterance();
            System.out.println(utterance);
            utterance.startTranscriptIterator();
            while (utterance.hasMoreTranscripts()) {
                System.out.println(utterance.nextTranscript());
            }
        }
    }

    @Override
    public void copyModels(String string) throws IOException {
        this.loadModels(string);
        this.saveModels(string);
    }

    @Override
    public void saveModels(String string) throws IOException {
        if (1 == this.acousticModels.size()) {
            this.acousticModels.get(0).save(null);
        } else {
            for (AcousticModel acousticModel : this.acousticModels) {
                if (!(acousticModel instanceof TrainerAcousticModel)) continue;
                TrainerAcousticModel trainerAcousticModel = (TrainerAcousticModel)acousticModel;
                trainerAcousticModel.save(acousticModel.getName());
            }
        }
    }

    private void loadModels(String string) throws IOException {
        this.dumpMemoryInfo("TrainManager start");
        for (TrainerAcousticModel trainerAcousticModel : this.acousticModels) {
            trainerAcousticModel.load();
        }
        this.dumpMemoryInfo("acoustic model");
    }

    @Override
    public void initializeModels(String string) throws IOException {
        this.dumpMemoryInfo("TrainManager start");
        for (TrainerAcousticModel trainerAcousticModel : this.acousticModels) {
            this.controlFile.startUtteranceIterator();
            while (this.controlFile.hasMoreUtterances()) {
                TrainerScore[] trainerScoreArray;
                Utterance utterance = this.controlFile.nextUtterance();
                this.initLearner.setUtterance(utterance);
                while ((trainerScoreArray = this.initLearner.getScore()) != null) {
                    assert (trainerScoreArray.length == 1);
                    trainerAcousticModel.accumulate(0, trainerScoreArray);
                }
            }
            trainerAcousticModel.normalize();
        }
        this.dumpMemoryInfo("acoustic model");
    }

    @Override
    public void trainContextIndependentModels(String string) throws IOException {
        if (this.learner == null) {
            this.loadModels(string);
        }
        this.dumpMemoryInfo("TrainManager start");
        for (TrainerAcousticModel trainerAcousticModel : this.acousticModels) {
            float f = Float.MAX_VALUE;
            float f2 = 100.0f;
            for (int i = 0; i < this.maxIteration && f2 > this.minimumImprovement; ++i) {
                System.out.println("Iteration: " + i);
                trainerAcousticModel.resetBuffers();
                this.controlFile.startUtteranceIterator();
                while (this.controlFile.hasMoreUtterances()) {
                    TrainerScore[] trainerScoreArray;
                    Utterance utterance = this.controlFile.nextUtterance();
                    UtteranceHMMGraph utteranceHMMGraph = new UtteranceHMMGraph(string, utterance, trainerAcousticModel, this.unitManager);
                    this.learner.setUtterance(utterance);
                    this.learner.setGraph(utteranceHMMGraph);
                    TrainerScore[] trainerScoreArray2 = null;
                    while ((trainerScoreArray = this.learner.getScore()) != null) {
                        for (int j = 0; j < trainerScoreArray.length; ++j) {
                            if (j > 0) {
                                trainerAcousticModel.accumulate(j, trainerScoreArray, trainerScoreArray2);
                                continue;
                            }
                            trainerAcousticModel.accumulate(j, trainerScoreArray);
                        }
                        trainerScoreArray2 = trainerScoreArray;
                    }
                    trainerAcousticModel.updateLogLikelihood();
                }
                float f3 = trainerAcousticModel.normalize();
                System.out.println("Loglikelihood: " + f3);
                this.saveModels(string);
                if (i > 0) {
                    if (f != 0.0f) {
                        f2 = (f3 - f) / f * 100.0f;
                    } else if (f == f3) {
                        f2 = 0.0f;
                    }
                    System.out.println("Finished iteration: " + i + " - Improvement: " + f2);
                }
                f = f3;
            }
        }
    }

    private void dumpMemoryInfo(String string) {
        if (this.dumpMemoryInfo) {
            Utilities.dumpMemoryInfo(string);
        }
    }
}

