/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.trainer.Transcript;
import java.util.StringTokenizer;

public class SimpleTranscript
implements Transcript {
    private String transcript;
    private Dictionary dictionary;
    boolean isExact;
    private boolean wasInitialized;
    private StringTokenizer words;
    private String wordSeparator;

    public SimpleTranscript(String string) {
        if (!this.wasInitialized) {
            this.initialize(null, false);
        }
        this.transcript = string;
    }

    public SimpleTranscript(Dictionary dictionary, boolean bl) {
        this.initialize(dictionary, bl);
    }

    public SimpleTranscript(String string, Dictionary dictionary, boolean bl, String string2) {
        this.transcript = string;
        this.dictionary = dictionary;
        this.isExact = bl;
        this.wordSeparator = string2;
    }

    public SimpleTranscript(String string, Dictionary dictionary, boolean bl) {
        this.transcript = string;
        this.dictionary = dictionary;
        this.isExact = bl;
        this.wordSeparator = " \t\n\r\f";
    }

    public void initialize(Dictionary dictionary, boolean bl) {
        this.dictionary = dictionary;
        this.isExact = bl;
        this.wasInitialized = true;
    }

    @Override
    public String getTranscriptText() {
        return this.transcript;
    }

    @Override
    public Dictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public boolean isExact() {
        return this.isExact;
    }

    @Override
    public int numberOfWords() {
        return this.words.countTokens();
    }

    @Override
    public void startWordIterator() {
        this.words = new StringTokenizer(this.transcript, this.wordSeparator);
    }

    @Override
    public boolean hasMoreWords() {
        return this.words.hasMoreTokens();
    }

    @Override
    public String nextWord() {
        return this.words.nextToken();
    }

    public String toString() {
        String string = "";
        string = "Dict: " + this.dictionary + " : transcript ";
        string = this.isExact ? string + "IS exact: " : string + "is NOT exact: ";
        string = string + this.transcript;
        return string;
    }
}

