/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.trainer.Stage;
import edu.cmu.sphinx.trainer.TrainManager;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4String;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Trainer
implements Configurable {
    @S4Component(type=TrainManager.class)
    public static final String TRAIN_MANAGER = "trainManager";
    @S4String(defaultValue="_00_INITIALIZATION")
    public static final String PROP_INITIAL_STAGE = "initialStage";
    @S4String(defaultValue="_40_TIED_CD_TRAIN")
    public static final String PROP_FINAL_STAGE = "finalStage";
    private String initialStage;
    private String finalStage;
    private boolean isStageActive;
    private List<Stage> StageList = new LinkedList<Stage>();
    private Set<String> StageNames = new HashSet<String>();
    private TrainManager trainManager;

    @Override
    public void newProperties(PropertySheet propertySheet) throws PropertyException {
        this.trainManager = (TrainManager)propertySheet.getComponent(TRAIN_MANAGER);
        this.initialStage = propertySheet.getString(PROP_INITIAL_STAGE);
        this.finalStage = propertySheet.getString(PROP_FINAL_STAGE);
        this.addStage(Stage._00_INITIALIZATION);
        this.addStage(Stage._10_CI_TRAIN);
        this.addStage(Stage._20_UNTIED_CD_TRAIN);
        this.addStage(Stage._30_STATE_PRUNING);
        this.addStage(Stage._40_TIED_CD_TRAIN);
        this.addStage(Stage._90_CP_MODEL);
    }

    private void addStage(Stage stage) {
        this.StageList.add(stage);
        this.StageNames.add(stage.toString());
    }

    private void processStages(String string) {
        if (!this.StageNames.contains(this.initialStage) || !this.StageNames.contains(this.finalStage)) {
            return;
        }
        for (Stage stage : this.StageList) {
            if (!this.isStageActive && this.initialStage.equals(stage.toString())) {
                this.isStageActive = true;
            }
            if (!this.isStageActive) continue;
            try {
                if (stage.equals(Stage._00_INITIALIZATION)) {
                    System.out.println("00 - Initializing");
                    this.trainManager.initializeModels(string);
                    System.out.println("Saving");
                    this.trainManager.saveModels(string);
                } else if (stage.equals(Stage._10_CI_TRAIN)) {
                    System.out.println("01 - CI train");
                    this.trainManager.trainContextIndependentModels(string);
                    System.out.println("Saving");
                    this.trainManager.saveModels(string);
                } else if (stage.equals(Stage._20_UNTIED_CD_TRAIN)) {
                    System.out.println("02 - Untied CD train");
                } else if (stage.equals(Stage._30_STATE_PRUNING)) {
                    System.out.println("03 - State pruning");
                } else if (stage.equals(Stage._40_TIED_CD_TRAIN)) {
                    System.out.println("04 - Tied CD train");
                } else if (stage.equals(Stage._90_CP_MODEL)) {
                    System.out.println("Copying");
                    this.trainManager.copyModels(string);
                } else assert (false) : "stage not implemented";
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new Error("IOE: Can't finish trainer " + iOException, iOException);
            }
            if (!this.finalStage.equals(stage.toString())) continue;
            this.isStageActive = false;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 1) {
            System.out.println("Usage: Trainer [config]");
            System.exit(1);
        }
        String string = "trainer";
        if (stringArray.length == 1) {
            String string2 = stringArray[0];
            ConfigurationManager configurationManager = new ConfigurationManager(string2);
            Trainer trainer = (Trainer)configurationManager.lookup(string);
            trainer.processStages(string);
        }
    }
}

