/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.linguist.dictionary.TextDictionary;
import edu.cmu.sphinx.trainer.Graph;
import edu.cmu.sphinx.trainer.Node;
import edu.cmu.sphinx.trainer.NodeType;

public class TrainerDictionary
extends TextDictionary {
    static final String UTTERANCE_BEGIN_SYMBOL = "<s>";
    static final String UTTERANCE_END_SYMBOL = "</s>";
    static final String SILENCE_SYMBOL = "SIL";

    public Graph getWordGraph(String string, boolean bl) {
        Node node;
        Graph graph = new Graph();
        Node node2 = null;
        int n = 0;
        String string2 = string.replaceFirst("\\(.*\\)", "");
        if (string.equals(string2)) {
            n = 0;
        } else {
            String object2 = string.replaceFirst(".*\\(", "").replaceFirst("\\)", "");
            try {
                n = Integer.parseInt(object2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Error("Word with invalid pronunciation ID", numberFormatException);
            }
        }
        Pronunciation[] pronunciationArray = this.getWord(string2).getPronunciations();
        if (pronunciationArray == null) {
            System.out.println("Pronunciation not found for word " + string2);
            return null;
        }
        if (n >= pronunciationArray.length) {
            System.out.println("Dictionary has only " + pronunciationArray.length + " for word " + string);
            return null;
        }
        Unit[] unitArray = pronunciationArray[n].getUnits();
        assert (unitArray != null) : "units is empty: problem with dictionary?";
        if (bl) {
            Node node3 = new Node(NodeType.DUMMY);
            graph.addNode(node3);
            graph.setInitialNode(node3);
            node = node3;
        } else {
            node = null;
        }
        for (Unit unit : unitArray) {
            node2 = new Node(NodeType.PHONE, unit.getName());
            if (node == null) {
                graph.addNode(node2);
                graph.setInitialNode(node2);
            } else {
                graph.linkNodes(node, node2);
            }
            node = node2;
        }
        if (bl) {
            node2 = new Node(NodeType.DUMMY);
            graph.linkNodes(node, node2);
        }
        assert (node2 != null);
        graph.setFinalNode(node2);
        return graph;
    }

    @Override
    public String toString() {
        return "DEFAULT";
    }
}

